/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.schedule.dao;

import com.elitesland.tw.tw5.api.prd.schedule.payload.PrdScheduleRepeatPayload;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdScheduleRepeatVO;
import com.elitesland.tw.tw5.server.prd.schedule.entity.PrdScheduleRepeatDO;
import com.elitesland.tw.tw5.server.prd.schedule.entity.QPrdScheduleRepeatDO;
import com.elitesland.tw.tw5.server.prd.schedule.repo.PrdScheduleRepeatRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class PrdScheduleRepeatDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdScheduleRepeatRepo repo;
    private final QPrdScheduleRepeatDO qdo = QPrdScheduleRepeatDO.prdScheduleRepeatDO;

    public PrdScheduleRepeatDO save(PrdScheduleRepeatDO ado) {
        return (PrdScheduleRepeatDO)this.repo.save(ado);
    }

    private JPAQuery<PrdScheduleRepeatVO> getJpaQuerySelect() {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdScheduleRepeatVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.secheduleId, this.qdo.repeatType, this.qdo.repeatUntil, this.qdo.isCustomRepeat, this.qdo.repeatInterval, this.qdo.repeatDayOfWeek, this.qdo.repeatDayOfMonth, this.qdo.exdate})).from((EntityPath)this.qdo);
        return jpaQuery;
    }

    public PrdScheduleRepeatVO queryByScheduleId(Long scheduleId) {
        JPAQuery<PrdScheduleRepeatVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.secheduleId.eq((Object)scheduleId));
        return (PrdScheduleRepeatVO)jpaQuery.fetchFirst();
    }

    public long updateByKeyDynamic(PrdScheduleRepeatPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getExdate() != null) {
            update.set((Path)this.qdo.exdate, (Object)payload.getExdate());
        }
        if (payload.getRepeatUntil() != null) {
            update.set(this.qdo.repeatUntil, (Object)payload.getRepeatUntil());
        }
        if ((nullFields = payload.getNullFields()) == null || nullFields.size() > 0) {
            // empty if block
        }
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        return update.execute();
    }

    public PrdScheduleRepeatDAO(JPAQueryFactory jpaQueryFactory, PrdScheduleRepeatRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

