/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.ts.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PmsTimesheetService;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationRefVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.api.prd.ts.payload.TsApprovalResPayload;
import com.elitesland.tw.tw5.api.prd.ts.payload.TsNotaskApprovalConfigPayload;
import com.elitesland.tw.tw5.api.prd.ts.query.TsNotaskApprovalConfigQuery;
import com.elitesland.tw.tw5.api.prd.ts.query.TsNotaskApprovalConfigRuleQuery;
import com.elitesland.tw.tw5.api.prd.ts.service.TsNotaskApprovalConfigRuleService;
import com.elitesland.tw.tw5.api.prd.ts.service.TsNotaskApprovalConfigService;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsNotaskApprovalConfigRuleVO;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsNotaskApprovalConfigVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.my.constant.TimesheetStatus;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.ts.convert.TsNotaskApprovalConfigConvert;
import com.elitesland.tw.tw5.server.prd.ts.convert.TsNotaskApprovalConfigRuleConvert;
import com.elitesland.tw.tw5.server.prd.ts.dao.TsNotaskApprovalConfigDAO;
import com.elitesland.tw.tw5.server.prd.ts.dao.TsNotaskApprovalConfigRuleDAO;
import com.elitesland.tw.tw5.server.prd.ts.entity.TsNotaskApprovalConfigDO;
import com.elitesland.tw.tw5.server.prd.ts.entity.TsNotaskApprovalConfigRuleDO;
import com.elitesland.tw.tw5.server.prd.ts.repo.TsNotaskApprovalConfigRepo;
import com.elitesland.tw.tw5.server.prd.ts.repo.TsNotaskApprovalConfigRuleRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TsNotaskApprovalConfigServiceImpl
extends BaseServiceImpl
implements TsNotaskApprovalConfigService {
    private static final Logger log = LoggerFactory.getLogger(TsNotaskApprovalConfigServiceImpl.class);
    private final TsNotaskApprovalConfigRepo tsNotaskApprovalConfigRepo;
    private final TsNotaskApprovalConfigDAO tsNotaskApprovalConfigDAO;
    private final CacheUtil cacheUtil;
    private final UdcUtil udcUtil;
    private final TsNotaskApprovalConfigRuleRepo tsNotaskApprovalConfigRuleRepo;
    private final TsNotaskApprovalConfigRuleDAO tsNotaskApprovalConfigRuleDAO;
    private final TsNotaskApprovalConfigRuleService tsNotaskApprovalConfigRuleService;
    private final PmsTimesheetService pmsTimesheetService;
    private final PrdOrgOrganizationDAO prdOrgOrganizationDAO;

    public Integer insertCheck(TsNotaskApprovalConfigPayload payload) {
        int count = 0;
        count = payload.getId() != null ? this.tsNotaskApprovalConfigRepo.countByDeliBuIdAndTsYearAndIdNot(payload.getDeliBuId(), payload.getTsYear(), payload.getId()) : this.tsNotaskApprovalConfigRepo.countByDeliBuIdAndTsYear(payload.getDeliBuId(), payload.getTsYear());
        return count;
    }

    public PagingVO<TsNotaskApprovalConfigVO> queryPaging(TsNotaskApprovalConfigQuery query) {
        return this.tsNotaskApprovalConfigDAO.queryPaging(query);
    }

    public List<TsNotaskApprovalConfigVO> queryListDynamic(TsNotaskApprovalConfigQuery query) {
        return this.tsNotaskApprovalConfigDAO.queryListDynamic(query);
    }

    public TsNotaskApprovalConfigVO queryByKey(Long key) {
        TsNotaskApprovalConfigDO entity = this.tsNotaskApprovalConfigRepo.findById(key).orElseGet(TsNotaskApprovalConfigDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TsNotaskApprovalConfigVO vo = TsNotaskApprovalConfigConvert.INSTANCE.toVo(entity);
        List tsNotaskApprovalConfigRuleVOS = this.tsNotaskApprovalConfigRuleService.queryByConfigId(key);
        vo.setTsNotaskApprovalConfigRulePVOList(tsNotaskApprovalConfigRuleVOS);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TsNotaskApprovalConfigVO insert(TsNotaskApprovalConfigPayload payload) {
        int count = this.tsNotaskApprovalConfigRepo.countByDeliBuIdAndTsYear(payload.getDeliBuId(), payload.getTsYear());
        if (count > 0) {
            throw TwException.error("", payload.getTsYear() + "\u5e74" + this.cacheUtil.getOrgName(payload.getDeliBuId()) + "\u5df2\u914d\u7f6e!");
        }
        TsNotaskApprovalConfigDO entityDo = TsNotaskApprovalConfigConvert.INSTANCE.toDo(payload);
        TsNotaskApprovalConfigVO tsNotaskApprovalConfigVO = TsNotaskApprovalConfigConvert.INSTANCE.toVo((TsNotaskApprovalConfigDO)this.tsNotaskApprovalConfigRepo.save(entityDo));
        Long configVOId = tsNotaskApprovalConfigVO.getId();
        List tsNotaskApprovalConfigRulePayloadList = payload.getTsNotaskApprovalConfigRulePayloadList();
        tsNotaskApprovalConfigRulePayloadList.stream().forEach(e -> e.setConfigId(configVOId));
        if (!tsNotaskApprovalConfigRulePayloadList.isEmpty()) {
            List<TsNotaskApprovalConfigRuleDO> tsNotaskApprovalConfigRuleDOS = TsNotaskApprovalConfigRuleConvert.INSTANCE.toDoList(tsNotaskApprovalConfigRulePayloadList);
            List tsNotaskApprovalConfigRuleVOS = TsNotaskApprovalConfigRuleConvert.INSTANCE.toVoList(this.tsNotaskApprovalConfigRuleRepo.saveAll(tsNotaskApprovalConfigRuleDOS));
            tsNotaskApprovalConfigVO.setTsNotaskApprovalConfigRulePVOList(tsNotaskApprovalConfigRuleVOS);
        }
        return tsNotaskApprovalConfigVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public TsNotaskApprovalConfigVO update(TsNotaskApprovalConfigPayload payload) {
        int count = this.tsNotaskApprovalConfigRepo.countByDeliBuIdAndTsYearAndIdNot(payload.getDeliBuId(), payload.getTsYear(), payload.getId());
        if (count > 0) {
            throw TwException.error("", payload.getTsYear() + "\u5e74" + this.cacheUtil.getOrgName(payload.getDeliBuId()) + "\u5df2\u914d\u7f6e!");
        }
        List deleteConfigRuleKeys = payload.getDeleteConfigRuleKeys();
        if (!CollectionUtils.isEmpty((Collection)deleteConfigRuleKeys)) {
            this.tsNotaskApprovalConfigRuleDAO.deleteSoft(deleteConfigRuleKeys);
        }
        TsNotaskApprovalConfigDO entity = this.tsNotaskApprovalConfigRepo.findById(payload.getId()).orElseGet(TsNotaskApprovalConfigDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TsNotaskApprovalConfigDO entityDo = TsNotaskApprovalConfigConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        TsNotaskApprovalConfigVO tsNotaskApprovalConfigVO = TsNotaskApprovalConfigConvert.INSTANCE.toVo((TsNotaskApprovalConfigDO)this.tsNotaskApprovalConfigRepo.save(entity));
        List tsNotaskApprovalConfigRulePayloadList = payload.getTsNotaskApprovalConfigRulePayloadList();
        if (!tsNotaskApprovalConfigRulePayloadList.isEmpty()) {
            List<TsNotaskApprovalConfigRuleDO> tsNotaskApprovalConfigRuleDOS = TsNotaskApprovalConfigRuleConvert.INSTANCE.toDoList(tsNotaskApprovalConfigRulePayloadList);
            ArrayList<TsNotaskApprovalConfigRuleVO> tsNotaskApprovalConfigRuleVOS = new ArrayList<TsNotaskApprovalConfigRuleVO>();
            for (TsNotaskApprovalConfigRuleDO tsNotaskApprovalConfigRuleDO : tsNotaskApprovalConfigRuleDOS) {
                if (tsNotaskApprovalConfigRuleDO.getId() != null) {
                    TsNotaskApprovalConfigRuleDO tsNotaskApprovalConfigRuleEntity = this.tsNotaskApprovalConfigRuleRepo.findById(tsNotaskApprovalConfigRuleDO.getId()).orElseGet(TsNotaskApprovalConfigRuleDO::new);
                    Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
                    tsNotaskApprovalConfigRuleEntity.copy(tsNotaskApprovalConfigRuleDO);
                    tsNotaskApprovalConfigRuleVOS.add(TsNotaskApprovalConfigRuleConvert.INSTANCE.toVo((TsNotaskApprovalConfigRuleDO)this.tsNotaskApprovalConfigRuleRepo.save(tsNotaskApprovalConfigRuleEntity)));
                    continue;
                }
                tsNotaskApprovalConfigRuleDO.setConfigId(payload.getId());
                tsNotaskApprovalConfigRuleVOS.add(TsNotaskApprovalConfigRuleConvert.INSTANCE.toVo((TsNotaskApprovalConfigRuleDO)this.tsNotaskApprovalConfigRuleRepo.save(tsNotaskApprovalConfigRuleDO)));
            }
            tsNotaskApprovalConfigVO.setTsNotaskApprovalConfigRulePVOList(tsNotaskApprovalConfigRuleVOS);
        }
        return tsNotaskApprovalConfigVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(TsNotaskApprovalConfigPayload payload) {
        TsNotaskApprovalConfigDO entity = this.tsNotaskApprovalConfigRepo.findById(payload.getId()).orElseGet(TsNotaskApprovalConfigDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.tsNotaskApprovalConfigDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.tsNotaskApprovalConfigDAO.deleteSoft(keys);
            this.tsNotaskApprovalConfigRuleService.deleteSoft(keys);
        }
    }

    public List<PrdSystemSelectionVO> noTaskActivityList(LocalDate workDate) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        PrdOrgOrganizationRefVO organizationRefVO = this.cacheUtil.getUserBuLevel1(loginUserId);
        if (organizationRefVO == null) {
            throw TwException.error("", "\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5bf9\u5e94\u4e00\u7ea7\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u83b7\u53d6\u6d3b\u52a8\uff01");
        }
        if (organizationRefVO.getOrgCode().equals("BD0023")) {
            return new ArrayList<PrdSystemSelectionVO>();
        }
        Long orgId = organizationRefVO.getOrgId();
        int year = workDate.getYear();
        TsNotaskApprovalConfigQuery query = new TsNotaskApprovalConfigQuery();
        query.setEffective(Integer.valueOf(1));
        query.setTsYear(Integer.valueOf(year));
        query.setDeliBuId(orgId);
        List<TsNotaskApprovalConfigVO> tsNotaskApprovalConfigVOS = this.queryListDynamic(query);
        if (!CollectionUtils.isEmpty(tsNotaskApprovalConfigVOS)) {
            TsNotaskApprovalConfigVO tsNotaskApprovalConfigVO = this.queryByKey(tsNotaskApprovalConfigVOS.get(0).getId());
            List tsNotaskApprovalConfigRuleVOList = tsNotaskApprovalConfigVO.getTsNotaskApprovalConfigRulePVOList();
            if (!CollectionUtils.isEmpty((Collection)tsNotaskApprovalConfigRuleVOList)) {
                tsNotaskApprovalConfigRuleVOList = this.udcUtil.translateList(tsNotaskApprovalConfigRuleVOList);
                ArrayList<PrdSystemSelectionVO> systemSelectionVOS = new ArrayList();
                for (TsNotaskApprovalConfigRuleVO tsNotaskApprovalConfigRuleVO : tsNotaskApprovalConfigRuleVOList) {
                    String users;
                    List longList;
                    if (tsNotaskApprovalConfigRuleVO.getIsUser() == 1 && !(longList = Arrays.stream((users = tsNotaskApprovalConfigRuleVO.getUsers()).split(",")).map(Long::parseLong).collect(Collectors.toList())).contains(loginUserId) || !StringUtils.hasText((String)tsNotaskApprovalConfigRuleVO.getActivity())) continue;
                    PrdSystemSelectionVO systemSelection = this.cacheUtil.getSystemSelection("prd:timesheet:notask");
                    List selectionChildren = systemSelection.getChildren();
                    for (String activity : tsNotaskApprovalConfigRuleVO.getActivity().split(",")) {
                        for (PrdSystemSelectionVO selectionChild : selectionChildren) {
                            if (!selectionChild.getSelectionValue().equals(activity)) continue;
                            systemSelectionVOS.add(selectionChild);
                        }
                    }
                }
                systemSelectionVOS = systemSelectionVOS.stream().collect(Collectors.toMap(PrdSystemSelectionVO::getSelectionKey, p -> p, (p1, p2) -> p1)).values().stream().collect(Collectors.toList());
                return systemSelectionVOS;
            }
            throw TwException.error("", "\u5f53\u524d\u4e8b\u4e1a\u90e8\u5f53\u524d\u5e74\u5ea6\u65e0\u9879\u76ee\u65e0\u4efb\u52a1\u5ba1\u6279\u914d\u7f6e\u89c4\u5219\u660e\u7ec6\u7f3a\u5931\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u6d3b\u52a8\uff01");
        }
        throw TwException.error("", "\u5f53\u524d\u4e8b\u4e1a\u90e8\u5f53\u524d\u5e74\u5ea6\u65e0\u9879\u76ee\u65e0\u4efb\u52a1\u5ba1\u6279\u914d\u7f6e\u7f3a\u5931\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u6d3b\u52a8\uff01");
    }

    public Map<String, Object> noTaskApprovalConfigRule(BigDecimal worHour, LocalDate workDate, String activity) {
        PrdOrgOrganizationRefVO organizationRefVO;
        List<Object> resPayloads = new ArrayList();
        Integer ut = 0;
        int year = workDate.getYear();
        LocalDate firstDay = LocalDate.of(year, workDate.getMonth(), 1);
        LocalDate lastDay = workDate.with(TemporalAdjusters.lastDayOfMonth());
        List<LocalDate> fistDayAndLastDay = Arrays.asList(firstDay, lastDay);
        Long loginUserId = GlobalUtil.getLoginUserId();
        BigDecimal workDays = BigDecimal.ZERO;
        TimesheetQuery timesheetQuery = new TimesheetQuery();
        timesheetQuery.setTsActIden(activity);
        timesheetQuery.setTsUserId(loginUserId);
        timesheetQuery.setWorkDateBetween(fistDayAndLastDay);
        List timesheetVOS = this.pmsTimesheetService.queryList(timesheetQuery);
        if (!CollectionUtils.isEmpty((Collection)timesheetVOS)) {
            BigDecimal totalWorkHour = timesheetVOS.stream().map(TimesheetVO::getWorkHour).reduce(BigDecimal.ZERO, BigDecimal::add);
            workDays = totalWorkHour.divide(new BigDecimal(8));
        }
        if ((organizationRefVO = this.cacheUtil.getUserBuLevel1(loginUserId)) == null) {
            throw TwException.error("", "\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5bf9\u5e94\u4e00\u7ea7\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u5bf9\u5e94\u90e8\u95e8\u7684\u914d\u7f6e\uff01");
        }
        Long orgId = organizationRefVO.getOrgId();
        Long manageId = organizationRefVO.getManageId();
        TsNotaskApprovalConfigQuery query = new TsNotaskApprovalConfigQuery();
        query.setEffective(Integer.valueOf(1));
        query.setTsYear(Integer.valueOf(year));
        query.setDeliBuId(orgId);
        List<TsNotaskApprovalConfigVO> tsNotaskApprovalConfigVOS = this.queryListDynamic(query);
        if (!CollectionUtils.isEmpty(tsNotaskApprovalConfigVOS)) {
            TsNotaskApprovalConfigRuleQuery tsNotaskApprovalConfigRuleQuery = new TsNotaskApprovalConfigRuleQuery();
            tsNotaskApprovalConfigRuleQuery.setConfigId(tsNotaskApprovalConfigVOS.get(0).getId());
            tsNotaskApprovalConfigRuleQuery.setActivity(activity);
            tsNotaskApprovalConfigRuleQuery.setUsers(loginUserId.toString());
            List<TsNotaskApprovalConfigRuleVO> tsNotaskApprovalConfigRuleVOS = this.tsNotaskApprovalConfigRuleDAO.queryListDynamic(tsNotaskApprovalConfigRuleQuery);
            Long firstApprUserId = null;
            if (!CollectionUtils.isEmpty(tsNotaskApprovalConfigRuleVOS)) {
                String firstApprUserRole;
                for (TsNotaskApprovalConfigRuleVO tsNotaskApprovalConfigRuleVO : tsNotaskApprovalConfigRuleVOS) {
                    if (tsNotaskApprovalConfigRuleVO.getIsUser() != 1) continue;
                    tsNotaskApprovalConfigRuleVOS = Collections.singletonList(tsNotaskApprovalConfigRuleVO);
                    break;
                }
                TsNotaskApprovalConfigRuleVO tsNotaskApprovalConfigRuleVO = tsNotaskApprovalConfigRuleVOS.get(0);
                String scope = tsNotaskApprovalConfigRuleVO.getScope();
                BigDecimal upperLimit = tsNotaskApprovalConfigRuleVO.getUpperLimit();
                if (scope != null && upperLimit != null) {
                    switch (scope) {
                        case "person": {
                            if (workDays.compareTo(upperLimit) <= 0) break;
                            throw TwException.error("", "\u5f53\u524d\u6d3b\u52a8:[" + this.cacheUtil.getSystemSelectionNameByValue("prd:timesheet:notask", activity) + "]\u7684\u5de5\u65f6\u5df2\u7ecf\u8d85\u8fc7\u672c\u4eba\u672c\u6708\u7684\u586b\u62a5\u4e0a\u9650!");
                        }
                        case "org": {
                            Object childOrgs = this.prdOrgOrganizationDAO.queryAllChildOrgs(Collections.singletonList(orgId).stream().collect(Collectors.toSet()));
                            List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = this.prdOrgOrganizationDAO.queryEmployeeList((Set<Long>)childOrgs);
                            Set userIds = prdOrgEmployeeRefVOS.stream().map(e -> e.getUserId()).collect(Collectors.toSet());
                            timesheetQuery.setTsUserId(null);
                            timesheetQuery.setTsUserIdList(userIds);
                            timesheetVOS = this.pmsTimesheetService.queryList(timesheetQuery);
                            if (!CollectionUtils.isEmpty((Collection)timesheetVOS)) {
                                BigDecimal totalWorkHour = timesheetVOS.stream().map(TimesheetVO::getWorkHour).reduce(BigDecimal.ZERO, BigDecimal::add);
                                workDays = totalWorkHour.divide(new BigDecimal(8));
                            }
                            if (workDays.compareTo(upperLimit) <= 0) break;
                            throw TwException.error("", "\u5f53\u524d\u6d3b\u52a8:[" + this.cacheUtil.getSystemSelectionNameByValue("prd:timesheet:notask", activity) + "]\u7684\u5de5\u65f6\u5df2\u7ecf\u8d85\u8fc7\u672c\u4e8b\u4e1a\u90e8\u672c\u6708\u7684\u586b\u62a5\u4e0a\u9650!");
                        }
                    }
                }
                if ((firstApprUserRole = tsNotaskApprovalConfigRuleVO.getFirstApprUserRole()) != null) {
                    PrdOrgEmployeeRefVO userDefaultOrg = this.cacheUtil.getUserDefaultOrg(loginUserId);
                    switch (firstApprUserRole) {
                        case "PUSER": {
                            firstApprUserId = userDefaultOrg.getParentId();
                            break;
                        }
                        case "BULEADER": {
                            firstApprUserId = userDefaultOrg.getManageId();
                        }
                    }
                } else {
                    throw TwException.error("", "\u7b2c\u4e00\u5ba1\u6279\u4eba\u672a\u6307\u5b9a");
                }
                String triggerCondition = tsNotaskApprovalConfigRuleVO.getTriggerCondition();
                BigDecimal conditionDays = tsNotaskApprovalConfigRuleVO.getConditionDays();
                resPayloads = triggerCondition != null && conditionDays != null ? (triggerCondition.equals("gt") && workDays.compareTo(conditionDays) > 0 || triggerCondition.equals("ltoe") && workDays.compareTo(conditionDays) < 1 ? this.getApprovalResPayload(tsNotaskApprovalConfigRuleVO, firstApprUserId, manageId) : this.getApprovalResPayload(null, firstApprUserId, manageId)) : this.getApprovalResPayload(null, firstApprUserId, manageId);
                ut = tsNotaskApprovalConfigRuleVO.getUt();
            } else {
                resPayloads = this.getApprovalResPayload(null, firstApprUserId, manageId);
            }
        } else {
            throw TwException.error("", "\u5339\u914d\u4e0d\u5230\u5de5\u65f6\u5ba1\u6279\u914d\u7f6e\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u5ba1\u6279\u4eba\uff01");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("tsApprovalResPayloads", resPayloads);
        result.put("ut", ut);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    List<TsApprovalResPayload> getApprovalResPayload(TsNotaskApprovalConfigRuleVO tsNotaskApprovalConfigRuleVO, Long firstApprUserId, Long secondApprUserId) {
        ArrayList<TsApprovalResPayload> resPayloads = new ArrayList<TsApprovalResPayload>();
        TsApprovalResPayload firstResPayload = new TsApprovalResPayload();
        firstResPayload.setApprovalStatus(TimesheetStatus.APPROVING.getCode());
        firstResPayload.setSortIndex(Integer.valueOf(1));
        firstResPayload.setLastFlag(Integer.valueOf(0));
        firstResPayload.setApprovalResId(firstApprUserId);
        if (tsNotaskApprovalConfigRuleVO != null) {
            log.info("tsNotaskApprovalConfigRuleVOId:{}", (Object)tsNotaskApprovalConfigRuleVO.getId());
            log.info("tsNotaskApprovalConfigRuleVO:{}", (Object)tsNotaskApprovalConfigRuleVO);
            if (tsNotaskApprovalConfigRuleVO.getApprUserId() == null) throw TwException.error("", "\u83b7\u53d6\u5ba1\u6279\u914d\u7f6e\u8282\u70b91\u9519\u8bef,\u914d\u7f6eid:" + tsNotaskApprovalConfigRuleVO.getId());
            Long apprUserId = tsNotaskApprovalConfigRuleVO.getApprUserId();
            if (!apprUserId.equals(firstApprUserId)) {
                TsApprovalResPayload resPayload = new TsApprovalResPayload();
                resPayload.setConfigType("NOTASK");
                resPayload.setConfigId(tsNotaskApprovalConfigRuleVO.getId());
                resPayload.setApprovalStatus(TimesheetStatus.BEFOREAPPROVE.getCode());
                resPayload.setSortIndex(Integer.valueOf(2));
                resPayload.setLastFlag(Integer.valueOf(1));
                resPayload.setApprovalResId(apprUserId);
                resPayloads.add(firstResPayload);
                resPayloads.add(resPayload);
                return resPayloads;
            } else {
                firstResPayload.setLastFlag(Integer.valueOf(1));
                resPayloads.add(firstResPayload);
            }
            return resPayloads;
        } else if (!secondApprUserId.equals(firstApprUserId)) {
            TsApprovalResPayload resPayload = new TsApprovalResPayload();
            resPayload.setApprovalStatus(TimesheetStatus.BEFOREAPPROVE.getCode());
            resPayload.setSortIndex(Integer.valueOf(2));
            resPayload.setLastFlag(Integer.valueOf(1));
            resPayload.setApprovalResId(secondApprUserId);
            resPayloads.add(firstResPayload);
            resPayloads.add(resPayload);
            return resPayloads;
        } else {
            firstResPayload.setLastFlag(Integer.valueOf(1));
            resPayloads.add(firstResPayload);
        }
        return resPayloads;
    }

    public TsNotaskApprovalConfigServiceImpl(TsNotaskApprovalConfigRepo tsNotaskApprovalConfigRepo, TsNotaskApprovalConfigDAO tsNotaskApprovalConfigDAO, CacheUtil cacheUtil, UdcUtil udcUtil, TsNotaskApprovalConfigRuleRepo tsNotaskApprovalConfigRuleRepo, TsNotaskApprovalConfigRuleDAO tsNotaskApprovalConfigRuleDAO, TsNotaskApprovalConfigRuleService tsNotaskApprovalConfigRuleService, PmsTimesheetService pmsTimesheetService, PrdOrgOrganizationDAO prdOrgOrganizationDAO) {
        this.tsNotaskApprovalConfigRepo = tsNotaskApprovalConfigRepo;
        this.tsNotaskApprovalConfigDAO = tsNotaskApprovalConfigDAO;
        this.cacheUtil = cacheUtil;
        this.udcUtil = udcUtil;
        this.tsNotaskApprovalConfigRuleRepo = tsNotaskApprovalConfigRuleRepo;
        this.tsNotaskApprovalConfigRuleDAO = tsNotaskApprovalConfigRuleDAO;
        this.tsNotaskApprovalConfigRuleService = tsNotaskApprovalConfigRuleService;
        this.pmsTimesheetService = pmsTimesheetService;
        this.prdOrgOrganizationDAO = prdOrgOrganizationDAO;
    }
}

