/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.workflow;

import com.elitesland.tw.tw5.api.prd.salecon.payload.SaleConContractPayload;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConContractService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.salecon.dao.SaleConContractDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/SALE_CON_INVALID/callBack"})
@Transactional
public class SaleConInvalidWorkflowCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(SaleConInvalidWorkflowCallBackController.class);
    private final SaleConContractService saleConContractService;
    private final SaleConContractDAO saleConContractDAO;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        SaleConContractPayload saleConContractPayload = new SaleConContractPayload();
        saleConContractPayload.setId(Long.valueOf(Long.parseLong(businessKey)));
        SaleConContractVO saleConContractVO = this.saleConContractService.queryByKey(Long.valueOf(businessKey), new Boolean[0]);
        if (saleConContractVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    saleConContractPayload.setStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    saleConContractPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                }
                case INTERRUPT: {
                    saleConContractPayload.setStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    saleConContractPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    break;
                }
                case INVALID: {
                    saleConContractPayload.setStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    saleConContractPayload.setDeleteFlag(Integer.valueOf(1));
                    saleConContractPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                }
                case REJECTED: {
                    saleConContractPayload.setStatus(WorkFlowStatusEnum.REJECTED_WORK.getCode());
                    saleConContractPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    saleConContractPayload.setStatus(WorkFlowStatusEnum.INVALID.getCode());
                    saleConContractPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    saleConContractPayload.setApprovedTime(LocalDateTime.now());
                    break;
                }
                case APPROVING: {
                    saleConContractPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    saleConContractPayload.setStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
                }
            }
            this.saleConContractDAO.updateByKeyDynamic(saleConContractPayload);
        }
        return WorkflowResult.success(null);
    }

    public SaleConInvalidWorkflowCallBackController(SaleConContractService saleConContractService, SaleConContractDAO saleConContractDAO) {
        this.saleConContractService = saleConContractService;
        this.saleConContractDAO = saleConContractDAO;
    }
}

