/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.purchase.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseAgreementResPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseAgreementResQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseAgreementResService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementResVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.purchase.convert.PurchaseAgreementResConvert;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchaseAgreementDAO;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchaseAgreementResDAO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchaseAgreementResDO;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchaseAgreementEnum;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchaseAgreementResRepo;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class PurchaseAgreementResServiceImpl
extends BaseServiceImpl
implements PurchaseAgreementResService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseAgreementResServiceImpl.class);
    private final PurchaseAgreementResRepo purchaseAgreementResRepo;
    private final PurchaseAgreementResDAO purchaseAgreementResDAO;
    private final PurchaseAgreementDAO purchaseAgreementDAO;
    private final CacheUtil cacheUtil;

    public PagingVO<PurchaseAgreementResVO> queryPaging(PurchaseAgreementResQuery query) {
        return this.purchaseAgreementResDAO.queryPaging(query);
    }

    public List<PurchaseAgreementResVO> queryListDynamic(PurchaseAgreementResQuery query) {
        return this.purchaseAgreementResDAO.queryListDynamic(query);
    }

    public PurchaseAgreementResVO queryByKey(Long key) {
        PurchaseAgreementResDO entity = this.purchaseAgreementResRepo.findById(key).orElseGet(PurchaseAgreementResDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PurchaseAgreementResVO vo = PurchaseAgreementResConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PurchaseAgreementResVO insert(PurchaseAgreementResPayload payload) {
        String checkAgreementResResult = this.checkAgreementRes(Collections.singletonList(payload));
        if (StringUtils.hasText((String)checkAgreementResResult)) {
            throw TwException.error("", checkAgreementResResult);
        }
        PurchaseAgreementResDO entityDo = PurchaseAgreementResConvert.INSTANCE.toDo(payload);
        return PurchaseAgreementResConvert.INSTANCE.toVo((PurchaseAgreementResDO)this.purchaseAgreementResRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public PurchaseAgreementResVO update(PurchaseAgreementResPayload payload) {
        PurchaseAgreementResDO entity = this.purchaseAgreementResRepo.findById(payload.getId()).orElseGet(PurchaseAgreementResDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        String checkAgreementResResult = this.checkAgreementRes(Collections.singletonList(payload));
        if (StringUtils.hasText((String)checkAgreementResResult)) {
            throw TwException.error("", checkAgreementResResult);
        }
        PurchaseAgreementResDO entityDo = PurchaseAgreementResConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PurchaseAgreementResConvert.INSTANCE.toVo((PurchaseAgreementResDO)this.purchaseAgreementResRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PurchaseAgreementResPayload payload) {
        PurchaseAgreementResDO entity = this.purchaseAgreementResRepo.findById(payload.getId()).orElseGet(PurchaseAgreementResDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.purchaseAgreementResDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.purchaseAgreementResDAO.deleteSoft(keys);
        }
    }

    public void deleteSoftByDocumentIdList(List<Long> documentIdList) {
        this.purchaseAgreementResDAO.deleteSoftByDocumentIdList(documentIdList);
    }

    private String checkAgreementRes(List<PurchaseAgreementResPayload> payloadList) {
        StringBuilder checkAgreementResResult = new StringBuilder();
        String closeStatus = PurchaseAgreementEnum.AgreementStatus.CLOSE.getCode();
        for (PurchaseAgreementResPayload resPayload : payloadList) {
            Long resId = resPayload.getResId();
            PrdOrgEmployeeVO employee = this.cacheUtil.getEmployee(resId);
            PurchaseAgreementResQuery query = new PurchaseAgreementResQuery();
            query.setResId(resId);
            List<PurchaseAgreementResVO> purchaseAgreementResVOS = this.purchaseAgreementResDAO.queryListDynamic(query);
            Map<Long, List<PurchaseAgreementResVO>> resViewMaps = purchaseAgreementResVOS.stream().filter(resView -> !Objects.equals(resPayload.getId(), resView.getId())).collect(Collectors.groupingBy(PurchaseAgreementResVO::getDocumentId));
            block1: for (Map.Entry<Long, List<PurchaseAgreementResVO>> entry : resViewMaps.entrySet()) {
                PurchaseAgreementVO purchaseAgreementVO = this.purchaseAgreementDAO.queryByKey(entry.getKey());
                if (Objects.isNull(purchaseAgreementVO) || Objects.equals(purchaseAgreementVO.getAgreementStatus(), closeStatus)) continue;
                List<PurchaseAgreementResVO> resViews = entry.getValue();
                for (PurchaseAgreementResVO resView2 : resViews) {
                    boolean checkIsAfterEntity = resPayload.getResStartDate().isBefore(resView2.getResEndDate().plusDays(1L));
                    boolean checkIsAfterView = resView2.getResStartDate().isBefore(resPayload.getResEndDate().plusDays(1L));
                    if (!checkIsAfterEntity || !checkIsAfterView) continue;
                    checkAgreementResResult.append(employee.getEmployeeName()).append("-").append(purchaseAgreementVO.getPurchaseAgreementName()).append("\u5173\u8054\u8d44\u6e90\u7684\u671f\u95f4\u5b58\u5728\u4ea4\u53c9;");
                    continue block1;
                }
            }
        }
        return String.valueOf(checkAgreementResResult);
    }

    public PurchaseAgreementResServiceImpl(PurchaseAgreementResRepo purchaseAgreementResRepo, PurchaseAgreementResDAO purchaseAgreementResDAO, PurchaseAgreementDAO purchaseAgreementDAO, CacheUtil cacheUtil) {
        this.purchaseAgreementResRepo = purchaseAgreementResRepo;
        this.purchaseAgreementResDAO = purchaseAgreementResDAO;
        this.purchaseAgreementDAO = purchaseAgreementDAO;
        this.cacheUtil = cacheUtil;
    }
}

