package com.elitesland.tw.tw5.server.common.funConfig.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypeUploadRecordPayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypeUploadRecordQuery;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessDocTypeUploadRecordService;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypeUploadRecordVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 通用文档-文档上传标记
 *
 * @author duwh
 * @date 2023-12-22
 */
@Api(tags = "通用文档-文档上传标记")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/common/funConfig/businessDocTypeUploadRecord")
@Slf4j
public class BusinessDocTypeUploadRecordController {

private final BusinessDocTypeUploadRecordService businessDocTypeUploadRecordService;

    /**
     * 通用文档-文档上传标记-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("通用文档-文档上传标记-新增")
    public TwOutputUtil<BusinessDocTypeUploadRecordVO> insert(@RequestBody BusinessDocTypeUploadRecordPayload payload){
         return TwOutputUtil.ok(businessDocTypeUploadRecordService.insert(payload));
    }
    //
    // /**
    //  * 通用文档-文档上传标记-更新
    //  *
    //  * @param payload 有效载荷
    //  * @return {@link TwOutputUtil}
    //  */
    // @PutMapping
    // @ApiOperation("通用文档-文档上传标记-更新")
    // public TwOutputUtil<BusinessDocTypeUploadRecordVO> update(@RequestBody BusinessDocTypeUploadRecordPayload payload){
    //     return TwOutputUtil.ok(businessDocTypeUploadRecordService.update(payload));
    // }
    //
    // /**
    //  * 通用文档-文档上传标记-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
    //  *
    //  * @param payload 有效载荷
    //  * @return {@link TwOutputUtil}
    //  */
    // @PutMapping("update")
    // @ApiOperation("通用文档-文档上传标记-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    // public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody BusinessDocTypeUploadRecordPayload payload){
    //     return TwOutputUtil.ok(businessDocTypeUploadRecordService.updateByKeyDynamic(payload));
    // }

    /**
     * 通用文档-文档上传标记-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("通用文档-文档上传标记-主键查询")
    public TwOutputUtil<BusinessDocTypeUploadRecordVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(businessDocTypeUploadRecordService.queryByKey(key));
    }

    /**
     * 通用文档-文档上传标记-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("通用文档-文档上传标记-分页")
    public TwOutputUtil<PagingVO<BusinessDocTypeUploadRecordVO>> paging(BusinessDocTypeUploadRecordQuery query) {
        return TwOutputUtil.ok(businessDocTypeUploadRecordService.queryPaging(query));
    }

    /**
     * 通用文档-文档上传标记-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("通用文档-文档上传标记-查询列表")
    public TwOutputUtil<List<BusinessDocTypeUploadRecordVO>> queryList(BusinessDocTypeUploadRecordQuery query) {
        return TwOutputUtil.ok(businessDocTypeUploadRecordService.queryListDynamic(query));
    }

    /**
     * 通用文档-文档上传标记-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("通用文档-文档上传标记-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         businessDocTypeUploadRecordService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

