package com.elitesland.tw.tw5.server.common.funConfig.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypeConfigPayload;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypePermissionPrevRecordPayload;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypeRefPayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.*;
import com.elitesland.tw.tw5.api.common.funConfig.service.*;
import com.elitesland.tw.tw5.api.common.funConfig.vo.*;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.constants.BusinessDocTypeRuleConditionEnum;
import com.elitesland.tw.tw5.server.common.funConfig.config.FunConfigProperties;
import com.elitesland.tw.tw5.server.common.funConfig.convert.BusinessDocTypeConfigConvert;
import com.elitesland.tw.tw5.server.common.funConfig.dao.BusinessDocTypeConfigDAO;
import com.elitesland.tw.tw5.server.common.funConfig.dao.BusinessDocTypeConfigRuleDAO;
import com.elitesland.tw.tw5.server.common.funConfig.entity.BusinessDocTypeConfigDO;
import com.elitesland.tw.tw5.server.common.funConfig.repo.BusinessDocTypeConfigRepo;
import com.elitesland.tw.tw5.server.common.funConfig.support.BusinessDocTypeCheckAuthorityFactory;
import com.elitesland.tw.tw5.server.common.funConfig.support.BusinessDocTypeCheckAuthorityService;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.yeedoc.config.YeedocProperties;
import com.elitesland.tw.tw5.server.yeedoc.service.YeedocService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import java.math.BigInteger;
import java.util.*;

/**
 * 易稻壳yeedoc通用文档类型配置表
 *
 * @author duwh
 * @date 2023-12-07
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessDocTypeConfigServiceImpl extends BaseServiceImpl implements BusinessDocTypeConfigService {

    private final BusinessDocTypeConfigRepo businessDocTypeConfigRepo;
    private final BusinessDocTypeConfigDAO businessDocTypeConfigDAO;
    private final BusinessTableService businessTableService;
    private final BusinessTableFieldsService businessTableFieldsService;
    private final BusinessDocTypeConfigRuleDAO businessDocTypeConfigRuleDAO;
    private final BusinessDocTypeRefService businessDocTypeRefService;
    private final CacheUtil cacheUtil;
    private final YeedocService yeedocService;
    private final BusinessDocTypePermissionPrevRecordService businessDocTypePermissionPrevRecordService;
    private final BusinessDocTypeConfigAllowRoleService businessDocTypeConfigAllowRoleService;
    private final BusinessDocTypeConfigRoleRefService businessDocTypeConfigRoleRefService;
    private final FunConfigProperties funConfigProperties;

    /**
     * yeedoc属性配置
     */
    private final YeedocProperties yeedocProperties;
    @PersistenceContext
    private EntityManager em;

    @Override
    public PagingVO<BusinessDocTypeConfigVO> queryPaging(BusinessDocTypeConfigQuery query) {
        return businessDocTypeConfigDAO.queryPaging(query);
    }

    @Override
    public List<BusinessDocTypeConfigVO> queryListDynamic(BusinessDocTypeConfigQuery query) {
        return businessDocTypeConfigDAO.queryListDynamic(query);
    }

    @Override
    public Long count(BusinessDocTypeConfigQuery query) {
        return businessDocTypeConfigDAO.count(query);
    }

    @Override
    public BusinessDocTypeConfigVO queryByKey(Long key) {
        BusinessDocTypeConfigDO entity = businessDocTypeConfigRepo.findById(key).orElseGet(BusinessDocTypeConfigDO::new);
        Assert.notNull(entity.getId(), "文档类型配置不存在");
        BusinessDocTypeConfigVO vo = BusinessDocTypeConfigConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessDocTypeConfigVO insert(BusinessDocTypeConfigPayload payload) {
        // 检查
        check(payload);
        // 数据初始化
        initData(payload);

        BusinessDocTypeConfigDO entityDo = BusinessDocTypeConfigConvert.INSTANCE.toDo(payload);
        // 默认不需要权限
        if (ObjectUtils.isEmpty(entityDo.getPermissionControlFlag())) {
            entityDo.setPermissionControlFlag(Boolean.FALSE);
        }
        // 默认 启用
        if (ObjectUtils.isEmpty(entityDo.getEnabled())) {
            entityDo.setEnabled(Boolean.TRUE);
        }
        return BusinessDocTypeConfigConvert.INSTANCE.toVo(businessDocTypeConfigRepo.save(entityDo));
    }

    /**
     * 初始化数据
     *
     * @param payload 有效载荷
     */
    private void initData(BusinessDocTypeConfigPayload payload) {
        if (!ObjectUtils.isEmpty(payload.getTableId())) {
            BusinessTableVO businessTableVO = businessTableService.queryByKey(payload.getTableId());
            payload.setTableName(businessTableVO.getTableName());
        }
        if (!ObjectUtils.isEmpty(payload.getFieldId())) {
            BusinessTableFieldsVO businessTableFieldsVO = businessTableFieldsService.queryByKey(payload.getFieldId());
            payload.setFieldShowName(businessTableFieldsVO.getShowName());
        }

    }

    /**
     * 检查
     *
     * @param payload 有效载荷
     */
    private void check(BusinessDocTypeConfigPayload payload) {
        if (ObjectUtils.isEmpty(payload.getFunctionId())) {
            throw TwException.error("", "functionId 不能为空");
        }
        if (ObjectUtils.isEmpty(payload.getName())) {
            throw TwException.error("", "名称不能为空");
        }

        BusinessDocTypeConfigQuery query = new BusinessDocTypeConfigQuery();
        query.setFunctionId(payload.getFunctionId());
        query.setName(payload.getName());
        query.setIdNe(payload.getId());
        // 校验唯一性
        Long count = count(query);
        if (count > 0) {
            log.error("文档类型名称不可重复，一个功能配置下文档类型名称唯一！");
            throw TwException.error("", "已存在此文档类型");
        }

        if (!ObjectUtils.isEmpty(payload.getTableId())) {
            if (ObjectUtils.isEmpty(payload.getFieldId())) {
                throw TwException.error("", "请选择表属性");
            }
        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessDocTypeConfigVO update(BusinessDocTypeConfigPayload payload) {
        BusinessDocTypeConfigDO entity = businessDocTypeConfigRepo.findById(payload.getId()).orElseGet(BusinessDocTypeConfigDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessDocTypeConfigDO entityDo = BusinessDocTypeConfigConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessDocTypeConfigConvert.INSTANCE.toVo(businessDocTypeConfigRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(BusinessDocTypeConfigPayload payload) {
        BusinessDocTypeConfigDO entity = businessDocTypeConfigRepo.findById(payload.getId()).orElseGet(BusinessDocTypeConfigDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = businessDocTypeConfigDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            businessDocTypeConfigDAO.deleteSoft(keys);
            // keys.stream().forEach(id -> {
            //     Optional<BusinessDocTypeConfigDO> optional = businessDocTypeConfigRepo.findById(id);
            //     if (!optional.isEmpty()) {
            //         BusinessDocTypeConfigDO entity = optional.get();
            //
            //         // 方式一
            //         // BusinessDocTypeConfigRuleQuery query = new BusinessDocTypeConfigRuleQuery();
            //         // query.setConfigId(entity.getId());
            //         // long count = businessDocTypeConfigRuleDAO.count(query);
            //         // if (count > 0) {
            //         //     throw TwException.error("", "请先删除存储规则");
            //         // }
            //         businessDocTypeConfigRepo.save(entity);
            //     }
            // });

            // 方式二
            // 级联删除规则配置
            businessDocTypeConfigRuleDAO.deleteSoftByConfigId(keys);


        }
    }

    /**
     * 获取yeeedoc信息
     *
     * @param docId            文档id
     * @param docType          单据类型
     * @param configId         配置id
     * @param createFolderName 创建文件夹名称
     * @return {@link BusinessDocTypePermissionPrevRecordVO}
     */
    @Override
    public BusinessDocTypePermissionPrevRecordVO getYeeedocInfo(Long docId, String docType, Long configId, String createFolderName) {
        // 查询当前登录人userId
        Long loginUserId = GlobalUtil.getLoginUserId();
        // 查询当前登录人组织id
        Long orgId = cacheUtil.getDefaultOrgIdByUserId(loginUserId);
        // 查询当前登录人角色
        List<String> roleList = cacheUtil.getSystemRoleCodesNoCache(loginUserId);
        boolean systemAdmin = cacheUtil.isSystemAdmin();
        return getYeeedocInfo(systemAdmin, loginUserId, orgId, roleList, docId, docType, configId, createFolderName);
    }

    /**
     * 获取yeeedoc信息
     *
     * @param systemAdmin      是否是系统管理员
     * @param userId           用户id
     * @param orgId            组织id
     * @param roleList         角色列表
     * @param docId            文档id
     * @param docType          单据类型
     * @param configId         配置id
     * @param createFolderName 创建文件夹名称
     * @return {@link BusinessDocTypePermissionPrevRecordVO}
     */
    @Override
    public BusinessDocTypePermissionPrevRecordVO getYeeedocInfo(boolean systemAdmin, Long userId, Long orgId, List<String> roleList, Long docId, String docType, Long configId, String createFolderName) {
        // 参数检查
        checkYeedocInfoQuery(docId, docType, configId, createFolderName);

        BusinessDocTypeConfigVO businessDocTypeConfigVO = queryByKey(configId);

        //TODO 文档配置类型 是否启用校验
        // if (businessDocTypeConfigVO.getEnabled() == null || !businessDocTypeConfigVO.getEnabled()) {
        //     throw TwException.error("", "文档配置类型未启用，请联系管理员");
        // }

        Boolean checkAuthFlag = funConfigProperties.getDocType().getPermissionFlag();
        if (checkAuthFlag) {
            // 权限校验
            checkAuthority(systemAdmin, userId, orgId, roleList, docId, docType, businessDocTypeConfigVO);
        }

        // 文件类型 名称
        final String configName = businessDocTypeConfigVO.getName();
        log.info("文件类型名称：{}", configName);

        Long tableId = businessDocTypeConfigVO.getTableId();
        String tableName = businessDocTypeConfigVO.getTableName();
        if (ObjectUtils.isEmpty(tableName)) {
            // 现查一次 表名称
            if (!ObjectUtils.isEmpty(tableId)) {
                BusinessTableVO businessTableVO = businessTableService.queryByKey(tableId);
                tableName = businessTableVO.getTableName();
            }
        }
        // 业务对象表下的 所有字段  table里的字段
        List<BusinessTableFieldsVO> businessTableFieldsVOS = new ArrayList<>();
        if (null != tableId) {
            BusinessTableFieldsQuery fieldsQuery = new BusinessTableFieldsQuery();
            fieldsQuery.setTableId(tableId);
            businessTableFieldsVOS = businessTableFieldsService.queryListDynamic(fieldsQuery);
        }

        // 匹配符合条件的 文档配置规则
        BusinessDocTypeConfigRuleVO ruleResult = getBusinessDocTypeConfigRuleVO(docId, configId, tableName, businessTableFieldsVOS);
        if (ruleResult == null) {
            log.error("通用文档管理异常：未匹配到规则");
            BusinessDocTypePermissionPrevRecordVO recordVO = new BusinessDocTypePermissionPrevRecordVO();
            recordVO.setOk(false);
            recordVO.setWarnInfo("未配置此类文档的存储路径");
            return recordVO;
            // throw TwException.error("DOC_TYPE_CONFIG_RULE_NOT_FOUND", "未配置此类文档的存储路径");
        }


        String floderIdResult = "";
        String libraryIdResult = "";
        String floderNameResult = "";
        Long docTypeRefId = null;
        Long configRuleIdResult = null;

        final Long configRuleId = ruleResult.getId();
        configRuleIdResult = configRuleId;
        final String itemId = ruleResult.getItemId();
        final String libraryId = ruleResult.getLibraryId();
        libraryIdResult = libraryId;
        // 先查询 是否已经创建过易稻壳目录
        BusinessDocTypeRefVO docTypeRefVO = businessDocTypeRefService.getByDocTypeAndDocIdAndRuleId(docType, docId, configRuleIdResult);
        // 如果没有创建过
        if (null == docTypeRefVO) {
            log.info("项目未创建易稻壳目录，开始创建");
            // 创建文件夹
            Result result = createFolder(createFolderName, itemId, libraryId);
            floderIdResult = result.floderId();
            floderNameResult = result.floderName();

            // 调用易稻壳创建文件夹，且保存 易稻壳返回的文件夹id与业务单据主键的关系
            log.info("项目已创建易稻壳目录--完成");
            BusinessDocTypeRefPayload docTypeRefPayload = new BusinessDocTypeRefPayload();
            docTypeRefPayload.setDocId(docId);
            docTypeRefPayload.setDocType(docType);
            docTypeRefPayload.setConfigId(configId);
            docTypeRefPayload.setLibraryId(libraryId);
            docTypeRefPayload.setFolderId(result.floderId());
            docTypeRefPayload.setFolderName(result.floderName());
            docTypeRefPayload.setConfigName(configName);
            docTypeRefPayload.setConfigRuleId(configRuleId);
            BusinessDocTypeRefVO insert = businessDocTypeRefService.insert(docTypeRefPayload);
            docTypeRefId = insert.getId();
        } else {
            floderIdResult = docTypeRefVO.getFolderId();
            libraryIdResult = docTypeRefVO.getLibraryId();
            docTypeRefId = docTypeRefVO.getId();
        }

        if (ObjectUtils.isEmpty(floderIdResult)) {
            log.error("通用文档管理异常[调用易道壳创建文件夹]-floderIdResult:{}", floderIdResult);
            throw TwException.error("DOC_TYPE_CONFIG_YEEDOC_CREATE_FLODER_ERROR", "易道壳创建文件失败，请联系管理员");
        }
        // 判断文件夹名称是否有变化
        if (createFolderName.startsWith("/")) {
            createFolderName = createFolderName.substring(1, createFolderName.length());
        }

        //----- 如果业务文件夹名称修改的话；修改易道壳文件夹名称 -----
        if (!createFolderName.equals(floderNameResult)) {
            Map<String, Object> map = new HashMap<>();
            map.put("ItemId", floderIdResult);
            map.put("NewName", createFolderName);
            yeedocService.reNameFolder(map);

            // 名称不重要 ，tw这边只缓存第一次创建的
            if (null != docTypeRefId) {
                BusinessDocTypeRefPayload docTypeRefPayload = new BusinessDocTypeRefPayload();
                docTypeRefPayload.setId(docTypeRefId);
                docTypeRefPayload.setFolderName(createFolderName);
                businessDocTypeRefService.updateByKeyDynamic(docTypeRefPayload);
            }
        }

        //  授权记录表
        // 判断易稻壳是否授权过
        BusinessDocTypePermissionPrevRecordQuery permissionQuery = new BusinessDocTypePermissionPrevRecordQuery();
        permissionQuery.setUserId(userId);
        permissionQuery.setDocId(docId);
        permissionQuery.setDocType(docType);
        permissionQuery.setConfigId(configId);
        permissionQuery.setConfigRuleId(configRuleIdResult);
        List<BusinessDocTypePermissionPrevRecordVO> permissionPrevRecordVOS = businessDocTypePermissionPrevRecordService.queryListDynamic(permissionQuery);
        BusinessDocTypePermissionPrevRecordVO permissionPrevRecordVO = null;
        if (!CollectionUtils.isEmpty(permissionPrevRecordVOS)) {
            permissionPrevRecordVO = permissionPrevRecordVOS.get(0);
        }
        // 未被 赋权限的情况下
        if (permissionPrevRecordVO == null || (permissionPrevRecordVO != null && !permissionPrevRecordVO.getPermissionFlag())) {
            log.info("项目已创建易稻壳目录，易稻壳人员赋权限");
            BusinessDocTypePermissionPrevRecordPayload permissionPrevRecordPayload;
            if (permissionPrevRecordVO == null) {
                permissionPrevRecordPayload = new BusinessDocTypePermissionPrevRecordPayload();
                permissionPrevRecordPayload.setConfigId(configId);
                permissionPrevRecordPayload.setConfigRuleId(configRuleIdResult);
                permissionPrevRecordPayload.setLibraryId(libraryIdResult);
                permissionPrevRecordPayload.setDocId(docId);
                permissionPrevRecordPayload.setDocType(docType);
                permissionPrevRecordPayload.setUserId(userId);

            } else {
                permissionPrevRecordPayload = new BusinessDocTypePermissionPrevRecordPayload();
                permissionPrevRecordPayload.setId(permissionPrevRecordVO.getId());
            }

            boolean permissionFlag = false;
            String[] permission = yeedocProperties.getPermission();
            List<String> permissionIds = Arrays.asList(permission);
            String permissionsStr = yeedocService.setPermission(floderIdResult, permissionIds);
            if (ObjectUtils.isEmpty(permissionsStr)) {
                log.error("通用文档管理异常[调用易道壳文件夹赋权]! permissionsStr:{} ;floderIdResult:{}", permissionsStr, floderIdResult);
                // throw TwException.error("DOC_TYPE_CONFIG_YEEDOC_CREATE_FLODER_ERROR", "易道壳文件夹赋权失败，请联系管理员");
            }
            if (!(Boolean) JSONObject.parseObject(permissionsStr).get("IsSuccess")) {
                log.error("通用文档管理异常[调用易道壳文件夹赋权]! permissionsStr:{} ;floderIdResult:{}", permissionsStr, floderIdResult);
                // throw TwException.error("DOC_TYPE_CONFIG_YEEDOC_CREATE_FLODER_ERROR", "易道壳文件夹赋权失败，请联系管理员");
            } else {
                permissionFlag = true;
            }


            String previewUri = "";
            String itemNameResult = "";
            String itemPathResult = "";
            // 这一步意义不大；（后续考虑删除） 易道壳返回链接
            String preViewItemStr = yeedocService.preViewItemPro(floderIdResult);
            if (ObjectUtils.isEmpty(preViewItemStr)) {
                log.error("通用文档管理异常[调用易道壳文件夹预览地址]! preViewItemStr:{} ;floderIdResult:{}", preViewItemStr, floderIdResult);
                // throw TwException.error("DOC_TYPE_CONFIG_YEEDOC_CREATE_FLODER_ERROR", "易道壳文件夹链接地址请求异常，请联系管理员");
            }
            JSONObject resultJson = JSONObject.parseObject(preViewItemStr);
            JSONObject data = resultJson.getJSONObject("Data");
            if (ObjectUtils.isEmpty(data)) {
                log.error("通用文档管理异常[调用易道壳文件夹预览地址]! preViewItemStr:{} ;floderIdResult:{}", preViewItemStr, floderIdResult);
                // throw TwException.error("DOC_TYPE_CONFIG_YEEDOC_CREATE_FLODER_ERROR", "易道壳文件夹链接地址请求异常，请联系管理员");
            } else {
                // 预览文件地址 Preview
                //  文件名   ItemName
                //   文件路径  ItemPath
                String preview = data.getString("Preview");
                previewUri = preview;
                String itemName = data.getString("ItemName");
                itemNameResult = itemName;
                String itemPath = data.getString("ItemPath");
                itemPathResult = itemPath;
                log.debug("易稻壳预览地址:{}", previewUri);
                log.debug("易稻壳文件名:{}", itemName);
                log.debug("易稻壳文件路径:{}", itemPath);
            }

            if (permissionPrevRecordVO == null) {
                permissionPrevRecordPayload.setFolderId(floderIdResult);
                permissionPrevRecordPayload.setFolderName(itemNameResult);
                permissionPrevRecordPayload.setPermissionFlag(permissionFlag);
                permissionPrevRecordPayload.setPreviewUri(previewUri);
                permissionPrevRecordPayload.setItemPath(itemPathResult);
                permissionPrevRecordVO = businessDocTypePermissionPrevRecordService.insert(permissionPrevRecordPayload);
            } else {
                permissionPrevRecordVO = businessDocTypePermissionPrevRecordService.update(permissionPrevRecordPayload);
            }

            log.info("项目已创建易稻壳目录，易稻壳人员赋权限 完成");
            return permissionPrevRecordVO;
        }

        return permissionPrevRecordVO;
    }

    /**
     * 检查权限
     *
     * @param systemAdmin             系统管理员
     * @param roleList                角色列表
     * @param userId                  用户id
     * @param orgId                   组织id
     * @param docId                   文档id
     * @param docType                 单据类型
     * @param businessDocTypeConfigVO 业务单据类型配置vo
     */
    private void checkAuthority(boolean systemAdmin, Long userId, Long orgId, List<String> roleList, Long docId, String docType, BusinessDocTypeConfigVO businessDocTypeConfigVO) {
        if (!systemAdmin) {

            // 注意代码顺序 会影响校验结果
            // 1、 管理员不校验
            // 2、根据文档类型、可访问角色校验；
            // 3、根据具体的文档类型是否开启校验 校验具体的角色；
            // 4、根据业务字段判断 校验；

            if (ObjectUtils.isEmpty(roleList)) {
                throw TwException.error("", "角色未配置，暂无权限");
            }
            // 根据文档类型  可访问角色 校验权限
            BusinessDocTypeConfigRoleRefQuery configRoleRefQuery = new BusinessDocTypeConfigRoleRefQuery();
            configRoleRefQuery.setRoleCodeList(roleList);
            configRoleRefQuery.setDocType(docType);
            Long count = businessDocTypeConfigRoleRefService.count(configRoleRefQuery);

            // 如果不符合角色,继续判断
            if (count < 1) {

                // 文档类型配置 是否启用权限控制 authority
                if (businessDocTypeConfigVO.getPermissionControlFlag() != null && businessDocTypeConfigVO.getPermissionControlFlag()) {
                    // 允许访问的角色编码
                    if (ObjectUtils.isEmpty(roleList)) {
                        throw TwException.error("", "暂无权限");
                    } else {
                        boolean flag = false;
                        for (String roleCode : roleList) {
                            if (businessDocTypeConfigAllowRoleService.count(new BusinessDocTypeConfigAllowRoleQuery(businessDocTypeConfigVO.getId(), roleCode)) > 0) {
                                flag = true;
                                break;
                            }
                        }
                        if (!flag) {
                            throw TwException.error("", "暂无权限");
                        }
                    }
                }

                // 根据具体业务字段 校验权限
                BusinessDocTypeCheckAuthorityService businessDocTypeCheckAuthorityService = BusinessDocTypeCheckAuthorityFactory.SERVICE_MAP.get(docType);
                if (null != businessDocTypeCheckAuthorityService) {
                    // 调用业务方法
                    TwException twException = businessDocTypeCheckAuthorityService.checkAuthority(docId);
                    if (null != twException) {
                        throw twException;
                    }
                    TwException twException1 = businessDocTypeCheckAuthorityService.checkAuthority(docId, docType);
                    if (null != twException1) {
                        throw twException1;
                    }
                    TwException twException2 = businessDocTypeCheckAuthorityService.checkAuthority(userId, orgId, roleList, docId, docType, businessDocTypeConfigVO.getId());
                    if (null != twException2) {
                        throw twException2;
                    }
                }

            }

        }
    }

    /**
     * 检查参数 yeedoc信息查询
     *
     * @param docId            文档id
     * @param docType          单据类型
     * @param configId         配置id
     * @param createFolderName 创建文件夹名称
     */
    private static void checkYeedocInfoQuery(Long docId, String docType, Long configId, String createFolderName) {
        if (ObjectUtils.isEmpty(docType)) {
            throw TwException.error("", "docType 不能为空");
        }
        if (docId == null) {
            throw TwException.error("", "docId 不能为空");
        }
        if (configId == null) {
            throw TwException.error("", "configId 不能为空");
        }
        if (ObjectUtils.isEmpty(createFolderName)) {
            log.error("通用文档管理异常，创建文件夹名称不能为空");
            throw TwException.error("", "createFolderName 不能为空");
        }
    }

    /**
     * 获取文档类型配置规则
     *
     * @param docId                  文档id
     * @param configId               配置id
     * @param tableName              表名称
     * @param businessTableFieldsVOS 业务表字段集合
     * @return {@link BusinessDocTypeConfigRuleVO}
     */
    private BusinessDocTypeConfigRuleVO getBusinessDocTypeConfigRuleVO(Long docId, Long configId, String tableName, List<BusinessTableFieldsVO> businessTableFieldsVOS) {
        if (ObjectUtils.isEmpty(docId)) {
            throw TwException.error("", "docId 不能为空");
        }
        if (ObjectUtils.isEmpty(configId)) {
            throw TwException.error("", "configId 不能为空");
        }
        if (ObjectUtils.isEmpty(tableName)) {
            //(会有这种情况) 集合 如果只需要对这个业务对象的文档进行统一路径的存储，不需要通过“表-表属性”进行存储路径的细分，那么可以不填写“表-表属性”，维护一个唯一的“文档库-存储路径”即可。
            tableName = "nullTable";
            // throw TwException.error("", "tableName 不能为空");
        }
        // 根据文档类型 去查询 规则配置
        BusinessDocTypeConfigRuleQuery query = new BusinessDocTypeConfigRuleQuery();
        query.setConfigId(configId);
        List<BusinessDocTypeConfigRuleVO> configRuleVOS = businessDocTypeConfigRuleDAO.queryListDynamic(query);
        if (CollectionUtils.isEmpty(configRuleVOS)) {
            throw TwException.error("DOC_TYPE_CONFIG_NOT_FOUND", "暂未配置文档存储路径，请先为业务对象进行配置");
        }
        BusinessDocTypeConfigRuleVO ruleResult = null;
        // 集合 如果只需要对这个业务对象的文档进行统一路径的存储，不需要通过“表-表属性”进行存储路径的细分，那么可以不填写“表-表属性”，维护一个唯一的“文档库-存储路径”即可。
        List<BusinessDocTypeConfigRuleVO> notFieldRuleVOS = new ArrayList<>();
        for (BusinessDocTypeConfigRuleVO configRuleVO : configRuleVOS) {
            if (ObjectUtils.isEmpty(configRuleVO.getConditionsValue())) {
                log.warn("通用文档管理异常：条件值【conditionsValue】为空");

                // 如果字段fieldId为空 ，则表示配置规则没有选定，全局生效
                /**
                 * “文档类型”是根据业务归类需要所自定义录入的值，20 个字符以内；
                 *
                 * “表-表属性”定义了此业务对象（如项目、合同、商机等）需要根据哪张表、表中哪个字段来匹配易稻壳的存储路径；
                 *
                 * 维护了“表-表属性”后，可通过“文档配置”页签下的「新增」按钮来添加匹配条件，对于满足匹配条件的业务对象，会按照维护的“易稻壳文档库-易稻壳存储路径”进行创建、访问与上传文档；
                 *
                 * 如果只需要对这个业务对象的文档进行统一路径的存储，不需要通过“表-表属性”进行存储路径的细分，那么可以不填写“表-表属性”，维护一个唯一的“文档库-存储路径”即可。
                 */
                if (ObjectUtils.isEmpty(configRuleVO.getFieldId())) {
                    log.warn("通用文档管理：条件值【conditionsValue】、业务对象字段明细主键【fieldId】 为空；属于统一路径的存储配置场景");
                    notFieldRuleVOS.add(configRuleVO);
                }
                continue;
            }
            if (ObjectUtils.isEmpty(configRuleVO.getFieldId())) {
                log.error("通用文档管理异常：业务对象字段明细主键【fieldId】为空");
                continue;
            }
            // 校验数据合理性
            if (ObjectUtils.isEmpty(configRuleVO.getConditions())) {
                log.error("通用文档管理异常：条件【conditions】为空");
                configRuleVO.setConditions(BusinessDocTypeRuleConditionEnum.EQ.getCode());
            }

            // 使用预编译防止sql注入
            StringBuffer sql = new StringBuffer();
            sql.append("select count(1)  from " + tableName);
            sql.append(" where id = " + docId);
            sql.append(" and delete_flag = 0 ");

            final String conditions = configRuleVO.getConditions();
            Optional<BusinessTableFieldsVO> fieldsVOOptional = businessTableFieldsVOS.stream().filter(businessTableFieldsVO -> businessTableFieldsVO.getId().equals(configRuleVO.getFieldId())).findFirst();
            if (fieldsVOOptional.isPresent()) {
                BusinessTableFieldsVO fieldsVO = fieldsVOOptional.get();
                sql.append(" and " + fieldsVO.getField() + " " + conditions);

                // in 、 not in 加工处理
                if (conditions.equals(BusinessDocTypeRuleConditionEnum.IN.getCode()) || conditions.equals(BusinessDocTypeRuleConditionEnum.NOT_IN.getCode())) {
                    // 如果值不符合规范，需要兼容处理
                    if (configRuleVO.getConditionsValue().contains(",")) {
                        String[] conditionsValues = configRuleVO.getConditionsValue().split(",");
                        configRuleVO.setConditionsValue("(" + org.apache.commons.lang3.StringUtils.join(conditionsValues, "','") + ")");
                    } else {
                        configRuleVO.setConditionsValue("(" + "'" + configRuleVO.getConditionsValue() + "'" + ")");
                    }

                    sql.append(" " + configRuleVO.getConditionsValue() + " ");
                } else {
                    sql.append(" '" + configRuleVO.getConditionsValue() + "'");
                }
            } else {
                log.error("通用文档管理异常：业务对象字段明细不存在! fieldId:{}", configRuleVO.getFieldId());
                throw TwException.error("", "业务对象字段明细不存在");
            }

            log.info("通用文档管理 匹配规则 sql:{}", sql.toString());
            Query querySql = em.createNativeQuery(sql.toString());
            // query1.setParameter(1, tableName);
            BigInteger singleResult = (BigInteger) querySql.getSingleResult();
            int countResult = singleResult.intValue();
            // 匹配到规则 退出循环
            if (countResult > 0) {
                ruleResult = configRuleVO;

                // 匹配到规则 退出循环
                break;
            }
        }

        if (null == ruleResult && !CollectionUtils.isEmpty(notFieldRuleVOS)) {
            if (notFieldRuleVOS.size() > 1) {
                log.error("通用文档管理异常：匹配到多个规则，请检查配置规则是否有重复");
                throw TwException.error("", "匹配到多个规则，请检查配置规则是否有重复");
            }
            return notFieldRuleVOS.get(0);
        }
        return ruleResult;
    }


    /**
     * 创建文件夹
     *
     * @param createFolderName 创建文件夹名称
     * @param itemId           项目id
     * @param libraryId        库id
     * @return {@link Result}
     */
    private Result createFolder(String createFolderName, String itemId, String libraryId) {
        Map<String, Object> map = new HashMap<String, Object>();
        List<String> pathArry = new ArrayList<String>();
        // pathArry.add("/"+twProjectView.getProjNo() + "-" + twProjectView.getProjName() + "(" + twProjectView.getContractNo() + ")");
        if (createFolderName.startsWith("/")) {
            pathArry.add(createFolderName);
        } else {
            pathArry.add("/" + createFolderName);
        }
        if (StringUtils.hasText(itemId)) {
            map.put("ItemId", itemId);
        }
        // !!! 一定要注意有pathArry一定要 / 开头    否则接口成功也无意义
        map.put("PathArry", pathArry);
        //map.put("libraryId","02c32947-5751-4578-9c37-c1ac99593af2");
        map.put("LibraryId", libraryId);
        String resultStr = yeedocService.createFolder(map);
        if (ObjectUtils.isEmpty(resultStr)) {
            log.error("通用文档管理异常[调用易道壳创建文件夹]-map:{}", JSONObject.toJSONString(map));
            log.error("通用文档管理异常[调用易道壳创建文件夹]-resultStr:{}", resultStr);
            throw TwException.error("DOC_TYPE_CONFIG_YEEDOC_CREATE_FLODER_ERROR", "易道壳创建文件失败，请联系管理员");
        }
        JSONObject resultJson = JSONObject.parseObject(resultStr);
        Object data = resultJson.get("Data");
        if (ObjectUtils.isEmpty(data)) {
            log.error("通用文档管理异常[调用易道壳创建文件夹]-resultJson:{}", resultJson);
            throw TwException.error("DOC_TYPE_CONFIG_YEEDOC_CREATE_FLODER_ERROR", "易道壳创建文件失败，请联系管理员");
        }
        JSONArray dataArray = JSONArray.parseArray(data.toString());
        if (ObjectUtils.isEmpty(dataArray)) {
            log.error("通用文档管理异常[调用易道壳创建文件夹]-resultJson:{}", resultJson);
            throw TwException.error("DOC_TYPE_CONFIG_YEEDOC_CREATE_FLODER_ERROR", "易道壳创建文件失败，请联系管理员");
        }
        String floderId = (String) JSONObject.parseObject(String.valueOf(dataArray.get(0))).get("FolderId");
        String floderName = (String) JSONObject.parseObject(String.valueOf(dataArray.get(0))).get("LeafName");
        Result result = new Result(floderId, floderName);
        return result;
    }

    private record Result(String floderId, String floderName) {
    }


}
