package com.elitesland.tw.tw5.server.common.permission.strategy.context;

import com.elitesland.tw.tw5.server.common.permission.enums.PermissionLevelScopeEnum;
import com.elitesland.tw.tw5.server.common.permission.strategy.OrgUserStrategyService;
import org.apache.xmlbeans.impl.common.ConcurrentReaderHashMap;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @Author Quruiqizz
 * @Date 2023/11/9 9:48
 **/
@Component
public class OrgUserStrategyContext {

    private final Map<String, OrgUserStrategyService> orgUsrStrategyMap = new ConcurrentHashMap();

    /**
     * 通过构造器注入的方式 拿到策略下的策略实现类
     *
     * @param strategyMap
     */
    public OrgUserStrategyContext(Map<String, OrgUserStrategyService> strategyMap) {
        orgUsrStrategyMap.clear();
        orgUsrStrategyMap.putAll(strategyMap);
    }

    /**
     * 获取对应策略下可以使用的bean
     *
     * @param beanName
     * @return
     */
    public OrgUserStrategyService getStrategyBean(String beanName) {
        return orgUsrStrategyMap.get(beanName);
    }

}
