package com.elitesland.tw.tw5.server.prd.ab.dao;


import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbAccountVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.ab.entity.PrdAbAccountDO;
import com.elitesland.tw.tw5.server.prd.ab.entity.QPrdAbAccountDO;
import com.elitesland.tw.tw5.server.prd.ab.entity.QPrdAbDO;
import com.elitesland.tw.tw5.server.prd.ab.repo.PrdAbAccountRepo;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmCustomerDO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * @author carl.wang
 * @Description:
 * @date
 */
@Repository
@RequiredArgsConstructor
public class PrdAbAccountDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdAbAccountRepo repo;
    private final QPrdAbAccountDO qdo = QPrdAbAccountDO.prdAbAccountDO;
    private final QPrdAbDO abQdo = QPrdAbDO.prdAbDO;
    private final QCrmCustomerDO qdoCustomer = QCrmCustomerDO.crmCustomerDO;

    /**
     * @param id
     * @return
     * @Description
     **/
    public Long queryTW4IdById(Long id) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdo.accountIdV4).from(qdo);
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * @param ids
     * @return
     * @Description
     **/
    public List<Long> queryTW4IdsByIds(List<Long> ids) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdo.accountIdV4).from(qdo);
        jpaQuery.where(qdo.id.in(ids));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdAbAccountDO save(PrdAbAccountDO ado) {
        return repo.save(ado);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdAbAccountVO> getJpaQuerySelect() {
        JPAQuery<PrdAbAccountVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PrdAbAccountVO.class,
                qdo.id,
                qdo.bookId,
                qdo.accountType,
                qdo.depositBank,
                qdo.depositCity,
                qdo.depositBankOutlet,
                qdo.accountName,
                qdo.accountNo,
                qdo.currency,
                qdo.remark,
                qdo.defaultFlag
        )).from(qdo);
        return jpaQuery;
    }

    /**
     * @param bookId 地址簿主键
     * @return
     * @Description 主键查询
     **/
    public List<PrdAbAccountVO> queryList(Long bookId) {
        JPAQuery<PrdAbAccountVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.bookId.eq(bookId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 查询列表
     *
     * @param bookId      地址簿主键
     * @param accountType 帐户类型
     * @param defaultFlag 默认
     * @param accountNo   账号
     * @return {@link List}<{@link PrdAbAccountVO}>
     */
    public List<PrdAbAccountVO> queryList(Long bookId, String accountType, Boolean defaultFlag, String accountNo) {
        JPAQuery<PrdAbAccountVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.bookId.eq(bookId));
        if (StringUtils.hasText(accountType)) {
            jpaQuery.where(qdo.accountType.eq(accountType));
        }
        if (null != defaultFlag) {
            jpaQuery.where(qdo.defaultFlag.eq(defaultFlag));
        }
        if (StringUtils.hasText(accountNo)) {
            jpaQuery.where(qdo.accountNo.eq(accountNo));
        }
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }

    /**
     * 物理删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long delete(List<Long> keys) {
        JPADeleteClause delete = jpaQueryFactory.delete(qdo).where(qdo.id.in(keys));

        return delete.execute();
    }

    /**
     * @param bookId
     * @return
     * @Description
     **/
    public Long queryIdByBookId(Long bookId) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdoCustomer.id).from(qdoCustomer);
        jpaQuery.where(qdoCustomer.bookId.eq(bookId));
        jpaQuery.where(qdoCustomer.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * @param
     * @return
     * @Description
     **/
    public List<PrdAbAccountVO> selectInternalOu() {
        JPAQuery<PrdAbAccountVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PrdAbAccountVO.class,
                qdo.id,
                qdo.bookId,
                qdo.accountType,
                qdo.depositBank,
                qdo.depositCity,
                qdo.depositBankOutlet,
                qdo.accountName,
                qdo.accountNo,
                qdo.currency,
                qdo.remark,
                qdo.defaultFlag,
                abQdo.bookName
        )).from(qdo).leftJoin(abQdo).on(qdo.bookId.longValue().eq(abQdo.id.longValue()));
        jpaQuery.where(abQdo.bookType.eq("company"));
        jpaQuery.where(abQdo.relateType.like(SqlUtil.toSqlLikeString("intercompany")));
        return jpaQuery.fetch();
    }

}
