package com.elitesland.tw.tw5.server.prd.acc.dao;


import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSettingDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.QAccBusinessItemDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.QAccReimSettingDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSettingRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 报销配置主表
 *
 * @author zoey
 * @date 2024-04-08
 */
@Repository
@RequiredArgsConstructor
public class AccReimSettingDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final AccReimSettingRepo repo;
    private final QAccReimSettingDO qdo = QAccReimSettingDO.accReimSettingDO;
    private final QAccBusinessItemDO  qBusinessItemDO = QAccBusinessItemDO.accBusinessItemDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<AccReimSettingVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(AccReimSettingVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                qdo.modifyTime,
                // 规则名称
                qdo.ruleName,
                // 状态:1 有效；0 无效
                qdo.effective,
                // 报销单据类型,udc:ACC:REIM_PROC_KEY
                qdo.reimDocType,
                // 核算项目
                qdo.busAccItemId,
//                qBusinessItemDO.businessCode.as("busAccItemCode"),
//                qBusinessItemDO.businessName.as("busAccItemName"),
                // 适用公司
                qdo.expenseCompany,
                // 适用范围
                qdo.applicationScope,
                // 适用资源
                qdo.applicationSource,
                // 例外人员
                qdo.whiteList,
                // 提醒等级（0警告，1报错）
                qdo.remindLevel,
                // 是否执行规则 0 不执行 1执行
                qdo.executeFlag,
                // 是否高亮 0 不高亮 1高亮
                qdo.highlightFlag,
                // 高亮颜色
                qdo.highlightColor,
                // 提醒文本
                qdo.remindText,
                // 报错警告文本
                qdo.errorText,
                qdo.reimSettingType,
                qdo.specificReimSettingId
        )).from(qdo);
                //.leftJoin(qBusinessItemDO).on(qdo.busAccItemId.eq(qBusinessItemDO.id).and(qBusinessItemDO.deleteFlag.eq(0)));
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<AccReimSettingVO> getJpaQueryWhere(AccReimSettingQuery query) {
        JPAQuery<AccReimSettingVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(AccReimSettingQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(AccReimSettingQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 规则名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getRuleName())) {
             list.add(qdo.ruleName.like(SqlUtil.toSqlLikeString(query.getRuleName())));
        }
        /** 状态:1 有效；0 无效 精确 */
        if (!ObjectUtils.isEmpty(query.getEffective())) {
            list.add(qdo.effective.eq(query.getEffective()));
        }
        /** 报销单据类型,udc:ACC:REIM_PROC_KEY 精确 */
        if (!ObjectUtils.isEmpty(query.getReimDocType())) {
            list.add(qdo.reimDocType.like(SqlUtil.toSqlLikeString(query.getReimDocType())));
        }
        /** 核算项目 精确 */
        if (!ObjectUtils.isEmpty(query.getBusAccItemId())) {
            list.add(qdo.busAccItemId.like(SqlUtil.toSqlLikeString(query.getBusAccItemId())));
        }
        /** 适用公司 精确 */
        if (!ObjectUtils.isEmpty(query.getExpenseCompany())) {
            list.add(qdo.expenseCompany.like(SqlUtil.toSqlLikeString(query.getExpenseCompany())));
        }
        /** 适用范围 精确 */
        if (!ObjectUtils.isEmpty(query.getApplicationScope())) {
            list.add(qdo.applicationScope.eq(query.getApplicationScope()));
        }
        /** 适用资源 精确 */
        if (!ObjectUtils.isEmpty(query.getApplicationSource())) {
            list.add(qdo.applicationSource.like(SqlUtil.toSqlLikeString(query.getApplicationSource())));
        }
        /** 例外人员 精确 */
        if (!ObjectUtils.isEmpty(query.getWhiteList())) {
            list.add(qdo.whiteList.eq(query.getWhiteList()));
        }
        /** 提醒等级（0警告，1报错） 精确 */
        if (!ObjectUtils.isEmpty(query.getRemindLevel())) {
            list.add(qdo.remindLevel.eq(query.getRemindLevel()));
        }
        /** 是否执行规则 0 不执行 1执行 精确 */
        if (!ObjectUtils.isEmpty(query.getExecuteFlag())) {
            list.add(qdo.executeFlag.eq(query.getExecuteFlag()));
        }
        /** 是否高亮 0 不高亮 1高亮 精确 */
        if (!ObjectUtils.isEmpty(query.getHighlightFlag())) {
            list.add(qdo.highlightFlag.eq(query.getHighlightFlag()));
        }
        /** 高亮颜色 精确 */
        if (!ObjectUtils.isEmpty(query.getHighlightColor())) {
            list.add(qdo.highlightColor.eq(query.getHighlightColor()));
        }
        /** 提醒文本 精确 */
        if (!ObjectUtils.isEmpty(query.getRemindText())) {
            list.add(qdo.remindText.eq(query.getRemindText()));
        }
        /** 报错警告文本 精确 */
        if (!ObjectUtils.isEmpty(query.getErrorText())) {
            list.add(qdo.errorText.eq(query.getErrorText()));
        }
        /** 报错警告文本 精确 */
        if (!ObjectUtils.isEmpty(query.getErrorText())) {
            list.add(qdo.errorText.eq(query.getErrorText()));
        }
        /** 报错警告文本 精确 */
        if (!ObjectUtils.isEmpty(query.getErrorText())) {
            list.add(qdo.errorText.eq(query.getErrorText()));
        }
        /** 配置类型 精确 */
        if (!ObjectUtils.isEmpty(query.getReimSettingType())) {
            list.add(qdo.reimSettingType.eq(query.getReimSettingType()));
        }
        /** 具体配置id 精确 */
        if (!ObjectUtils.isEmpty(query.getSpecificReimSettingId())) {
            list.add(qdo.specificReimSettingId.eq(query.getSpecificReimSettingId()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public AccReimSettingVO queryByKey(Long id) {
        JPAQuery<AccReimSettingVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<AccReimSettingVO> queryListDynamic(AccReimSettingQuery query) {
        JPAQuery<AccReimSettingVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<AccReimSettingVO> queryPaging(AccReimSettingQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<AccReimSettingVO> jpaQuery = getJpaQueryWhere(query);
        List<AccReimSettingVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<AccReimSettingVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public AccReimSettingDO save(AccReimSettingDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<AccReimSettingDO> saveAll(List<AccReimSettingDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(AccReimSettingPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 规则名称
        if (payload.getRuleName() != null) {
            update.set(qdo.ruleName, payload.getRuleName());
        }
        // 状态:1 有效；0 无效
        if (payload.getEffective() != null) {
            update.set(qdo.effective, payload.getEffective());
        }
        // 报销单据类型,udc:ACC:REIM_PROC_KEY
        if (payload.getReimDocType() != null) {
            update.set(qdo.reimDocType, payload.getReimDocType());
        }
        // 核算项目
        if (payload.getBusAccItemId() != null) {
            update.set(qdo.busAccItemId, payload.getBusAccItemId());
        }
        // 适用公司
        if (payload.getExpenseCompany() != null) {
            update.set(qdo.expenseCompany, payload.getExpenseCompany());
        }
        // 适用范围
        if (payload.getApplicationScope() != null) {
            update.set(qdo.applicationScope, payload.getApplicationScope());
        }
        // 适用资源
        if (payload.getApplicationSource() != null) {
            update.set(qdo.applicationSource, payload.getApplicationSource());
        }
        // 例外人员
        if (payload.getWhiteList() != null) {
            update.set(qdo.whiteList, payload.getWhiteList());
        }
        // 提醒等级（0警告，1报错）
        if (payload.getRemindLevel() != null) {
            update.set(qdo.remindLevel, payload.getRemindLevel());
        }
        // 是否执行规则 0 不执行 1执行
        if (payload.getExecuteFlag() != null) {
            update.set(qdo.executeFlag, payload.getExecuteFlag());
        }
        // 是否高亮 0 不高亮 1高亮
        if (payload.getHighlightFlag() != null) {
            update.set(qdo.highlightFlag, payload.getHighlightFlag());
        }
        // 高亮颜色
        if (payload.getHighlightColor() != null) {
            update.set(qdo.highlightColor, payload.getHighlightColor());
        }
        // 提醒文本
        if (payload.getRemindText() != null) {
            update.set(qdo.remindText, payload.getRemindText());
        }
        // 报错警告文本
        if (payload.getErrorText() != null) {
            update.set(qdo.errorText, payload.getErrorText());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 规则名称
            if (nullFields.contains("ruleName")) {
                update.setNull(qdo.ruleName);
            }
            // 状态:1 有效；0 无效
            if (nullFields.contains("effective")) {
                update.setNull(qdo.effective);
            }
            // 报销单据类型,udc:ACC:REIM_PROC_KEY
            if (nullFields.contains("reimDocType")) {
                update.setNull(qdo.reimDocType);
            }
            // 核算项目
            if (nullFields.contains("busAccItemId")) {
                update.setNull(qdo.busAccItemId);
            }
            // 适用公司
            if (nullFields.contains("expenseCompany")) {
                update.setNull(qdo.expenseCompany);
            }
            // 适用范围
            if (nullFields.contains("applicationScope")) {
                update.setNull(qdo.applicationScope);
            }
            // 适用资源
            if (nullFields.contains("applicationSource")) {
                update.setNull(qdo.applicationSource);
            }
            // 例外人员
            if (nullFields.contains("whiteList")) {
                update.setNull(qdo.whiteList);
            }
            // 提醒等级（0警告，1报错）
            if (nullFields.contains("remindLevel")) {
                update.setNull(qdo.remindLevel);
            }
            // 是否执行规则 0 不执行 1执行
            if (nullFields.contains("executeFlag")) {
                update.setNull(qdo.executeFlag);
            }
            // 是否高亮 0 不高亮 1高亮
            if (nullFields.contains("highlightFlag")) {
                update.setNull(qdo.highlightFlag);
            }
            // 高亮颜色
            if (nullFields.contains("highlightColor")) {
                update.setNull(qdo.highlightColor);
            }
            // 提醒文本
            if (nullFields.contains("remindText")) {
                update.setNull(qdo.remindText);
            }
            // 报错警告文本
            if (nullFields.contains("errorText")) {
                update.setNull(qdo.errorText);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 根据配置id查询组织名称
     *
     * @param id do对象
     * @return 保存后的对象
     */
    public String getOrgNames(Long id) {
        return repo.getOrgNames(id);
    }

    /**
     * 根据配置id查询角色名称
     *
     * @param id do对象
     * @return 保存后的对象
     */
    public String getRoleNames(Long id) {
        return repo.getRoleNames(id);
    }
}

