package com.elitesland.tw.tw5.server.prd.acc.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author sunxw
 * @description 报销记账/付款导出批次
 * @Date 2023/12/1
 */
@Entity
@Table(name = "acc_reim_pay_batch", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "acc_reim_pay_batch", comment = "报销记账/付款批次导出")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class AccReimPayBatchDO extends BaseModel implements Serializable {

    @Comment("审批批次编号")
    @Column()
    private String batchNo;

    @Comment("审批批次名称")
    @Column()
    private String batchName;

    @Comment("批次生成时间")
    @Column()
    private LocalDateTime batchTime;

    @Comment("批状态，0正常，1作废")
    @Column()
    private String batchStatus;

    @Comment("批类型 account-财务记账导出，cashier-财务付款导出")
    @Column()
    private String batchType;

    @Comment("数据最后一次导出时间")
    @Column()
    private LocalDateTime lastExportTime;

    @Comment("导出次数")
    @Column()
    private Integer exportCount;

    @Comment("本批次报销总额")
    @Column()
    private BigDecimal batchAmt;

    @Comment("报销批明细条数量")
    @Column()
    private Integer batchQty;

    public void copy(AccReimPayBatchDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
