package com.elitesland.tw.tw5.server.prd.acc.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 报销额度配置
 *
 * @author zoey
 * @date 2024-05-14
 */
@Entity
@Table(name = "acc_reim_setting_limit_rule", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "acc_reim_setting_limit_rule", comment = "报销额度配置")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class AccReimSettingLimitRuleDO extends BaseModel implements Serializable  {
    /** 主表id */
    @Comment("主表id")
    @Column()
    private Long reimSettingLimitId;
    /** 专业级别 */
    @Comment("专业级别")
    @Column()
    private String professionalGrade;
    /** 管理级别 */
    @Comment("管理级别")
    @Column()
    private String manageGrade;
    /** 特大城市额度 */
    @Comment("特大城市额度")
    @Column()
    private BigDecimal megacitiesLimit;
    /** 一线城市额度 */
    @Comment("一线城市额度")
    @Column()
    private BigDecimal firstTierCityLimit;
    /** 其它城市额度 */
    @Comment("其它城市额度")
    @Column()
    private BigDecimal otherLimit;

    public void copy(AccReimSettingLimitRuleDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
