package com.elitesland.tw.tw5.server.prd.acc.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * 报销抬头校验
 *
 * @author zoey
 * @date 2024-05-14
 */
@Entity
@Table(name = "acc_reim_setting_title", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "acc_reim_setting_title", comment = "报销抬头校验")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class AccReimSettingTitleDO extends BaseModel implements Serializable  {
    /** 报销配置主表id */
    @Comment("报销配置主表id")
    @Column()
    private Long reimSettingId;
    /** 发票类型OM:INPUT_INV_TYPE */
    @Comment("发票类型OM:INPUT_INV_TYPE")
    @Column()
    private String invType;
    /** 校验内容（udc） */
    @Comment("校验内容（udc）")
    @Column()
    private String checkContent;
    /** 不参与校验发票 */
    @Comment("不参与校验发票")
    @Column()
    private String exceptCommodityName;

    public void copy(AccReimSettingTitleDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
