package com.elitesland.tw.tw5.server.prd.adm.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.adm.payload.AdmFeeApplyPayload;
import com.elitesland.tw.tw5.api.prd.adm.query.AdmFeeApplyQuery;
import com.elitesland.tw.tw5.api.prd.adm.vo.AdmFeeApplyVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.adm.entity.AdmFeeApplyDO;
import com.elitesland.tw.tw5.server.prd.adm.entity.QAdmFeeApplyDO;
import com.elitesland.tw.tw5.server.prd.adm.repo.AdmFeeApplyRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 特殊费用申请管理
 *
 * @author carl
 * @date 2023-11-01
 */
@Repository
@RequiredArgsConstructor
public class AdmFeeApplyDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final AdmFeeApplyRepo repo;
    private final QAdmFeeApplyDO qdo = QAdmFeeApplyDO.admFeeApplyDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<AdmFeeApplyVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(AdmFeeApplyVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 申请单号
                qdo.applyNo,
                // 申请单名称
                qdo.applyName,
                // 申请状态
                qdo.applyStatus,
                // 审批状态
                qdo.apprStatus,
                // 流程实例id
                qdo.procInstId,
                // 申请日期
                qdo.applyDate,
                // 财务期间id
                qdo.finPeriodId,
                // 用途类型
                qdo.usageType,
                // 事由类型
                qdo.reasonType,
                // 事由id
                qdo.reasonId,
                //事由名称
                qdo.reasonName,
                qdo.expenseByType,
                // 费用承担bu_id
                qdo.expenseBuId,
                // 费用承担公司id
                qdo.ouId,
                // 费用归属bu_id
                qdo.sumBuId,
                // 申请人资源id
                qdo.applyResId,
                // 申请人bu_id
                qdo.applyBuId,

                // 申请金额
                qdo.applyAmt,
                // 币种
                qdo.currCode,
                // 预计使用日期
                qdo.expectDate,
                // 报销模板id
                qdo.reimTmplId,
                // 客户id
                qdo.custId,
                // 项目非项目
                qdo.applyType,
                // 费用码
                qdo.feeCode,
                //报销单ID
                qdo.reimId
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<AdmFeeApplyVO> getJpaQueryWhere(AdmFeeApplyQuery query) {
        JPAQuery<AdmFeeApplyVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(AdmFeeApplyQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(AdmFeeApplyQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 主键 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 申请单号 模糊 */
        if (!ObjectUtils.isEmpty(query.getApplyNo())) {
            list.add(qdo.applyNo.like(SqlUtil.toSqlLikeString(query.getApplyNo())));
        }
        /** 申请单名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getApplyName())) {
            list.add(qdo.applyName.like(SqlUtil.toSqlLikeString(query.getApplyName())));
        }
        /** 申请状态 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyStatus())) {
            list.add(qdo.applyStatus.eq(query.getApplyStatus()));
        }
        /** 审批状态 精确 */
        if (!ObjectUtils.isEmpty(query.getApprStatus())) {
            list.add(qdo.apprStatus.eq(query.getApprStatus()));
        }
        /** 流程实例id 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstId())) {
            list.add(qdo.procInstId.eq(query.getProcInstId()));
        }
        /** 申请日期 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyDate())) {
            list.add(qdo.applyDate.eq(query.getApplyDate()));
        }
        /** 财务期间id 精确 */
        if (!ObjectUtils.isEmpty(query.getFinPeriodId())) {
            list.add(qdo.finPeriodId.eq(query.getFinPeriodId()));
        }
        /** 用途类型 精确 */
        if (!ObjectUtils.isEmpty(query.getUsageType())) {
            list.add(qdo.usageType.eq(query.getUsageType()));
        }
        /** 事由类型 精确 */
        if (!ObjectUtils.isEmpty(query.getReasonType())) {
            list.add(qdo.reasonType.eq(query.getReasonType()));
        }
        /** 事由id 精确 */
        if (!ObjectUtils.isEmpty(query.getReasonId())) {
            list.add(qdo.reasonId.eq(query.getReasonId()));

        }
        /** 事由名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getReasonName())) {
            list.add(qdo.reasonName.like(SqlUtil.toSqlLikeString(query.getReasonName())));
        }
        /** 费用承担方（类型） 精确 */
        if (!ObjectUtils.isEmpty(query.getExpenseByType())) {
            list.add(qdo.expenseByType.eq(query.getExpenseByType()));
        }
        /** 费用承担bu_id 精确 */
        if (!ObjectUtils.isEmpty(query.getExpenseBuId())) {
            list.add(qdo.expenseBuId.eq(query.getExpenseBuId()));
        }
        /** 费用承担公司id 精确 */
        if (!ObjectUtils.isEmpty(query.getOuId())) {
            list.add(qdo.ouId.eq(query.getOuId()));
        }
        /** 费用归属bu_id 精确 */
        if (!ObjectUtils.isEmpty(query.getSumBuId())) {
            list.add(qdo.sumBuId.eq(query.getSumBuId()));
        }
        /** 申请人资源id 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyResId())) {
            list.add(qdo.applyResId.eq(query.getApplyResId()));
        }
        /** 申请人bu_id 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyBuId())) {
            list.add(qdo.applyBuId.eq(query.getApplyBuId()));
        }
        /** 申请金额 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyAmt())) {
            list.add(qdo.applyAmt.eq(query.getApplyAmt()));
        }
        /** 币种 精确 */
        if (!ObjectUtils.isEmpty(query.getCurrCode())) {
            list.add(qdo.currCode.eq(query.getCurrCode()));
        }
        /** 预计使用日期 精确 */
        if (!ObjectUtils.isEmpty(query.getExpectBeginDate())) {
            list.add(qdo.expectDate.goe(query.getExpectBeginDate()));
        }
        /** 预计使用日期 精确 */
        if (!ObjectUtils.isEmpty(query.getExpectEndDate())) {
            list.add(qdo.expectDate.loe(query.getExpectEndDate()));
        }

        /** 报销模板id 精确 */
        if (!ObjectUtils.isEmpty(query.getReimTmplId())) {
            list.add(qdo.reimTmplId.eq(query.getReimTmplId()));
        }
        /** 客户id 精确 */
        if (!ObjectUtils.isEmpty(query.getCustId())) {
            list.add(qdo.custId.eq(query.getCustId()));
        }
        /** 项目非项目 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyType())) {
            list.add(qdo.applyType.eq(query.getApplyType()));
        }
        /** 费用码 精确 */
        if (!ObjectUtils.isEmpty(query.getFeeCode())) {
            list.add(qdo.feeCode.eq(query.getFeeCode()));
        }
        /** 申请单是否被报销单关联 */
        if (!ObjectUtils.isEmpty(query.getReimRelateFlag()) && 0 == query.getReimRelateFlag()) {
            list.add(qdo.reimId.isNull());
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public AdmFeeApplyVO queryByKey(Long id) {
        JPAQuery<AdmFeeApplyVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<AdmFeeApplyVO> queryListDynamic(AdmFeeApplyQuery query) {
        JPAQuery<AdmFeeApplyVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<AdmFeeApplyVO> queryPaging(AdmFeeApplyQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<AdmFeeApplyVO> jpaQuery = getJpaQueryWhere(query);
        List<AdmFeeApplyVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<AdmFeeApplyVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public AdmFeeApplyDO save(AdmFeeApplyDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<AdmFeeApplyDO> saveAll(List<AdmFeeApplyDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(AdmFeeApplyPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 主键
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 申请单号
        if (payload.getApplyNo() != null) {
            update.set(qdo.applyNo, payload.getApplyNo());
        }
        // 申请单名称
        if (payload.getApplyName() != null) {
            update.set(qdo.applyName, payload.getApplyName());
        }
        // 申请状态
        if (payload.getApplyStatus() != null) {
            update.set(qdo.applyStatus, payload.getApplyStatus());
        }
        // 审批状态
        if (payload.getApprStatus() != null) {
            update.set(qdo.apprStatus, payload.getApprStatus());
        }
        // 流程实例id
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        // 申请日期
        if (payload.getApplyDate() != null) {
            update.set(qdo.applyDate, payload.getApplyDate());
        }
        // 财务期间id
        if (payload.getFinPeriodId() != null) {
            update.set(qdo.finPeriodId, payload.getFinPeriodId());
        }
        // 用途类型
        if (payload.getUsageType() != null) {
            update.set(qdo.usageType, payload.getUsageType());
        }
        // 事由类型
        if (payload.getReasonType() != null) {
            update.set(qdo.reasonType, payload.getReasonType());
        }
        // 事由id
        if (payload.getReasonId() != null) {
            update.set(qdo.reasonId, payload.getReasonId());
        }
        // 费用承担bu_id
        if (payload.getExpenseBuId() != null) {
            update.set(qdo.expenseBuId, payload.getExpenseBuId());
        }
        // 费用归属bu_id
        if (payload.getSumBuId() != null) {
            update.set(qdo.sumBuId, payload.getSumBuId());
        }
        // 申请人资源id
        if (payload.getApplyResId() != null) {
            update.set(qdo.applyResId, payload.getApplyResId());
        }
        // 申请人bu_id
        if (payload.getApplyBuId() != null) {
            update.set(qdo.applyBuId, payload.getApplyBuId());
        }
        // 申请金额
        if (payload.getApplyAmt() != null) {
            update.set(qdo.applyAmt, payload.getApplyAmt());
        }
        // 币种
        if (payload.getCurrCode() != null) {
            update.set(qdo.currCode, payload.getCurrCode());
        }
        // 预计使用日期
        if (payload.getExpectDate() != null) {
            update.set(qdo.expectDate, payload.getExpectDate());
        }
        // 报销模板id
        if (payload.getReimTmplId() != null) {
            update.set(qdo.reimTmplId, payload.getReimTmplId());
        }
        // 客户id
        if (payload.getCustId() != null) {
            update.set(qdo.custId, payload.getCustId());
        }
        // 项目非项目
        if (payload.getApplyType() != null) {
            update.set(qdo.applyType, payload.getApplyType());
        }
        // 费用码
        if (payload.getFeeCode() != null) {
            update.set(qdo.feeCode, payload.getFeeCode());
        }
        if (payload.getReimId() != null) {
            update.set(qdo.reimId, payload.getReimId());
        }
        if (payload.getReimDefaultFlag() != null) {
            update.setNull(qdo.reimId);
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 主键
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 申请单号
            if (nullFields.contains("applyNo")) {
                update.setNull(qdo.applyNo);
            }
            // 申请单名称
            if (nullFields.contains("applyName")) {
                update.setNull(qdo.applyName);
            }
            // 申请状态
            if (nullFields.contains("applyStatus")) {
                update.setNull(qdo.applyStatus);
            }
            // 审批状态
            if (nullFields.contains("apprStatus")) {
                update.setNull(qdo.apprStatus);
            }
            // 流程实例id
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
            // 申请日期
            if (nullFields.contains("applyDate")) {
                update.setNull(qdo.applyDate);
            }
            // 财务期间id
            if (nullFields.contains("finPeriodId")) {
                update.setNull(qdo.finPeriodId);
            }
            // 用途类型
            if (nullFields.contains("usageType")) {
                update.setNull(qdo.usageType);
            }
            // 事由类型
            if (nullFields.contains("reasonType")) {
                update.setNull(qdo.reasonType);
            }
            // 事由id
            if (nullFields.contains("reasonId")) {
                update.setNull(qdo.reasonId);
            }
            // 费用承担bu_id
            if (nullFields.contains("expenseBuId")) {
                update.setNull(qdo.expenseBuId);
            }
            // 费用归属bu_id
            if (nullFields.contains("sumBuId")) {
                update.setNull(qdo.sumBuId);
            }
            // 申请人资源id
            if (nullFields.contains("applyResId")) {
                update.setNull(qdo.applyResId);
            }
            // 申请人bu_id
            if (nullFields.contains("applyBuId")) {
                update.setNull(qdo.applyBuId);
            }
            // 申请金额
            if (nullFields.contains("applyAmt")) {
                update.setNull(qdo.applyAmt);
            }
            // 币种
            if (nullFields.contains("currCode")) {
                update.setNull(qdo.currCode);
            }
            // 预计使用日期
            if (nullFields.contains("expectDate")) {
                update.setNull(qdo.expectDate);
            }
            // 报销模板id
            if (nullFields.contains("reimTmplId")) {
                update.setNull(qdo.reimTmplId);
            }
            // 客户id
            if (nullFields.contains("custId")) {
                update.setNull(qdo.custId);
            }
            // 项目非项目
            if (nullFields.contains("applyType")) {
                update.setNull(qdo.applyType);
            }
            // 费用码
            if (nullFields.contains("feeCode")) {
                update.setNull(qdo.feeCode);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 根据主键查询
     *
     * @param ids 主键
     * @return 结果
     */
    public List<AdmFeeApplyVO> queryByKeys(List<Long> ids) {
        JPAQuery<AdmFeeApplyVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.in(ids));
        return jpaQuery.fetch();
    }


    /**
     * 解绑报销
     * @param reimId
     */
    public long unbindReim(Long reimId) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo);
        update.setNull(qdo.reimId);
        update.where(qdo.reimId.eq(reimId));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }
}

