package com.elitesland.tw.tw5.server.prd.adm.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 特殊费用申请明细管理
 *
 * @author carl
 * @date 2023-11-01
 */
@Entity
@Table(name = "adm_fee_apply_detail", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "adm_fee_apply_detail", comment = "特殊费用申请明细管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class AdmFeeApplyDetailDO extends BaseModel implements Serializable {
    /**
     * 申请单id
     */
    @Comment("申请单id")
    @Column()
    private Long applyId;
    /**
     * 序号
     */
    @Comment("序号")
    @Column()
    private BigDecimal lineNo;
    /**
     * 科目id
     */
    @Comment("科目id")
    @Column()
    private Long accId;
    /**
     * 申请金额
     */
    @Comment("申请金额")
    @Column()
    private BigDecimal applyAmt;
    /**
     * 币种
     */
    @Comment("币种")
    @Column()
    private String currCode;
    /**
     * 税率
     */
    @Comment("税率")
    @Column()
    private BigDecimal taxRate;
    /**
     * 税额
     */
    @Comment("税额")
    @Column()
    private BigDecimal taxAmt;
    /**
     * 费用说明
     */
    @Comment("费用说明")
    @Column()
    private String feeDesc;

    public void copy(AdmFeeApplyDetailDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
