package com.elitesland.tw.tw5.server.prd.cal.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 任务包结算管理
 *
 * @author carl
 * @date 2023-11-15
 */
@Entity
@Table(name = "cal_task_settle", indexes = {
        @Index(name = "proj_index", columnList = "proj_id"),
        @Index(name = "income_res_index", columnList = "income_res_id"),
        @Index(name = "res_bu_index", columnList = "res_bu_id"),
        @Index(name = "task_index", columnList = "task_id")

})
@org.hibernate.annotations.Table(appliesTo = "cal_task_settle", comment = "任务包结算管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CalTaskSettleDO extends BaseModel implements Serializable {
    /**
     * 结算单号
     */
    @Comment("结算单号")
    @Column()
    private String settleNo;
    /**
     * 结算状态
     */
    @Comment("结算状态")
    @Column()
    private String settleStatus;
    /**
     * 审批状态
     */
    @Comment("审批状态")
    @Column()
    private String apprStatus;
    /**
     * 流程实例id
     */
    @Comment("流程实例id")
    @Column()
    private String procInstId;
    /**
     * 结算类型（任务包总价结算，任务包单价结算）
     */
    @Comment("结算类型（任务包总价结算，任务包单价结算）")
    @Column()
    private String settleType;
    /**
     * 结算日期
     */
    @Comment("结算日期")
    @Column()
    private LocalDate settleDate;
    /**
     * 财务期间id
     */
    @Comment("财务期间id")
    @Column()
    private Long finPeriodId;
    /**
     * 验收方式
     */
    @Comment("验收方式")
    @Column()
    private String acceptMethod;
    /**
     * 事由类型 01 项目 02 商机
     */
    @Comment("事由类型 01 项目 02 商机")
    @Column(name = "reason_type")
    private String reasonType;
    /**
     * 项目id
     */
    @Comment("项目id")
    @Column(name = "proj_id")
    private Long projId;
    /**
     * 任务包id
     */
    @Comment("任务包id")
    @Column(name = "task_id")
    private Long taskId;
    /**
     * 项目名称（冗余）
     */
    @Comment("项目名称（冗余）")
    @Column()
    private String projName;
    /**
     * 任务包名称（冗余）
     */
    @Comment("任务包名称（冗余）")
    @Column()
    private String taskName;
    /**
     * 支出bu_id
     */
    @Comment("支出bu_id")
    @Column()
    private Long expenseBuId;
    /**
     * 收入资源id
     */
    @Comment("收入资源id")
    @Column(name = "income_res_id")
    private Long incomeResId;
    /**
     * 收入bu_id
     */
    @Comment("收入bu_id")
    @Column(name = "res_bu_id")
    private Long resBuId;
    /**
     * 当量系数
     */
    @Comment("当量系数")
    @Column()
    private BigDecimal eqvaRatio;
    /**
     * 当量工资(收入单价)
     */
    @Comment("当量工资(收入单价)")
    @Column()
    private BigDecimal eqvaSalary;
    /**
     * 申请结算当量数
     */
    @Comment("申请结算当量数")
    @Column(precision = 12, scale = 4)
    private BigDecimal applySettleEqva;
    /**
     * 申请结算总额
     */
    @Comment("申请结算总额")
    @Column()
    private BigDecimal applySettleAmt;
    /**
     * 结算单价
     */
    @Comment("结算单价")
    @Column()
    private BigDecimal settlePrice;
    /**
     * 实际结算当量数
     */
    @Comment("实际结算当量数")
    @Column(precision = 12, scale = 4)
    private BigDecimal approveSettleEqva;
    /**
     * 实际结算总额
     */
    @Comment("实际结算总额")
    @Column()
    private BigDecimal approveSettleAmt;
    /**
     * 申请收入总额
     */
    @Comment("申请收入总额")
    @Column()
    private BigDecimal applyIncomeAmt;
    /**
     * 实际收入总额
     */
    @Comment("实际收入总额")
    @Column()
    private BigDecimal approveIncomeAmt;
    /**
     * 币种
     */
    @Comment("币种")
    @Column()
    private String currCode;
    /**
     * 质保金比例
     */
    @Comment("质保金比例")
    @Column()
    private BigDecimal guaranteeRate;
    /**
     * 质保总额（冻结金额）
     */
    @Comment("质保总额（冻结金额）")
    @Column()
    private BigDecimal graranteeAmt;
    /**
     * 质保当量
     */
    @Comment("质保当量（冻结当量）")
    @Column(precision = 12, scale = 4)
    private BigDecimal graranteeEqva;
    /**
     * 申请人资源id
     */
    @Comment("申请人资源id")
    @Column()
    private Long applyResId;
    /**
     * 评价状态
     */
    @Comment("评价状态")
    @Column()
    private String evalStatus;
    /**
     * 累计提现当量
     */
    @Comment("累计提现当量")
    @Column(precision = 12, scale = 4)
    private BigDecimal withdrawEqva;
    /**
     * bu累计提现当量
     */
    @Comment("bu累计提现当量")
    @Column(precision = 12, scale = 4)
    private BigDecimal buWithdrawEqva;
    /**
     * 附件code
     */
    @Comment("附件code")
    @Column()
    private String fileCodes;
    /**
     * 发包资源id
     */
    @Comment("发包资源id")
    @Column()
    private Long disterResId;
    /**
     * 可用数量=批准结算当量-已提现当量-冻结当量
     */
    @Comment("可用数量")
    @Column(precision = 12, scale = 4)
    private BigDecimal avalQty;
    /**
     * 提现或解冻标识：（0：未操作，1：解冻中，2：提现中）
     */
    @Comment("提现或解冻标识")
    @Column(columnDefinition = "tinyint  DEFAULT 0")
    private Integer operateFlag;

    public void copy(CalTaskSettleDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
