package com.elitesland.tw.tw5.server.prd.common.functionEnum;

import lombok.Getter;

public enum BatchStatusEnum {


    CREATE("1", "新建"),
    APPLYING("2", "申请中"),
    APPROVETOINV("3", "已批准待开票"),
    APPROVETORECV("4", "已开票待收款"),
    BACK("5", "退回申请"),
    RECVING("6", "收款中"),
    RECVED("7", "收款完成"),
    INVBACK("8", "开票退回"),
    APPROVINGINVBACK("9", "退票申请中"),
    APPROVEDINVBACK("10", "已退票"),
    ;

    @Getter
    private final String code;

    /**
     * 描述
     */
    @Getter
    private final String desc;

    BatchStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static BatchStatusEnum getByCode(String code) {
        for (BatchStatusEnum value : BatchStatusEnum.values()) {
            if (value.getCode().equals(code)){
                return value;
            }
        }
        return null;
    }
}
