package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOperationPlanTempPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOperationPlanTempQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanTempService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOperationPlanTempVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 客户经营-经营计划模板
 *
 * @author duwh
 * @date 2022/11/17
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm")
@Slf4j
public class CrmOperationPlanTempController {

    private final CrmOperationPlanTempService service;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/operationPlanTemp")
    public TwOutputUtil insert(@RequestBody CrmOperationPlanTempPayload payload) {
        return TwOutputUtil.ok(service.insert(payload));
    }


    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("/operationPlanTemp")
    public TwOutputUtil update(@RequestBody CrmOperationPlanTempPayload payload) {
        return TwOutputUtil.ok(service.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/operationPlanTemp/{key}")
    @UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        CrmOperationPlanTempVO prdFileVO = service.queryByKey(key);
        return TwOutputUtil.ok(prdFileVO);
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/operationPlanTemp/paging")
    @UdcNameClass
    public TwOutputUtil paging(CrmOperationPlanTempQuery query) {
        PagingVO<CrmOperationPlanTempVO> paging = service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/operationPlanTemp/list")
    @UdcNameClass
    public TwOutputUtil queryList(CrmOperationPlanTempQuery query) {
        List<CrmOperationPlanTempVO> vos = service.queryList(query);
        return TwOutputUtil.ok(vos);
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/operationPlanTemp/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


}
