package com.elitesland.tw.tw5.server.prd.crm.dao;


import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityAnalyzeVO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunityAnalyzeDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunityAnalyzeDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityAnalyzeRepo;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author carl.wang
 * @Description:
 * @date
 */
@Repository
@RequiredArgsConstructor
public class CrmOpportunityAnalyzeDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CrmOpportunityAnalyzeRepo repo;

    private final QCrmOpportunityAnalyzeDO qdo = QCrmOpportunityAnalyzeDO.crmOpportunityAnalyzeDO;
    private final QPrdOrgEmployeeDO qdoEmployee = QPrdOrgEmployeeDO.prdOrgEmployeeDO;

    /**
     * @param id
     * @return
     * @Description
     **/
    public Long queryTW4IdById(Long id) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdo.analyzeIdV4).from(qdo);
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * @param ids
     * @return
     * @Description
     **/
    public List<Long> queryTW4IdsByIds(List<Long> ids) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdo.analyzeIdV4).from(qdo);
        jpaQuery.where(qdo.id.in(ids));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public CrmOpportunityAnalyzeDO save(CrmOpportunityAnalyzeDO ado) {
        return repo.save(ado);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<CrmOpportunityAnalyzeVO> getJpaQuerySelect() {
        JPAQuery<CrmOpportunityAnalyzeVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmOpportunityAnalyzeVO.class,
                qdo.id,
                qdo.oppoId,
                qdo.manageUserId,
                qdoEmployee.employeeName.as("manageUserName"),
                qdo.actionDesc,
                qdo.concernDesc,
                qdo.advantage,
                qdo.treatment,
                qdo.analyzeDate,
                qdo.remark

        )).from(qdo).leftJoin(qdoEmployee).on(qdoEmployee.userId.longValue().eq(qdo.manageUserId.longValue()));
        return jpaQuery;
    }

    /**
     * @param oppoId 商家主键
     * @return
     * @Description 主键查询
     **/
    public List<CrmOpportunityAnalyzeVO> queryList(Long oppoId) {
        JPAQuery<CrmOpportunityAnalyzeVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.oppoId.eq(oppoId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }

    public Long getIdByV4(Long analyzeIdV4) {
        return repo.geIdByV4(analyzeIdV4);
    }
}
