package com.elitesland.tw.tw5.server.prd.crm.dao;


import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunitySalesVO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunitySalesDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunitySalesDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunitySalesRepo;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author carl.wang
 * @Description:
 * @date
 */
@Repository
@RequiredArgsConstructor
public class CrmOpportunitySalesDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CrmOpportunitySalesRepo repo;
    private final QCrmOpportunitySalesDO qdo = QCrmOpportunitySalesDO.crmOpportunitySalesDO;

    /**
     * @param id
     * @return
     * @Description
     **/
    public Long queryTW4IdById(Long id) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdo.salesIdV4).from(qdo);
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * @param ids
     * @return
     * @Description
     **/
    public List<Long> queryTW4IdsByIds(List<Long> ids) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdo.salesIdV4).from(qdo);
        jpaQuery.where(qdo.id.in(ids));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public CrmOpportunitySalesDO save(CrmOpportunitySalesDO ado) {
        return repo.save(ado);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<CrmOpportunitySalesVO> getJpaQuerySelect() {
        JPAQuery<CrmOpportunitySalesVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmOpportunitySalesVO.class,
                qdo.id,
                qdo.oppoId,
                qdo.relatedProduct,
                qdo.bigType,
                qdo.samllType,
                qdo.saleTaxedAmt,
                qdo.saleTaxRate,
                qdo.saleNetAmt,
                qdo.purTaxedAmt,
                qdo.purTaxRate,
                qdo.purNetAmt,
                qdo.effectiveAmt,
                qdo.supplier,
                qdo.remark
        )).from(qdo);
        return jpaQuery;
    }

    /**
     * @param oppoId 商家主键
     * @return
     * @Description 主键查询
     **/
    public List<CrmOpportunitySalesVO> queryList(Long oppoId) {
        JPAQuery<CrmOpportunitySalesVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.oppoId.eq(oppoId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }

    public Long getIdByV4(Long salesIdV4) {
        return repo.getIdByV4(salesIdV4);
    }
}
