package com.elitesland.tw.tw5.server.prd.crm.entity;

import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Author carl.wang
 * @Description 活动跟进动态表
 * @Date
 **/
@Entity
@Table(name = "crm_act_report", indexes = {
        @Index(name = "act_index", columnList = "act_id"),
})
@org.hibernate.annotations.Table(appliesTo = "crm_act_report", comment = "活动汇报表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmActReportDO extends BaseModel {

    @Comment("活动id")
    @Column(name = "act_id", nullable = false)
    private Long actId;

    @Comment("汇报编号")
    @Column()
    private String reportNo;

    @Comment("人力总人天")
    @Column()
    private Integer personNum;

    @Comment("累计投入人力费用")
    @Column()
    private BigDecimal personMoney;

    @Comment("累计投入报销费用")
    @Column()
    private BigDecimal claimMoney;

    @Comment("累计投入采购费用")
    @Column()
    private BigDecimal purchaseMoney;

    @Comment("累计投入杂项费用")
    @Column()
    private BigDecimal sundryMoney;

    @Comment("累计投入总额")
    @Column()
    private BigDecimal totalMoney;

    @Comment("产出潜在客户")
    @Column()
    private Integer potentialCustomer;

    @Comment("产出线索")
    @Column()
    private Integer leadNum;

    @Comment("产出商机")
    @Column()
    private Integer busOps;

    @Comment("产出总收益")
    @Column()
    private BigDecimal pipeline;

    @Comment("其他活动说明")
    @Column()
    private String reportContent;

    @Comment("汇报类型")
    @Column()
    private Integer reportType;//1：详情汇报，2:结项报告


    @Comment("报告状态")
    @Column()
    private String reportStatus;

    @Comment("流程实例ID")
    @Column()
    private String procInstId;

    @Comment("流程审批状态")
    @Column()
    private ProcInstStatus procInstStatus;

    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;

    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;
}
