package com.elitesland.tw.tw5.server.prd.crm.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serial;
import java.time.LocalDateTime;

/**
 * 客户经营-经营计划明细
 *
 * @author duwh
 * @date 2022/11/15
 */
@Entity
@Table(name = "crm_customer_operation_plan_detail", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_customer_operation_plan_detail", comment = "经营计划明细")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmOperationPlanDetailDO extends BaseModel {

    @Serial
    private static final long serialVersionUID = 3328010403493353951L;

    @Comment("客户经营主键 crm_customer_operation.id")
    @Column()
    private Long operId;

    /**
     * 客户经营 名称
     */
    private String custName;

    @Transient
    public String getCustName() {
        if (null != operObj) {
            return operObj.getCustName();
        }
        return custName;
    }

    /**
     * 客户经营对象
     */
    @ManyToOne(fetch = FetchType.EAGER)
    @JoinColumn(name="operId",referencedColumnName="id",insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    //@org.hibernate.annotations.ForeignKey(name = "none")
    private CrmCustomerOperationDO operObj;

    @Comment("参与者")
    @OneToMany(fetch = FetchType.EAGER,cascade = CascadeType.ALL)
    @JoinColumn(name="planDetailId",insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    //@org.hibernate.annotations.ForeignKey(name = "none")
    private java.util.List<CrmOperationPlanDetailMemberDO> memberList;

    @Comment("主表id 预留字段")
    @Column()
    private Long planId;

    @Comment("计划名称")
    @Column()
    @FieldUpdateLog(fieldName = "名称")
    private String planName;

    /**
     * 需要存一万个汉字
     */
    @Comment("计划内容")
    @Column(columnDefinition = "text")
    @FieldUpdateLog(fieldName = "内容")
    private String planContent;

    @Comment("开始时间")
    @Column()
    @FieldUpdateLog(fieldName = "开始时间")
    private LocalDateTime startTime;

    @Comment("结束时间")
    @Column()
    @FieldUpdateLog(fieldName = "截止时间")
    private LocalDateTime endTime;

    @Comment("优先级 udc[crm:oper_plan:priority]")
    @Column()
    @FieldUpdateLog(fieldName = "优先级", selectionKey = "crm:oper_plan:priority")
    private String priority;

    @Comment("状态 udc[crm:oper_plan:status]")
    @Column()
    @FieldUpdateLog(fieldName = "状态", selectionKey = "crm:oper_plan:status")
    private String status;

    @Comment("执行者")
    @Column()
    @FieldUpdateLog(fieldName = "执行者", selectionKey = "USER")
    private Long performerId;

    @Column(
        name = "read_flag",
        columnDefinition = "int(10) default '0' comment '已读标记，0：未读，1：已读' "
    )
    private Integer readFlag = 0;

    @Comment("拓展1")
    @Column()
    private String ext1;

    @Comment("拓展2")
    @Column()
    private String ext2;

    @Comment("拓展3")
    @Column()
    private String ext3;

    @Comment("拓展4")
    @Column()
    private String ext4;

    @Comment("拓展5")
    @Column()
    private String ext5;


    public CrmOperationPlanDetailDO() {
    }

    public void copy(CrmOperationPlanDetailDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
