package com.elitesland.tw.tw5.server.prd.crm.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitesland.tw.tw5.api.common.annotation.FieldCreateLog;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import com.elitesland.tw.tw5.server.prd.prj.entity.PrjProjectDO;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;

/**
 * @author zoey
 * @Description:潜在客户表
 * @date 2022/5/17 - 14:13
 */
@Entity
@Table(name = "crm_potential_customer")
@org.hibernate.annotations.Table(appliesTo = "crm_potential_customer", comment = "潜在客户表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
@NamedEntityGraphs(
        {
                @NamedEntityGraph(name = "potentialCustomer.rule.list", attributeNodes = {
                        @NamedAttributeNode(value = "opensea"),
                        @NamedAttributeNode("market")
                }
//                ,subgraphs = {
//                        @NamedSubgraph(name = "opensea", attributeNodes = {
//                                @NamedAttributeNode("openseaMembers"),
//                                @NamedAttributeNode("openseaAdmins"),
//                        })
//                }
                ),
                @NamedEntityGraph(name = "potentialCustomer.rule.detail", attributeNodes = {
                        @NamedAttributeNode("opensea"),
                        @NamedAttributeNode("market")
                }),
        }
)
public class CrmPotentialCustomerDO extends BaseModel {

    @FieldUpdateLog(objectNameField = "customerName",selectionKey = "OPENSEA",changeAction = "转移到")
    @FieldCreateLog(fieldName = "公海",selectionKey = "OPENSEA")
    @Comment("公海")
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name="openseaId",referencedColumnName="id", foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    private CrmOpenseaDO opensea;

    @Comment("市场活动")
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name="marketId",referencedColumnName="id", foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    private PrjProjectDO market;

    @FieldUpdateLog(fieldName = "客户标签",selectionKey = "crm:tags")
    @FieldCreateLog(fieldName = "客户标签",selectionKey = "crm:tags")
    @Comment("客户标签")
    private String tagIds;

    @FieldUpdateLog(fieldName = "客户名称")
    @FieldCreateLog(fieldName = "客户名称")
    @Comment("客户名称")
    @Column(name = "customer_name", nullable = false)
    private String customerName;

    @FieldUpdateLog(fieldName = "客户编号")
    @FieldCreateLog(fieldName = "客户编号")
    @Comment("客户编号")
    @Column(name = "customer_no", nullable = false)
    private String customerNo;

    @FieldUpdateLog(fieldName = "客户状态",selectionKey = "crm:potential_customer_status")
    @FieldCreateLog(fieldName = "客户状态",selectionKey = "crm:potential_customer_status")
    @Comment("客户状态")
    @Column(name = "customer_status")
    private String customerStatus;

    @FieldUpdateLog(fieldName = "客户级别",selectionKey = "crm:customer_grade")
    @FieldCreateLog(fieldName = "客户级别",selectionKey = "crm:customer_grade")
    @Comment("客户级别")
    @Column(name = "customer_grade")
    private String customerGrade;

    @FieldUpdateLog(fieldName = "客户行业",selectionKey = "crm:leads_customer_industry")
    @FieldCreateLog(fieldName = "客户行业",selectionKey = "crm:leads_customer_industry")
    @Comment("客户行业")
    @Column(name = "customer_industry")
    private String customerIndustry;

    @FieldUpdateLog(fieldName = "联系人姓名")
    @FieldCreateLog(fieldName = "联系人姓名")
    @Comment("联系人姓名")
    @Column(name = "customer_contacts")
    private String customerContacts;

    @FieldUpdateLog(fieldName = "客户电话")
    @FieldCreateLog(fieldName = "客户电话")
    @Comment("客户电话")
    @Column(name = "customer_phone")
    private String customerPhone;

    @FieldUpdateLog(fieldName = "客户邮箱")
    @FieldCreateLog(fieldName = "客户邮箱")
    @Comment("客户邮箱")
    @Column(name = "customer_email")
    private String customerEmail;

    @Comment("客户地址-省")
    @Column(name = "customer_address_province")
    private String customerLocationProvince;


    @Comment("客户地址-市")
    @Column(name = "customer_address_city")
    private String customerLocationCity;


    @Comment("客户地址-区")
    @Column(name = "customer_address_district")
    private String customerLocationDistrict;

    @FieldUpdateLog(fieldName = "客户地址-省")
    @FieldCreateLog(fieldName = "客户地址-省")
    @Comment("客户地址-省")
    @Column(name = "customer_address_province_name")
    private String customerLocationProvinceName;

    @FieldUpdateLog(fieldName = "客户地址-市")
    @FieldCreateLog(fieldName = "客户地址-市")
    @Comment("客户地址-市")
    @Column(name = "customer_address_city_name")
    private String customerLocationCityName;

    @FieldUpdateLog(fieldName = "客户地址-区")
    @FieldCreateLog(fieldName = "客户地址-区")
    @Comment("客户地址-区")
    @Column(name = "customer_address_district_name")
    private String customerLocationDistrictName;

    @FieldUpdateLog(fieldName = "客户地址-详细地址")
    @FieldCreateLog(fieldName = "客户地址-详细地址")
    @Comment("客户地址-详细地址")
    @Column(name = "customer_address_detail")
    private String customerLocationDetail;

    @FieldUpdateLog(fieldName = "转移原因")
    @Comment("转移原因")
    @Column(name = "transfer_reason")
    private String transferReason;

    @FieldUpdateLog(fieldName = "需求产品",selectionKey ="crm:leads_demand_product")
    @FieldCreateLog(fieldName = "需求产品",selectionKey ="crm:leads_demand_product")
    @Comment("需求产品")
    @Column()
    private String demandProduct;

    @Transient
    @Comment("公海id")
    private Long openseaId;

    @Transient
    @Comment("市场活动id")
    private Long marketId;


    @FieldUpdateLog(fieldName = "客户区域",selectionKey = "crm:customer_region")
    @FieldCreateLog(fieldName = "客户区域",selectionKey = "crm:customer_region")
    @Comment("客户区域")
    @Column(name = "cust_region")
    private String custRegion;

    @FieldUpdateLog(fieldName = "市场渠道",selectionKey = "crm:leads_channel")
    @FieldCreateLog(fieldName = "市场渠道",selectionKey = "crm:leads_channel")
    @Comment("市场渠道")
    @Column(name = "market_channel")
    private String marketChannel;

    @FieldUpdateLog(fieldName = "联系人部门")
    @FieldCreateLog(fieldName = "联系人部门")
    @Comment("联系人部门")
    @Column(name = "contacts_department")
    private String contactsDepartment;

    @FieldUpdateLog(fieldName = "联系人岗位")
    @FieldCreateLog(fieldName = "联系人岗位")
    @Comment("联系人岗位")
    @Column(name = "contacts_position")
    private String contactsPosition;


    public void copy(CrmPotentialCustomerDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }


}
