package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunitySalesPayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunitySalesService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunitySalesVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.StringUtil;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOpportunitySalesConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunitySalesDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunitySalesDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author carl.wang
 * @Description 商机销售清单管理
 * @Date 20220527
 **/
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmOpportunitySalesServiceImpl implements CrmOpportunitySalesService {
    private final CacheUtil cacheUtil;
    private final CrmOpportunitySalesDAO dao;
    private final CrmOpportunityDAO opportunityDAO;
    private final PrdSystemLogService logService;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;

    @Value("${tw4.opportunity.sales_operation}")
    private String sales_operation;

    @Value("${tw4.opportunity.sales_del}")
    private String sales_del;

    @Transactional
    @Override
    public CrmOpportunitySalesVO insert(CrmOpportunitySalesPayload payload) {
        if(payload.getOppoIdV4()!=null){
            payload.setOppoId(opportunityDAO.getIdByV4(payload.getOppoIdV4()));
        }
        if(payload.getSalesIdV4()!=null){
            payload.setId(dao.getIdByV4(payload.getSalesIdV4()));
        }
        //同步到4.0
//        Map<String, Object> map = transferUtilService.beanToMap(payload);
//        String result = httpUtil.sendSyncPost(sales_operation, map);
//        String salesId = httpUtil.geResultData(result);
//        long salesIdV4 = 0;
//        if (StringUtils.hasText(salesId)) {
//            if (StringUtil.isInteger(salesId)) {
//                salesIdV4 = Long.valueOf(salesId);
//            }
//        }
        CrmOpportunitySalesDO ado = CrmOpportunitySalesConvert.INSTANCE.toDo(payload);
//        ado.setSalesIdV4(salesIdV4);
        dao.save(ado);
        logService.saveNewLog(payload.getOppoId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.ADD.getDesc() + "销售清单");
        return CrmOpportunitySalesConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    @Override
    public Long update(CrmOpportunitySalesPayload payload) {
        if(payload.getOppoIdV4()!=null){
            payload.setOppoId(opportunityDAO.getIdByV4(payload.getOppoIdV4()));
        }
        if(payload.getSalesIdV4()!=null){
            payload.setId(dao.getIdByV4(payload.getSalesIdV4()));
        }
        //同步到4.0
//        Long salesIdV4 = payload.getSalesIdV4()==null?dao.queryTW4IdById(payload.getId()):payload.getSalesIdV4();
//        Map<String, Object> map = transferUtilService.beanToMap(payload);
//        map.put("id", salesIdV4);
//        String result = httpUtil.sendSyncPost(sales_operation, map);
//        httpUtil.geResultData(result);
        CrmOpportunitySalesDO ado = CrmOpportunitySalesConvert.INSTANCE.toDo(payload);
//        ado.setSalesIdV4(salesIdV4);
        dao.save(ado);
        logService.saveNewLog(payload.getOppoId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.UPDATE.getDesc() + "销售清单");
        return 0L;
    }

    @Override
    public List<CrmOpportunitySalesVO> queryList(Long oppoId) {

        return dao.queryList(oppoId);
    }

    @Transactional
    @Override
    public boolean deleteSoft(Long oppoId, List<Long> keys) {
        //同步到4.0
//        Map<String, Object> map = new HashMap<>();
//        map.put("ids", org.apache.commons.lang3.StringUtils.join(dao.queryTW4IdsByIds(keys), ","));
//        String result = httpUtil.sendSyncGet(sales_del, map);
//        httpUtil.geResultData(result);
        dao.deleteSoft(keys);
        logService.saveNewLog(oppoId, PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.DELETE.getDesc() + "销售清单");
        return true;
    }
}
