package com.elitesland.tw.tw5.server.prd.humanresources.eval.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluatePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEvaluateQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEvaluateService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-11-24
 * @desc : 评价表
 */

@RestController
@RequestMapping("/api/prdEvaluate")
@RequiredArgsConstructor
@Api(value = "评价表", tags = {"评价表"})
public class PrdEvaluateController {

    private final PrdEvaluateService prdEvaluateService;


    @GetMapping("get/{id}")
    @ApiOperation("详情-评价表")
    public TwOutputUtil<PrdEvaluateVO> get(@PathVariable Long id) {

        PrdEvaluateVO res = prdEvaluateService.get(id);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("save")
    @ApiOperation("新增-评价表")
    public TwOutputUtil<Long> save(@RequestBody PrdEvaluatePayload prdEvaluatePayload) {

        PrdEvaluateVO res = prdEvaluateService.save(prdEvaluatePayload);
        return TwOutputUtil.ok(res.getId());

    }

    @PostMapping("batchSave")
    @ApiOperation("批量新增-评价表")
    public TwOutputUtil<Long> batchSave(@RequestBody List<PrdEvaluatePayload> prdEvaluatePayloadList) {

        Boolean res = prdEvaluateService.batchSave(prdEvaluatePayloadList);
        return TwOutputUtil.ok(res);

    }


//    @PostMapping("update")
//    @ApiOperation("修改-评价表")
//    public TwOutputUtil<Long> update(@RequestBody PrdEvaluatePayload prdEvaluatePayload) {
//
//        PrdEvaluateVO res = prdEvaluateService.update(prdEvaluatePayload);
//        return TwOutputUtil.ok(res.getId());
//
//    }


    @DeleteMapping("del")
    @ApiOperation("删除-评价表")
    public TwOutputUtil<Long> del(Long[] ids) {

        Long res = prdEvaluateService.del(Arrays.asList(ids));
        return TwOutputUtil.ok(res);

    }


    @GetMapping("/page")
    @UdcNameClass
    @ApiOperation("分页查询-评价表")
    public TwOutputUtil<PagingVO<PrdEvaluateVO>> page(PrdEvaluateQuery prdEvaluateQuery) {

        PagingVO<PrdEvaluateVO> res = prdEvaluateService.page(prdEvaluateQuery);
        return TwOutputUtil.ok(res);

    }


    @GetMapping("getList")
    @ApiOperation("查询列表-评价表")
    public TwOutputUtil<List<PrdEvaluateVO>> getList(PrdEvaluateQuery prdEvaluateQuery) {

        List<PrdEvaluateVO> res = prdEvaluateService.getList(prdEvaluateQuery);
        return TwOutputUtil.ok(res);

    }

}

