package com.elitesland.tw.tw5.server.prd.humanresources.eval.dao;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluatePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEvaluateQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateVO;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.entity.PrdEvaluateDO;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.entity.QPrdEvaluateDO;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.springframework.stereotype.Component;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.querydsl.core.types.Predicate;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;

import java.util.List;

import com.querydsl.core.types.ExpressionUtils;

import java.util.ArrayList;


/**
 * @author : WWW
 * @date : 2023-11-24
 * @desc : 评价表RepoProc
 */

@Component
public class PrdEvaluateDao extends BaseRepoProc<PrdEvaluateDO> {

    private static final QPrdEvaluateDO qPrdEvaluateDO = QPrdEvaluateDO.prdEvaluateDO;


    protected PrdEvaluateDao() {

        super(qPrdEvaluateDO);

    }


    public PagingVO<PrdEvaluateVO> page(PrdEvaluateQuery prdEvaluateQuery) {

        JPAQuery<PrdEvaluateVO> query =
                select(PrdEvaluateVO.class)
                        .where(bulidPredicate(prdEvaluateQuery));
        prdEvaluateQuery.setPaging(query);
        prdEvaluateQuery.fillOrders(query, qPrdEvaluateDO);
        return PagingVO.<PrdEvaluateVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qPrdEvaluateDO)
                .set(qPrdEvaluateDO.deleteFlag, 1)
                .where(qPrdEvaluateDO.id.in(ids))
                .execute();

        return res;

    }


    public PrdEvaluateVO get(Long id) {

        PrdEvaluateVO prdEvaluateVO = select(PrdEvaluateVO.class)
                .where(qPrdEvaluateDO.id.eq(id))
                .fetchOne();

        return prdEvaluateVO;

    }


    public List<PrdEvaluateVO> getList(PrdEvaluateQuery prdEvaluateQuery) {

        List<PrdEvaluateVO> res =
                select(PrdEvaluateVO.class)
                        .where(bulidPredicate(prdEvaluateQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        qPrdEvaluateDO.fromId,
                        qPrdEvaluateDO.configId,
                        qPrdEvaluateDO.itemName,
                        qPrdEvaluateDO.cate,
                        qPrdEvaluateDO.type,
                        qPrdEvaluateDO.proId,
                        qPrdEvaluateDO.taskId,
                        qPrdEvaluateDO.actId,
                        qPrdEvaluateDO.evalDesc,
                        qPrdEvaluateDO.evalDate,
                        qPrdEvaluateDO.evalUser,
                        qPrdEvaluateDO.evalUserId,
                        qPrdEvaluateDO.toEvalUser,
                        qPrdEvaluateDO.toEvalUserId,
                        qPrdEvaluateDO.averageScore,
                        qPrdEvaluateDO.id,
                        qPrdEvaluateDO.createTime,
                        qPrdEvaluateDO.remark

                )).from(qPrdEvaluateDO);

    }


    private Predicate bulidPredicate(PrdEvaluateQuery prdEvaluateQuery) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(null != prdEvaluateQuery.getFromId(), qPrdEvaluateDO.fromId, prdEvaluateQuery.getFromId())
                .andEq(null != prdEvaluateQuery.getConfigId(), qPrdEvaluateDO.configId, prdEvaluateQuery.getConfigId())
                .andEq(null != prdEvaluateQuery.getState(), qPrdEvaluateDO.state, prdEvaluateQuery.getState())
                .andEq(StringUtils.isNotBlank(prdEvaluateQuery.getItemName()), qPrdEvaluateDO.itemName, prdEvaluateQuery.getItemName())
                .andEq(StringUtils.isNotBlank(prdEvaluateQuery.getCate()), qPrdEvaluateDO.cate, prdEvaluateQuery.getCate())
                .andEq(StringUtils.isNotBlank(prdEvaluateQuery.getType()), qPrdEvaluateDO.type, prdEvaluateQuery.getType())
                .andEq(null != prdEvaluateQuery.getProId(), qPrdEvaluateDO.proId, prdEvaluateQuery.getProId())
                .andEq(null != prdEvaluateQuery.getTaskId(), qPrdEvaluateDO.taskId, prdEvaluateQuery.getTaskId())
                .andEq(null != prdEvaluateQuery.getActId(), qPrdEvaluateDO.actId, prdEvaluateQuery.getActId())
                .andEq(StringUtils.isNotBlank(prdEvaluateQuery.getEvalDesc()), qPrdEvaluateDO.evalDesc, prdEvaluateQuery.getEvalDesc())
                .andEq(null != prdEvaluateQuery.getEvalDate(), qPrdEvaluateDO.evalDate, prdEvaluateQuery.getEvalDate())
                .andEq(StringUtils.isNotBlank(prdEvaluateQuery.getEvalUser()), qPrdEvaluateDO.evalUser, prdEvaluateQuery.getEvalUser())
                .andEq(null != prdEvaluateQuery.getEvalUserId(), qPrdEvaluateDO.evalUserId, prdEvaluateQuery.getEvalUserId())
                .andEq(StringUtils.isNotBlank(prdEvaluateQuery.getToEvalUser()), qPrdEvaluateDO.toEvalUser, prdEvaluateQuery.getToEvalUser())
                .andEq(null != prdEvaluateQuery.getToEvalUserId(), qPrdEvaluateDO.toEvalUserId, prdEvaluateQuery.getToEvalUserId())
                .andGoe(null != prdEvaluateQuery.getEvalDateStart(), qPrdEvaluateDO.evalDate, prdEvaluateQuery.getEvalDateStart())
                .andLoe(null != prdEvaluateQuery.getEvalDateEnd(), qPrdEvaluateDO.evalDate, prdEvaluateQuery.getEvalDateEnd())
                .andGoe(null != prdEvaluateQuery.getAverageScoreStart(), qPrdEvaluateDO.averageScore, prdEvaluateQuery.getAverageScoreStart())
                .andLoe(null != prdEvaluateQuery.getAverageScoreEnd(), qPrdEvaluateDO.averageScore, prdEvaluateQuery.getAverageScoreEnd())
                .build();

        return predicate;

    }


    private List<Predicate> bulidPredicates(PrdEvaluateQuery prdEvaluateQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 来源id
        if (null != prdEvaluateQuery.getFromId()) {
            predicates.add(qPrdEvaluateDO.fromId.eq(prdEvaluateQuery.getFromId()));
        }
        // 配置id
        if (null != prdEvaluateQuery.getConfigId()) {
            predicates.add(qPrdEvaluateDO.configId.eq(prdEvaluateQuery.getConfigId()));
        }
        // 评价对象名称
        if (StringUtils.isNotEmpty(prdEvaluateQuery.getItemName())) {
            predicates.add(qPrdEvaluateDO.itemName.eq(prdEvaluateQuery.getItemName()));
        }
        // 评价类别
        if (StringUtils.isNotEmpty(prdEvaluateQuery.getCate())) {
            predicates.add(qPrdEvaluateDO.cate.eq(prdEvaluateQuery.getCate()));
        }
        // 评价类型
        if (StringUtils.isNotEmpty(prdEvaluateQuery.getType())) {
            predicates.add(qPrdEvaluateDO.type.eq(prdEvaluateQuery.getType()));
        }
        // 项目id
        if (null != prdEvaluateQuery.getProId()) {
            predicates.add(qPrdEvaluateDO.proId.eq(prdEvaluateQuery.getProId()));
        }
        // 任务id
        if (null != prdEvaluateQuery.getTaskId()) {
            predicates.add(qPrdEvaluateDO.taskId.eq(prdEvaluateQuery.getTaskId()));
        }
        // 活动id
        if (null != prdEvaluateQuery.getActId()) {
            predicates.add(qPrdEvaluateDO.actId.eq(prdEvaluateQuery.getActId()));
        }
        // 评价说明
        if (StringUtils.isNotEmpty(prdEvaluateQuery.getEvalDesc())) {
            predicates.add(qPrdEvaluateDO.evalDesc.eq(prdEvaluateQuery.getEvalDesc()));
        }
        // 评价日期
        if (null != prdEvaluateQuery.getEvalDate()) {
            predicates.add(qPrdEvaluateDO.evalDate.eq(prdEvaluateQuery.getEvalDate()));
        }
        // 评价人
        if (StringUtils.isNotEmpty(prdEvaluateQuery.getEvalUser())) {
            predicates.add(qPrdEvaluateDO.evalUser.eq(prdEvaluateQuery.getEvalUser()));
        }
        // 评价人id
        if (null != prdEvaluateQuery.getEvalUserId()) {
            predicates.add(qPrdEvaluateDO.evalUserId.eq(prdEvaluateQuery.getEvalUserId()));
        }
        // 被评价人
        if (StringUtils.isNotEmpty(prdEvaluateQuery.getToEvalUser())) {
            predicates.add(qPrdEvaluateDO.toEvalUser.eq(prdEvaluateQuery.getToEvalUser()));
        }
        // 被评价人id
        if (null != prdEvaluateQuery.getToEvalUserId()) {
            predicates.add(qPrdEvaluateDO.toEvalUserId.eq(prdEvaluateQuery.getToEvalUserId()));
        }

//      Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicates;
    }


    public Long count(PrdEvaluateQuery prdEvaluateQuery) {

        long res = select(PrdEvaluateVO.class)
                .where(bulidPredicate(prdEvaluateQuery))
                .fetchCount();

        return res;


    }

    public Long update(PrdEvaluatePayload prdEvaluatePayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qPrdEvaluateDO);

        // 来源id
        if (null != prdEvaluatePayload.getFromId()) {
            update.set(qPrdEvaluateDO.fromId, prdEvaluatePayload.getFromId());
        }
        // 配置id
        if (null != prdEvaluatePayload.getConfigId()) {
            update.set(qPrdEvaluateDO.configId, prdEvaluatePayload.getConfigId());
        }
        // 评价对象名称
        if (StringUtils.isNotEmpty(prdEvaluatePayload.getItemName())) {
            update.set(qPrdEvaluateDO.itemName, prdEvaluatePayload.getItemName());
        }
        // 评价类别
        if (StringUtils.isNotEmpty(prdEvaluatePayload.getCate())) {
            update.set(qPrdEvaluateDO.cate, prdEvaluatePayload.getCate());
        }
        // 评价类型
        if (StringUtils.isNotEmpty(prdEvaluatePayload.getType())) {
            update.set(qPrdEvaluateDO.type, prdEvaluatePayload.getType());
        }
        // 项目id
        if (null != prdEvaluatePayload.getProId()) {
            update.set(qPrdEvaluateDO.proId, prdEvaluatePayload.getProId());
        }
        // 任务id
        if (null != prdEvaluatePayload.getTaskId()) {
            update.set(qPrdEvaluateDO.taskId, prdEvaluatePayload.getTaskId());
        }
        // 活动id
        if (null != prdEvaluatePayload.getActId()) {
            update.set(qPrdEvaluateDO.actId, prdEvaluatePayload.getActId());
        }
        // 评价说明
        if (StringUtils.isNotEmpty(prdEvaluatePayload.getEvalDesc())) {
            update.set(qPrdEvaluateDO.evalDesc, prdEvaluatePayload.getEvalDesc());
        }
        // 评价日期
        if (null != prdEvaluatePayload.getEvalDate()) {
            update.set(qPrdEvaluateDO.evalDate, prdEvaluatePayload.getEvalDate());
        }
        // 评价人
        if (StringUtils.isNotEmpty(prdEvaluatePayload.getEvalUser())) {
            update.set(qPrdEvaluateDO.evalUser, prdEvaluatePayload.getEvalUser());
        }
        // 评价人id
        if (null != prdEvaluatePayload.getEvalUserId()) {
            update.set(qPrdEvaluateDO.evalUserId, prdEvaluatePayload.getEvalUserId());
        }
        // 被评价人
        if (StringUtils.isNotEmpty(prdEvaluatePayload.getToEvalUser())) {
            update.set(qPrdEvaluateDO.toEvalUser, prdEvaluatePayload.getToEvalUser());
        }
        // 被评价人id
        if (null != prdEvaluatePayload.getToEvalUserId()) {
            update.set(qPrdEvaluateDO.toEvalUserId, prdEvaluatePayload.getToEvalUserId());
        }
        long res = update.where(qPrdEvaluateDO.id.eq(prdEvaluatePayload.getId()))
                .execute();
        return res;

    }

    public Long updateStateByFormId(PrdEvaluatePayload prdEvaluatePayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qPrdEvaluateDO);
        long res = update.set(qPrdEvaluateDO.state, prdEvaluatePayload.getState())
                .where(qPrdEvaluateDO.fromId.eq(prdEvaluatePayload.getFromId()))
                .execute();
        return res;
    }

    public List<PrdEvaluateVO> getScoreListByUserId(PrdEvaluateQuery prdEvaluateQuery) {
        JPAQuery<PrdEvaluateVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PrdEvaluateVO.class,
//                qPrdEvaluateDO.fromId,
                qPrdEvaluateDO.cate,
                qPrdEvaluateDO.toEvalUserId,
                qPrdEvaluateDO.averageScore,
                qPrdEvaluateDO.id

        )).from(qPrdEvaluateDO);
        List<PrdEvaluateVO> res = jpaQuery.where(bulidPredicate(prdEvaluateQuery)).fetch();
        return res;
    }

}

