package com.elitesland.tw.tw5.server.prd.humanresources.examination.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamResDtlService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamResultService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-11-14
 * @desc : 绩效考核
 */

@RestController
@RequestMapping("/api/prdPerformanceExam")
@RequiredArgsConstructor
@Api(value = "绩效考核", tags = {"绩效考核"})
public class PrdPerformanceExamController {

    private final PrdPerformanceExamService prdPerformanceExamService;



    @GetMapping("get/{id}")
    @ApiOperation("详情-绩效考核")
    public TwOutputUtil<PrdPerformanceExamVO> get(@PathVariable Long id) {

        PrdPerformanceExamVO res = prdPerformanceExamService.get(id);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("save")
    @ApiOperation("新增-绩效考核")
    public TwOutputUtil<Long> save(@RequestBody PrdPerformanceExamPayload prdPerformanceExamPayload) {

        PrdPerformanceExamVO res = prdPerformanceExamService.save(prdPerformanceExamPayload);
        return TwOutputUtil.ok(res.getId());

    }


    @PostMapping("update")
    @ApiOperation("修改-绩效考核")
    public TwOutputUtil<Long> update(@RequestBody PrdPerformanceExamPayload prdPerformanceExamPayload) {

        PrdPerformanceExamVO res = prdPerformanceExamService.update(prdPerformanceExamPayload);
        return TwOutputUtil.ok(res.getId());

    }


    @DeleteMapping("del")
    @ApiOperation("删除-绩效考核")
    public TwOutputUtil<Long> del(Long[] ids) {

        Long res = prdPerformanceExamService.del(Arrays.asList(ids));
        return TwOutputUtil.ok(res);

    }


    @GetMapping("/page")
    @UdcNameClass
    @ApiOperation("分页查询-绩效考核")
    public TwOutputUtil<PagingVO<PrdPerformanceExamVO>> page(PrdPerformanceExamQuery prdPerformanceExamQuery) {

        PagingVO<PrdPerformanceExamVO> res = prdPerformanceExamService.page(prdPerformanceExamQuery);
        return TwOutputUtil.ok(res);

    }

    @PostMapping("updateState")
    @ApiOperation("修改-绩效考核")
    public TwOutputUtil<Long> updateState(@RequestBody PrdPerformanceExamPayload prdPerformanceExamPayload) {

        Long res = prdPerformanceExamService.updateByCondition(prdPerformanceExamPayload);
        return TwOutputUtil.ok(res);

    }

    @PostMapping("startflow")
    @ApiOperation("发起-绩效考核")
    public TwOutputUtil<Long> startflow(@RequestBody PrdPerformanceExamPayload prdPerformanceExamPayload) {

        Long res = prdPerformanceExamService.startflow(prdPerformanceExamPayload);
        return TwOutputUtil.ok(res);

    }

}

