package com.elitesland.tw.tw5.server.prd.humanresources.examination.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluatePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdProbationExamPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdProbationExamQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonResService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEvaluateService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdProbationExamService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdProbationExamVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdMessageConfigVO;
import com.elitesland.tw.tw5.server.common.util.JavaMailPayload;
import com.elitesland.tw.tw5.server.common.util.JavaMailUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.base.HrBaseEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdProbationExamConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.dao.PrdProbationExamDao;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.PrdProbationExamDO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.repo.PrdProbationExamRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * @author : WWW
 * @date : 2023-12-2
 * @desc : 试用期考核Service
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class PrdProbationExamServiceImpl implements PrdProbationExamService {


    private final PrdProbationExamDao prdProbationExamDao;

    private final PrdProbationExamRepo prdProbationExamRepo;

    private final PrdSystemRoleDAO prdSystemRoleDAO;

    private final PrdOrgEmployeeDAO prdOrgEmployeeDAO;

    private final WorkflowUtil workflowUtil;

    private final PrdOrgOrganizationService prdOrgOrganizationService;

    private final PrdEvaluateService prdEvaluateService;

    private final JavaMailUtil mailUtil;

    private final PrdMessageConfigService messageConfigService;


    private final PrdOrgEmployeeService prdOrgEmployeeService;

    private final PersonResService personResService;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdProbationExamVO save(PrdProbationExamPayload prdProbationExamPayload) {

        checkData(prdProbationExamPayload);

        // 重复校验已发起的流程
        PrdProbationExamQuery prdProbationExamQuery = new PrdProbationExamQuery();
        prdProbationExamQuery.setType(prdProbationExamPayload.getType());
        prdProbationExamQuery.setUserId(prdProbationExamPayload.getUserId());
        prdProbationExamQuery.setProcInstStatus(ProcInstStatus.APPROVING);

        Long count = prdProbationExamDao.count(prdProbationExamQuery);
        if (count > 0) {
            throw new BusinessException(HrBaseEnum.FLOW_REPEAT_ERR.getDesc());
        }

        PrdProbationExamDO prdProbationExamDO = new PrdProbationExamDO();
        prdProbationExamDO = PrdProbationExamConvert.INSTANCE.p2d(prdProbationExamPayload);
        prdProbationExamDO.setApplyDate(LocalDate.now());
        prdProbationExamDO.setFinishFlag(false);
        prdProbationExamDO.setApplyUserId(prdProbationExamPayload.getUserId());

        Boolean recommendFlag = false;
        // 查询该资源信息是否内推的，设置标记

        PrdOrgEmployeeVO prdOrgEmployeeVO = prdOrgEmployeeService.queryByUserId(prdProbationExamQuery.getUserId());
        if (null == prdOrgEmployeeVO) {
            throw new BusinessException("未找到该资源，请核实：" + prdProbationExamQuery.getUserId());
        }
        if (null != prdOrgEmployeeVO.getJobInternalRecommId()) {
            recommendFlag = true;
            prdProbationExamDO.setRecommendUserId(prdOrgEmployeeVO.getJobInternalRecommId());
        }

        prdProbationExamDO.setRecommendFlag(recommendFlag);

        PrdProbationExamDO res = prdProbationExamRepo.save(prdProbationExamDO);

        if (prdProbationExamPayload.getType().equals(HrBaseEnum.MIDDLE.getCode())) {
            // 发起中期流程
            startWorkFlow(res, prdProbationExamPayload.getTaskFlag());
        } else if (prdProbationExamPayload.getType().equals(HrBaseEnum.LATE.getCode())) {
            // 发起末期流程
            startWorkFlowLate(res, prdProbationExamPayload.getTaskFlag());
        }

        // 发送邮件
//        sendEmail(res);
        JavaMailPayload javaMailPayload = new JavaMailPayload();
        javaMailPayload.setReceiveEmail(res.getEmail());
        javaMailPayload.setText("试用期考核流程已发送，请关注tw平台待办信息");
        javaMailPayload.setSubject("试用期考核流程发起通知");
        mailUtil.sendEmailAsyncByAdmin(javaMailPayload);

        // 发送邮件通知
//        SimpleEmailDTO simpleEmailDTO = new SimpleEmailDTO();
//        BaseEmailDTO.Address address = new BaseEmailDTO.Address();
//        address.setEmailAddress(res.getEmail());
//        address.setPersonName(res.getUserName());
//        simpleEmailDTO.setTo(Set.of(address));
//        simpleEmailDTO.setSubject("试用期考核流程");
//        simpleEmailDTO.setBusinessType("TW");
//        simpleEmailDTO.setContent("试用期考核流程已发送，请关注tw平台待办信息");
//        ApiResult<Boolean> booleanApiResult = emailRpcService.sendSimpleEmail(simpleEmailDTO);
//        if (booleanApiResult.isFailed()) {
//            log.error("试用期考核流程邮箱发送失败,{}", booleanApiResult.getMsg());
//        }
        return PrdProbationExamConvert.INSTANCE.d2v(res);

    }

    private void startWorkFlowLate(PrdProbationExamDO res, Boolean taskFlag) {

        // 启动工作流
        HashMap<String, Object> variables = new HashMap<>();

        // 培训人确认 平台IT管理员（PLATFORM_IT_ADMINISTRATOR）角色成员：宫入匀
//        List<Long> glUserIds = prdSystemRoleDAO.queryUserIdByRoleCodes(List.of("PLATFORM_IT_ADMINISTRATOR"));
//        variables.put("Activity_1mm1x7m", glUserIds);

        // 资源自评
        variables.put("Activity_0b5qy4u", res.getUserId());
        // 直属领导评价
        PrdOrgEmployeeRefDO prdOrgEmployeeRefDO = prdOrgEmployeeDAO.queryByOrgIdAndUserId(res.getBaseBuId(), res.getUserId());
        if (null != prdOrgEmployeeRefDO) {
            variables.put("Activity_01gwytg", prdOrgEmployeeRefDO.getParentId());
        }
        // Bu负责人评价
        PrdOrgOrganizationVO prdOrgOrganizationVO = prdOrgOrganizationService.queryDetailSimpleByOrgId(res.getBaseBuId());
        variables.put("Activity_0q54wfb", prdOrgOrganizationVO.getManageId());

        String procName = "A43.试用期考核流程(末期)";

        procName = procName + res.getUserName();

        // 录入内推奖励  招聘经理（HIRING_MANAGER）
        List<Long> hrUserIds = prdSystemRoleDAO.queryUserIdByRoleCodes(List.of(RoleEnum.PLAT_HIRING_MANAGER.getCode()));
        variables.put("Activity_00mrx9q", hrUserIds);


        Boolean pushFlag = false;

        variables.put("push", pushFlag);

        Long procuserId = res.getUserId();
        if (!taskFlag) {
            procuserId = GlobalUtil.getLoginUser().getId();
        }

        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                HrBaseEnum.PROBATION_EXAM_LATE.getCode(),
                procName,
                res.getId().toString(),
                variables), procuserId);

        String procInstId = processInfo.getProcInstId();
        ProcInstStatus procInstStatus = processInfo.getProcInstStatus();

        PrdProbationExamPayload payload = new PrdProbationExamPayload();
        payload.setId(res.getId());
        // 流程编号
        payload.setProcInstId(procInstId);
        payload.setProcInstStatus(procInstStatus);
        payload.setName(procName);
        payload.setType(res.getType());
        updateByCondition(payload);

    }

    private void sendEmail(PrdProbationExamDO res) {

        //捕获异常，邮件发送是否成功不应影响事务
        try {
            log.info("开始发邮件逻辑");
            List<Long> receiveUserIds = new ArrayList<>();

            receiveUserIds.add(res.getUserId());
//            PrdOrgOrganizationDO orgOrganizationDO = orgOrganizationDAO.queryByName("市场部");
//            receiveUserIds.add(orgOrganizationDO.getManageId());

            String noticeSource = String.join(",", receiveUserIds.stream().map(String::valueOf).collect(Collectors.toList()));
            Map<String, Object> data = new HashMap<>();
            data.put("title", "试用期考核流程");
            data.put("content", "试用期考核流程content");

            PrdMessageConfigVO configVO = messageConfigService.queryByMessageCode("MC20230208181400");
            messageConfigService.sendMessageConfig(configVO, data, "appoint_people", noticeSource);
            log.info("邮件发送成功");
        } catch (Exception e) {
            log.error("邮件发送出现异常");
            log.error(e.getMessage(), e);
        }

    }

    public void startWorkFlow(PrdProbationExamDO res, Boolean taskFlag) {
        // 启动工作流
        HashMap<String, Object> variables = new HashMap<>();

        // 培训人确认 平台IT管理员（PLATFORM_IT_ADMINISTRATOR）角色成员：宫入匀
        List<Long> glUserIds = prdSystemRoleDAO.queryUserIdByRoleCodes(List.of(RoleEnum.PLATFORM_IT_ADMINISTRATOR.getCode()));
        variables.put("Activity_1mm1x7m", glUserIds);

        // 资源自评
        variables.put("Activity_1ow5lcd", res.getUserId());
        // 直属领导评价
        PrdOrgEmployeeRefDO prdOrgEmployeeRefDO = prdOrgEmployeeDAO.queryByOrgIdAndUserId(res.getBaseBuId(), res.getUserId());
        if (null != prdOrgEmployeeRefDO) {
            variables.put("Activity_1918p7a", prdOrgEmployeeRefDO.getParentId());
        }
        // Bu负责人评价
        PrdOrgOrganizationVO prdOrgOrganizationVO = prdOrgOrganizationService.queryDetailSimpleByOrgId(res.getBaseBuId());
        variables.put("Activity_002ual9", prdOrgOrganizationVO.getManageId());

        String procName = "A42.试用期考核流程(中期)";
        procName = procName + res.getUserName();

        Long procuserId = res.getUserId();
        if (!taskFlag) {
            procuserId = GlobalUtil.getLoginUser().getId();
        }

        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                HrBaseEnum.PROBATION_EXAM.getCode(),
                procName,
                res.getId().toString(),
                variables), procuserId);

        String procInstId = processInfo.getProcInstId();
        ProcInstStatus procInstStatus = processInfo.getProcInstStatus();

        PrdProbationExamPayload payload = new PrdProbationExamPayload();
        payload.setId(res.getId());
        // 流程编号
        payload.setProcInstId(procInstId);
        payload.setProcInstStatus(procInstStatus);
        payload.setName(procName);
        payload.setType(res.getType());
        updateByCondition(payload);
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdProbationExamVO update(PrdProbationExamPayload prdProbationExamPayload) {

        Assert.notNull(prdProbationExamPayload.getId(), "id is null");
        PrdProbationExamVO res = save(prdProbationExamPayload);
        return res;

    }


    @Override
    public PrdProbationExamVO get(Long id) {

        if (null == id) {
            return null;
        }
        PrdProbationExamVO res = prdProbationExamDao.get(id);
        if (null != res) {
            // 直属领导评审评价点评分
            PrdEvaluateVO pPrdEvaluateVO = prdEvaluateService.get(res.getpUserEvalId());
            res.setpPrdEvaluateVO(pPrdEvaluateVO);
            // BU负责人评审评价点评分
            PrdEvaluateVO buPrdEvaluateVO = prdEvaluateService.get(res.getBaseBuEvalId());
            res.setBuPrdEvaluateVO(buPrdEvaluateVO);
        }

        return res;

    }


    @Override
    public PagingVO<PrdProbationExamVO> page(PrdProbationExamQuery prdProbationExamQuery) {

        PagingVO<PrdProbationExamVO> res = prdProbationExamDao.page(prdProbationExamQuery);
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = prdProbationExamDao.del(ids);
        return res;

    }

    @Override
    public List<PrdProbationExamVO> getList(PrdProbationExamQuery prdProbationExamQuery) {

        List<PrdProbationExamVO> res = prdProbationExamDao.getList(prdProbationExamQuery);
        return res;

    }


    /**
     * 数据校验
     *
     * @param prdProbationExamPayload
     */
    private void checkData(PrdProbationExamPayload prdProbationExamPayload) {

        if (null == prdProbationExamPayload.getUserId()) {
            throw new BusinessException("考核人id不能为空");
        }
        if (StringUtils.isBlank(prdProbationExamPayload.getType())) {
            throw new BusinessException("考核类型不能为空");
        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateByCondition(PrdProbationExamPayload prdProbationExamPayload) {
        Assert.notNull(prdProbationExamPayload.getId(), "id不能为空");
        PrdProbationExamVO prdProbationExamVO = get(prdProbationExamPayload.getId());
        if (null == prdProbationExamVO) {
            throw new BusinessException("id有误，未找到数据");
        }
        prdProbationExamPayload.setType(prdProbationExamVO.getType());
        Assert.notEmpty(prdProbationExamPayload.getType(), "type类型不能为空");
        String itemName = "试用期考核-末期";
        if (prdProbationExamPayload.getType().equals(HrBaseEnum.MIDDLE.getCode())) {
            itemName = "试用期考核-中期";
        }

        //  直属领导审批 评价点评分
        if (null != prdProbationExamPayload.getpPrdEvaluatePayload()) {
            PrdEvaluatePayload pPrdEvaluatePayload = prdProbationExamPayload.getpPrdEvaluatePayload();
            pPrdEvaluatePayload.setFromId(prdProbationExamPayload.getId());
            pPrdEvaluatePayload.setItemName(itemName);
            pPrdEvaluatePayload.setState(0);
            PrdEvaluateVO save = prdEvaluateService.save(pPrdEvaluatePayload);
            prdProbationExamPayload.setpUserEvalId(save.getId());

        }
        //  basebu审批 评价点评分
        if (null != prdProbationExamPayload.getBuPrdEvaluatePayload()) {
            PrdEvaluatePayload buPrdEvaluatePayload = prdProbationExamPayload.getBuPrdEvaluatePayload();
            buPrdEvaluatePayload.setFromId(prdProbationExamPayload.getId());
            buPrdEvaluatePayload.setState(0);
            buPrdEvaluatePayload.setItemName(itemName);
            PrdEvaluateVO save = prdEvaluateService.save(buPrdEvaluatePayload);
            prdProbationExamPayload.setBaseBuEvalId(save.getId());
        }
        // 评审结果
        if (StringUtils.isNotBlank(prdProbationExamPayload.getExamRes())) {
            // 按期转正并且是内推
            if (prdProbationExamPayload.getExamRes().equals("2")) {
                // 查询是否内推
                Assert.notNull(prdProbationExamPayload.getUserId(), "userId不能为空");
                Long recommUserId = personResService.getJobInternalRecommUserId(prdProbationExamPayload.getUserId());
//                log.info(recommUserId.toString());
                prdProbationExamPayload.setRecommendFlag(null != recommUserId);
                prdProbationExamPayload.setRecommendUserId(recommUserId);
                // 更新工作流程状态
                SetVariablesPayload setVariablesPayload = new SetVariablesPayload();
                setVariablesPayload.setProcInstId(prdProbationExamVO.getProcInstId());
                HashMap variables = new HashMap<>();
                variables.put("push", null != recommUserId);
                setVariablesPayload.setVariables(variables);
                workflowUtil.setVaribales(setVariablesPayload);

            }

        }

        Long res = prdProbationExamDao.update(prdProbationExamPayload);
        return res;
    }

    @Override
    @Transactional
    public void taskPrdProbationExamMid(String param) {

        //
        LocalDate localDate = LocalDate.now();
        LocalDate localDate3 = localDate.minusMonths(3);
        // 找出这天入职的资源
        List<PrdOrgEmployeeVO> prdOrgEmployeeVOList3 = prdOrgEmployeeService.queryByEnrollDate(localDate3);
        for (PrdOrgEmployeeVO prdOrgEmployeeVO : prdOrgEmployeeVOList3) {

            PrdProbationExamPayload prdProbationExamPayload = new PrdProbationExamPayload();
            prdProbationExamPayload.setUserId(prdOrgEmployeeVO.getUserId());
            prdProbationExamPayload.setUserName(prdOrgEmployeeVO.getPersonName());
            prdProbationExamPayload.setPhone(prdOrgEmployeeVO.getMobile());
            prdProbationExamPayload.setEmail(prdOrgEmployeeVO.getEmail());
            prdProbationExamPayload.setApplyUserId(prdOrgEmployeeVO.getUserId());
            prdProbationExamPayload.setApplyUser(prdOrgEmployeeVO.getPersonName());

            prdProbationExamPayload.setFormalData(prdOrgEmployeeVO.getExtDate2());
            // 试用期开始结束
            prdProbationExamPayload.setProbationStart(prdOrgEmployeeVO.getExtDate6());
            prdProbationExamPayload.setProbationEnd(prdOrgEmployeeVO.getExtDate7());

            List<PrdOrgDataRefVO> prdOrgDataRefVOS = prdOrgEmployeeVO.getDataRefVOS();
            // 未找到默认组织
            if (CollUtil.isEmpty(prdOrgDataRefVOS)) {
                break;
            }
            PrdOrgDataRefVO prdOrgDataRefVO = prdOrgDataRefVOS.get(0);
            prdProbationExamPayload.setBaseBuId(prdOrgDataRefVO.getOrgId());
            prdProbationExamPayload.setpUserId(prdOrgDataRefVO.getParentId());
            prdProbationExamPayload.setpUserName(prdOrgDataRefVO.getParentName());
            prdProbationExamPayload.setType(HrBaseEnum.MIDDLE.getCode());
            prdProbationExamPayload.setTaskFlag(true);
            save(prdProbationExamPayload);

        }


    }

    @Override
    @Transactional
    public void taskPrdProbationExamLate(String param) {
        //
        LocalDate localDate = LocalDate.now();
        LocalDate localDate5 = localDate.minusMonths(5);
        // 找出这天入职的资源
        List<PrdOrgEmployeeVO> prdOrgEmployeeVOList3 = prdOrgEmployeeService.queryByEnrollDate(localDate5);
        for (PrdOrgEmployeeVO prdOrgEmployeeVO : prdOrgEmployeeVOList3) {

            PrdProbationExamPayload prdProbationExamPayload = new PrdProbationExamPayload();
            prdProbationExamPayload.setUserId(prdOrgEmployeeVO.getUserId());
            prdProbationExamPayload.setUserName(prdOrgEmployeeVO.getPersonName());
            prdProbationExamPayload.setPhone(prdOrgEmployeeVO.getMobile());
            prdProbationExamPayload.setEmail(prdOrgEmployeeVO.getEmail());
            prdProbationExamPayload.setApplyUserId(prdOrgEmployeeVO.getUserId());
            prdProbationExamPayload.setApplyUser(prdOrgEmployeeVO.getPersonName());
            // 转正日期
            prdProbationExamPayload.setFormalData(prdOrgEmployeeVO.getExtDate2());
            // 试用期开始结束
            prdProbationExamPayload.setProbationStart(prdOrgEmployeeVO.getExtDate6());
            prdProbationExamPayload.setProbationEnd(prdOrgEmployeeVO.getExtDate7());

            List<PrdOrgDataRefVO> prdOrgDataRefVOS = prdOrgEmployeeVO.getDataRefVOS();
            if (CollUtil.isEmpty(prdOrgDataRefVOS)) {
                break;
            }
            PrdOrgDataRefVO prdOrgDataRefVO = prdOrgDataRefVOS.get(0);
            prdProbationExamPayload.setBaseBuId(prdOrgDataRefVO.getOrgId());
            prdProbationExamPayload.setpUserId(prdOrgDataRefVO.getParentId());
            prdProbationExamPayload.setpUserName(prdOrgDataRefVO.getParentName());
            prdProbationExamPayload.setType(HrBaseEnum.LATE.getCode());
            prdProbationExamPayload.setTaskFlag(true);
            save(prdProbationExamPayload);

        }
    }


}

