package com.elitesland.tw.tw5.server.prd.humanresources.personnel.controller;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PersonProjectExperienceQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonProjectExperienceService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonProjectExperienceVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "项目履历管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/person")
@Slf4j
public class PersonProjectExperienceController {
    private final PersonProjectExperienceService service;
    
    /**
     * 分页条件查询
     *
     * @param query 条件
     * @return result
     */
    @ApiOperation("分页条件查询")
    @GetMapping("/paging")
    public TwOutputUtil<PagingVO<PersonProjectExperienceVO>> queryPaging(PersonProjectExperienceQuery query) {
        PagingVO<PersonProjectExperienceVO> paging = service.queryPaging(query);
        return TwOutputUtil.ok(paging);
    }

}
