package com.elitesland.tw.tw5.server.prd.humanresources.personnel.service;

import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonAccountService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonAccountVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.convert.PersonAccountConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.dao.PersonAccountDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.PersonAccountDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@RequiredArgsConstructor
@Slf4j
public class PersonAccountServiceImpl implements PersonAccountService {

    private final PersonAccountDAO personAccountDAO;

    private final CacheUtil cacheUtil;

    @Override
    public void saveAll(List<PersonAccountVO> personAccountVOList, Long personId) {
        if (personAccountVOList != null) {
            if (personAccountVOList.size() == 0) {
                personAccountDAO.deleteAllByPersonId(personId);
            } else {
                for (PersonAccountVO personAccountVO : personAccountVOList) {
                    if (personAccountVO.getPersonId() == null) {
                        personAccountVO.setPersonId(personId);
                    }
                }
                personAccountDAO.saveAll(PersonAccountConvert.INSTANCE.toDos(personAccountVOList));
            }
        }
    }

    @Override
    public List<PersonAccountVO> findAllByPersonId(Long personId) {
        List<PersonAccountDO> personAccountDOList = personAccountDAO.findAllByPersonId(personId);
        return PersonAccountConvert.INSTANCE.toVos(personAccountDOList);
    }

    @Override
    public void deleteAllByPersonId(Long personId) {
        personAccountDAO.deleteAllByPersonId(personId);
    }

    @Override
    public List<PersonAccountVO> findAllByUserId(Long userId) {
        PrdOrgEmployeeVO employeeVO = cacheUtil.getEmployee(userId);
        Long personId = employeeVO.getPersonId();
        return findAllByPersonId(personId);
    }
}
