package com.elitesland.tw.tw5.server.prd.humanresources.resource.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.ResourcePlanQuery;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectMembersDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsResourcePlanDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsResourcePlanRoleDO;
import com.querydsl.core.QueryResults;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
@RequiredArgsConstructor
public class ResourcePlanQueryDAO {

    private final QPrdOrgEmployeeDO qPrdOrgEmployeeDO = QPrdOrgEmployeeDO.prdOrgEmployeeDO;

    private final QPmsProjectDO qPmsProjectDO = QPmsProjectDO.pmsProjectDO;

    private final QPmsResourcePlanDO qPmsResourcePlanDO = QPmsResourcePlanDO.pmsResourcePlanDO;

    private final QPmsResourcePlanRoleDO qPmsResourcePlanRoleDO = QPmsResourcePlanRoleDO.pmsResourcePlanRoleDO;

    private final QPmsProjectMembersDO qPmsProjectMembersDO = QPmsProjectMembersDO.pmsProjectMembersDO;

    private final QPrdOrgEmployeeRefDO qPrdOrgEmployeeRefDO = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;

    private final JPAQueryFactory jpaQueryFactory;


    public PagingVO<Long> listResIds(ResourcePlanQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qPrdOrgEmployeeDO.userId)
                .from(qPrdOrgEmployeeDO)
                .leftJoin(qPrdOrgEmployeeRefDO).on(qPrdOrgEmployeeDO.userId.longValue().eq(qPrdOrgEmployeeRefDO.userId.longValue()).and(qPrdOrgEmployeeRefDO.isDefault.eq(0)).and(qPrdOrgEmployeeRefDO.deleteFlag.eq(0)));
        if (!ObjectUtils.isEmpty(query.getProjectId())) {
            jpaQuery.leftJoin(qPmsProjectMembersDO).on(qPmsProjectMembersDO.resId.eq(qPrdOrgEmployeeDO.userId))
                    .where(qPmsProjectMembersDO.projId.eq(query.getProjectId()));
        }
        if (!ObjectUtils.isEmpty(query.getParentId())) {
            jpaQuery.where(qPrdOrgEmployeeRefDO.parentId.eq(query.getParentId()));
        }
        if (!ObjectUtils.isEmpty(query.getResManageId())) {
            jpaQuery.where(qPrdOrgEmployeeDO.resManagerId.eq(query.getResManageId()));
        }
        if (!ObjectUtils.isEmpty(query.getBaseBu())) {
            jpaQuery.where(qPrdOrgEmployeeDO.extString5.eq(query.getBaseBu()));
        }
        if (!ObjectUtils.isEmpty(query.getOrgId())) {
            jpaQuery.where(qPrdOrgEmployeeRefDO.orgId.eq(query.getOrgId()));
        }
        if (!ObjectUtils.isEmpty(query.getResType1())) {
            jpaQuery.where(qPrdOrgEmployeeDO.extString6.eq(query.getResType1()));
        }
        if (!ObjectUtils.isEmpty(query.getResType2())) {
            jpaQuery.where(qPrdOrgEmployeeDO.extString9.eq(query.getResType2()));
        }
        if (!ObjectUtils.isEmpty(query.getName())) {
            jpaQuery.where(qPrdOrgEmployeeDO.employeeName.like(SqlUtil.toSqlLikeString(query.getName())));
        }
        jpaQuery.where(qPrdOrgEmployeeDO.resourceStatus.in("3", "4", "5"));
        QueryResults<Long> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<Long>builder().records(result.getResults()).total(result.getTotal()).build();
    }
//        leftJoin(qPrdOrgEmployeeDO).on(qPrdOrgEmployeeDO.userId.eq(jpaQueryFactory.select(qPmsResourcePlanRoleDO.resId)
//                        .from(qPmsProjectDO)
//                        .leftJoin(qPmsResourcePlanDO).on(qPmsResourcePlanDO.objId.eq(qPmsProjectDO.id))
//            .leftJoin(qPmsResourcePlanRoleDO).on(qPmsResourcePlanRoleDO.planId.eq(qPmsResourcePlanDO.id))
//            .where(qPmsResourcePlanRoleDO.id.eq(query.getProjectId()))))
}
