package com.elitesland.tw.tw5.server.inv.controller;


import com.elitesland.tw.tw5.api.prd.inv.payload.InvInvoiceAttachedPayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceAttachedQuery;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceAttachedService;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceAttachedVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 发票扩展表
 *
 * @author zoey
 * @date 2023-12-06
 */
@Api(tags = "发票扩展表")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/invInvoiceAttached")
@Slf4j
public class InvInvoiceAttachedController {

private final InvInvoiceAttachedService invInvoiceAttachedService;

    /**
     * 发票扩展表-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("发票扩展表-新增")
    public TwOutputUtil<InvInvoiceAttachedVO> insert(@RequestBody InvInvoiceAttachedPayload payload){
         return TwOutputUtil.ok(invInvoiceAttachedService.insert(payload));
    }

    /**
     * 发票扩展表-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("发票扩展表-更新")
    public TwOutputUtil<InvInvoiceAttachedVO> update(@RequestBody InvInvoiceAttachedPayload payload){
        return TwOutputUtil.ok(invInvoiceAttachedService.update(payload));
    }

    /**
     * 发票扩展表-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("发票扩展表-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody InvInvoiceAttachedPayload payload){
        return TwOutputUtil.ok(invInvoiceAttachedService.updateByKeyDynamic(payload));
    }

    /**
     * 发票扩展表-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("发票扩展表-主键查询")
    public TwOutputUtil<InvInvoiceAttachedVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(invInvoiceAttachedService.queryByKey(key));
    }

    /**
     * 发票扩展表-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("发票扩展表-分页")
    public TwOutputUtil<PagingVO<InvInvoiceAttachedVO>> paging(InvInvoiceAttachedQuery query) {
        return TwOutputUtil.ok(invInvoiceAttachedService.queryPaging(query));
    }

    /**
     * 发票扩展表-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("发票扩展表-查询列表")
    public TwOutputUtil<List<InvInvoiceAttachedVO>> queryList(InvInvoiceAttachedQuery query) {
        return TwOutputUtil.ok(invInvoiceAttachedService.queryListDynamic(query));
    }

    /**
     * 发票扩展表-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("发票扩展表-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         invInvoiceAttachedService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

