package com.elitesland.tw.tw5.server.prd.inv.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.math.BigDecimal;

/**
 * 发票扩展表
 *
 * @author zoey
 * @date 2023-12-06
 */
@Entity
@Table(name = "inv_invoice_attached", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "inv_invoice_attached", comment = "发票扩展表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class InvInvoiceAttachedDO extends BaseModel implements Serializable  {
    /** 发票ID */
    @Comment("发票ID")
    @Column()
    private Long invId;
    /** 百望系统发票ID */
    @Comment("百望系统发票ID")
    @Column()
    private Long baiwangInvId;
    /** 百望系统发票扩展信息ID */
    @Comment("百望系统发票扩展信息ID")
    @Column()
    private Long baiwangId;
    /** 承运人名称:承运人名称 */
    @Comment("承运人名称:承运人名称")
    @Column()
    private String carrierName;
    /** 承运人识别号:承运人识别号 */
    @Comment("承运人识别号:承运人识别号")
    @Column()
    private String carrierTaxNo;
    /** 受票方名称:受票方名称 */
    @Comment("受票方名称:受票方名称")
    @Column()
    private String draweeName;
    /** 受票方识别号:受票方识别号 */
    @Comment("受票方识别号:受票方识别号")
    @Column()
    private String draweeTaxNo;
    /** 运输货物信息:运输货物信息 */
    @Comment("运输货物信息:运输货物信息")
    @Column()
    private String cargoInformation;
    /** 起运地、经由、到达地:起运地、经由、到达地 */
    @Comment("起运地、经由、到达地:起运地、经由、到达地")
    @Column()
    private String transportRoute;
    /** 车船吨位:车船吨位 */
    @Comment("车船吨位:车船吨位")
    @Column()
    private BigDecimal tonnage;
    /** 主管税务机关:主管税务机关 */
    @Comment("主管税务机关:主管税务机关")
    @Column()
    private String taxAuthorityNo;
    /** 主管税务名称:主管税务名称 */
    @Comment("主管税务名称:主管税务名称")
    @Column()
    private String taxAuthorityName;
    /** 身份证号码 组织机构代码:身份证号码/组织机构代码 */
    @Comment("身份证号码 组织机构代码:身份证号码/组织机构代码")
    @Column()
    private String idCardNo;
    /** 车辆类型:车辆类型 */
    @Comment("车辆类型:车辆类型")
    @Column()
    private String vehicleType;
    /** 车辆识别代号/车架号码:车辆识别代号/车架号码 */
    @Comment("车辆识别代号/车架号码:车辆识别代号/车架号码")
    @Column()
    private String vehicleNo;
    /** 厂牌型号:厂牌型号 */
    @Comment("厂牌型号:厂牌型号")
    @Column()
    private String brandModel;
    /** 产地:产地 */
    @Comment("产地:产地")
    @Column()
    private String originPlace;
    /** 合格证号:合格证号 */
    @Comment("合格证号:合格证号")
    @Column()
    private String certiticateNo;
    /** 商检单号:商检单号 */
    @Comment("商检单号:商检单号")
    @Column()
    private String inspectionListNo;
    /** 发动机号:发动机号 */
    @Comment("发动机号:发动机号")
    @Column()
    private String engineNo;
    /** 进口证明书号:进口证明书号 */
    @Comment("进口证明书号:进口证明书号")
    @Column()
    private String importCertificateNo;
    /** 销货单位名称:销货单位名称（销方名称） */
    @Comment("销货单位名称:销货单位名称（销方名称）")
    @Column()
    private String sellerName;
    /** 销方电话:销方电话 */
    @Comment("销方电话:销方电话")
    @Column()
    private String phoneNo;
    /** 账号:账号 */
    @Comment("账号:账号")
    @Column()
    private String account;
    /** 销方地址:销方地址 */
    @Comment("销方地址:销方地址")
    @Column()
    private String address;
    /** 银行:银行 */
    @Comment("银行:银行")
    @Column()
    private String bank;
    /** 税率:税率 */
    @Comment("税率:税率")
    @Column()
    private BigDecimal goodsTaxRate;
    /** 限乘人数:限乘人数 */
    @Comment("限乘人数:限乘人数")
    @Column()
    private Integer passengersLimited;
    /** 通行费标志:通行费标志 06-可抵扣通行费，07-不可抵扣通行费 */
    @Comment("通行费标志:通行费标志 06-可抵扣通行费，07-不可抵扣通行费")
    @Column()
    private String tollSign;
    /** 经营，拍卖单位地址:经营，拍卖单位地址 */
    @Comment("经营，拍卖单位地址:经营，拍卖单位地址")
    @Column()
    private String auctionAddress;
    /** 经营，拍卖单位:经营，拍卖单位 */
    @Comment("经营，拍卖单位:经营，拍卖单位")
    @Column()
    private String auctionName;
    /** 经营，拍卖单位电话:经营，拍卖单位电话 */
    @Comment("经营，拍卖单位电话:经营，拍卖单位电话")
    @Column()
    private String auctionPhone;
    /** 经营，拍卖单位纳税人识别号:经营，拍卖单位纳税人识别号 */
    @Comment("经营，拍卖单位纳税人识别号:经营，拍卖单位纳税人识别号")
    @Column()
    private String auctionTaxNo;
    /** 开户银行及账号:开户银行及账号 */
    @Comment("开户银行及账号:开户银行及账号")
    @Column()
    private String auctionBank;
    /** 买方电话:买方电话 */
    @Comment("买方电话:买方电话")
    @Column()
    private String purchaserPhone;
    /** 登记证号:登记证号 */
    @Comment("登记证号:登记证号")
    @Column()
    private String registrationNumber;
    /** 二手车市场地址:二手车市场地址 */
    @Comment("二手车市场地址:二手车市场地址")
    @Column()
    private String usedCarAddress;
    /** 二手车市场:二手车市场 */
    @Comment("二手车市场:二手车市场")
    @Column()
    private String usedCarName;
    /** 二手车市场电话:二手车市场电话 */
    @Comment("二手车市场电话:二手车市场电话")
    @Column()
    private String usedCarPhone;
    /** 二手车市场纳税人识别号:二手车市场纳税人识别号 */
    @Comment("二手车市场纳税人识别号:二手车市场纳税人识别号")
    @Column()
    private String usedCarTaxNo;
    /** 二手车市场开户银行及账号:二手车市场开户银行及账号 */
    @Comment("二手车市场开户银行及账号:二手车市场开户银行及账号")
    @Column()
    private String usedCarBank;
    /** 车牌照号:车牌照号 */
    @Comment("车牌照号:车牌照号")
    @Column()
    private String carNumber;
    /** 转入地车辆车管所名称:转入地车辆车管所名称 */
    @Comment("转入地车辆车管所名称:转入地车辆车管所名称")
    @Column()
    private String vehiclePlaceName;
    /** 是否删除:是否删除，0-否，1-是 */
    @Comment("是否删除:是否删除，0-否，1-是")
    @Column()
    private Integer isDel;

    public void copy(InvInvoiceAttachedDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
