package com.elitesland.tw.tw5.server.prd.my.constant;

import lombok.Getter;


/**
 * 任务状态枚举
 *
 * @author duwh
 * @date 2023/01/10
 */
public enum TaskStatusEnum {

    CREATE("CREATE", "新建"),
    DISPATCH("DISPATCH", "派发中"),
    ACTIVE("IN PROCESS", "处理中"),
    PENDING("PENDING", "暂挂"),
    CLOSE("CLOSED", "关闭");

    /**
     * 状态
     */
    @Getter
    private final String code;

    /**
     * 描述
     */
    @Getter
    private final String desc;

    TaskStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}
