package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.AbnormalWorkApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.AbnormalWorkApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.service.AbnormalWorkApplyService;
import com.elitesland.tw.tw5.api.prd.my.vo.AbnormalWorkApplyVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 远程办公申请
 *
 * @author carl
 * @date 2024-04-19
 */
@Api(tags = "远程办公申请")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/abnormalWorkApply")
@Slf4j
public class AbnormalWorkApplyController {

    private final AbnormalWorkApplyService abnormalWorkApplyService;

    /**
     * 远程办公申请-新增或修改
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("远程办公申请-新增或修改")
    public TwOutputUtil<AbnormalWorkApplyVO> insertOrUpdate(@RequestBody AbnormalWorkApplyPayload payload) {
        return TwOutputUtil.ok(abnormalWorkApplyService.insertOrUpdate(payload));
    }
//
//    /**
//     * 远程办公申请-更新
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping
//    @ApiOperation("远程办公申请-更新")
//    public TwOutputUtil<AbnormalWorkApplyVO> update(@RequestBody AbnormalWorkApplyPayload payload){
//        return TwOutputUtil.ok(abnormalWorkApplyService.update(payload));
//    }

    /**
     * 远程办公申请-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("远程办公申请-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody AbnormalWorkApplyPayload payload) {
        return TwOutputUtil.ok(abnormalWorkApplyService.updateByKeyDynamic(payload));
    }

    /**
     * 远程办公申请-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("远程办公申请-主键查询")
    public TwOutputUtil<AbnormalWorkApplyVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(abnormalWorkApplyService.queryByKey(key));
    }

    /**
     * 远程办公申请-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("远程办公申请-分页")
    public TwOutputUtil<PagingVO<AbnormalWorkApplyVO>> paging(AbnormalWorkApplyQuery query) {
        return TwOutputUtil.ok(abnormalWorkApplyService.queryPaging(query));
    }

    /**
     * 远程办公申请-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("远程办公申请-查询列表")
    public TwOutputUtil<List<AbnormalWorkApplyVO>> queryList(AbnormalWorkApplyQuery query) {
        return TwOutputUtil.ok(abnormalWorkApplyService.queryListDynamic(query));
    }

    /**
     * 远程办公申请-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("远程办公申请-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        abnormalWorkApplyService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

