package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitesland.tw.tw5.server.prd.my.repo.AbnormalWorkApplyConfigRepo;
import com.elitesland.tw.tw5.server.prd.my.dao.AbnormalWorkApplyConfigDAO;
import com.elitesland.tw.tw5.server.prd.my.convert.AbnormalWorkApplyConfigConvert;
import com.elitesland.tw.tw5.api.prd.my.service.AbnormalWorkApplyConfigService;
import com.elitesland.tw.tw5.api.prd.my.payload.AbnormalWorkApplyConfigPayload;
import com.elitesland.tw.tw5.server.prd.my.entity.AbnormalWorkApplyConfigDO;
import com.elitesland.tw.tw5.api.prd.my.vo.AbnormalWorkApplyConfigVO;
import com.elitesland.tw.tw5.api.prd.my.query.AbnormalWorkApplyConfigQuery;
import com.elitesland.tw.tw5.server.prd.my.convert.AbnormalWorkApplyConfigConvert;
import org.springframework.stereotype.Service;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 远程办公审批配置
 *
 * @author wangly
 * @date 2024-06-13
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class AbnormalWorkApplyConfigServiceImpl extends BaseServiceImpl implements AbnormalWorkApplyConfigService {

    private final AbnormalWorkApplyConfigRepo abnormalWorkApplyConfigRepo;
    private final AbnormalWorkApplyConfigDAO abnormalWorkApplyConfigDAO;

    @Override
    public PagingVO<AbnormalWorkApplyConfigVO> queryPaging(AbnormalWorkApplyConfigQuery query){
        return abnormalWorkApplyConfigDAO.queryPaging(query);
    }

    @Override
    public List<AbnormalWorkApplyConfigVO> queryListDynamic(AbnormalWorkApplyConfigQuery query){
        return abnormalWorkApplyConfigDAO.queryListDynamic(query);
    }

    @Override
    public AbnormalWorkApplyConfigVO queryByKey(Long key) {
        AbnormalWorkApplyConfigDO entity = abnormalWorkApplyConfigRepo.findById(key).orElseGet(AbnormalWorkApplyConfigDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AbnormalWorkApplyConfigVO vo = AbnormalWorkApplyConfigConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AbnormalWorkApplyConfigVO insert(AbnormalWorkApplyConfigPayload payload) {
        AbnormalWorkApplyConfigDO entityDo = AbnormalWorkApplyConfigConvert.INSTANCE.toDo(payload);
        return AbnormalWorkApplyConfigConvert.INSTANCE.toVo(abnormalWorkApplyConfigRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AbnormalWorkApplyConfigVO update(AbnormalWorkApplyConfigPayload payload) {
        AbnormalWorkApplyConfigDO entity = abnormalWorkApplyConfigRepo.findById(payload.getId()).orElseGet(AbnormalWorkApplyConfigDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AbnormalWorkApplyConfigDO entityDo = AbnormalWorkApplyConfigConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return AbnormalWorkApplyConfigConvert.INSTANCE.toVo(abnormalWorkApplyConfigRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(AbnormalWorkApplyConfigPayload payload) {
        AbnormalWorkApplyConfigDO entity = abnormalWorkApplyConfigRepo.findById(payload.getId()).orElseGet(AbnormalWorkApplyConfigDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = abnormalWorkApplyConfigDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            abnormalWorkApplyConfigDAO.deleteSoft(keys);
        }
    }

}
