package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.*;
import com.elitesland.tw.tw5.api.prd.my.query.TAttendanceNormalQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TAttendanceOtherQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TAttendanceRuleQuery;
import com.elitesland.tw.tw5.api.prd.my.service.*;
import com.elitesland.tw.tw5.api.prd.my.vo.*;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.server.common.scheduling.TimeUtil;
import com.elitesland.tw.tw5.server.common.util.GeodesyUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.my.convert.TAttendanceNormalConvert;
import com.elitesland.tw.tw5.server.prd.my.convert.TAttendanceOtherConvert;
import com.elitesland.tw.tw5.server.prd.my.convert.TAttendanceRecordConvert;
import com.elitesland.tw.tw5.server.prd.my.convert.TAttendanceRuleConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.TAttendanceNormalDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.TAttendanceNormalTimeDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.TAttendanceRuleDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.TAttendanceNormalDO;
import com.elitesland.tw.tw5.server.prd.my.entity.TAttendanceRuleDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TAttendanceNormalDateRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TAttendanceRuleRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
@Slf4j
public class TAttendanceRuleServiceImpl extends BaseServiceImpl implements TAttendanceRuleService {

    private final TAttendanceRuleRepo tAttendanceRuleRepo;
    private final TAttendanceRuleDAO tAttendanceRuleDAO;

    private final TAttendanceNormalDateRepo tAttendanceNormalDateRepo;

    private final VacationService vacationService;
    private final TAttendanceNormalDateSpecialService tAttendanceNormalDateSpecialService;

    private final TAttendanceNormalTimeDAO tAttendanceNormalTimeDAO;

    private final TAttendanceOtherService attendanceOtherService;

    private final TAttendanceNormalService attendanceNormalService;

    private final TAttendanceRecordService attendanceRecordService;

    private final TAttendanceNormalDAO attendanceNormalDAO;

    private final UdcUtil udcUtil;

    private final CacheUtil cacheUtil;
    private final PrdOrgEmployeeService prdOrgEmployeeService;

    private final TAttendanceRemarkService tAttendanceRemarkService;

    private final GeodesyUtil geodesyUtil;


    @Override
    public PagingVO<TAttendanceRuleVO> queryPaging(TAttendanceRuleQuery query) {
        return tAttendanceRuleDAO.queryPaging(query);
    }

    @Override
    public List<TAttendanceRuleVO> queryListDynamic(TAttendanceRuleQuery query) {
        return tAttendanceRuleDAO.queryListDynamic(query);
    }

    @Override
    public TAttendanceRuleVO queryByKey(Long key) {
        TAttendanceRuleDO entity = tAttendanceRuleRepo.findById(key).orElseGet(TAttendanceRuleDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TAttendanceRuleVO vo = TAttendanceRuleConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TAttendanceRuleVO insert(TAttendanceRulePayload payload) {
        TAttendanceRuleDO entityDo = TAttendanceRuleConvert.INSTANCE.toDo(payload);
        return TAttendanceRuleConvert.INSTANCE.toVo(tAttendanceRuleRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TAttendanceRuleVO update(TAttendanceRulePayload payload) {
        TAttendanceRuleDO entity = tAttendanceRuleRepo.findById(payload.getId()).orElseGet(TAttendanceRuleDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TAttendanceRuleDO entityDo = TAttendanceRuleConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TAttendanceRuleConvert.INSTANCE.toVo(tAttendanceRuleRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(TAttendanceRulePayload payload) {
        TAttendanceRuleDO entity = tAttendanceRuleRepo.findById(payload.getId()).orElseGet(TAttendanceRuleDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = tAttendanceRuleDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            tAttendanceRuleDAO.deleteSoft(keys);
        }
    }

    @Override
    public List<MobAttendanceRuleVO> getAttendanceRule(long resId) {

        List<Long> attendanceRuleIds = tAttendanceRuleDAO.queryRulesByResId(resId);
        List<MobAttendanceRuleVO> mobs = tAttendanceRuleDAO.getAttendanceRuleByResId(attendanceRuleIds);
        for (MobAttendanceRuleVO mobAttendanceRuleVO : mobs) {
            mobAttendanceRuleVO.setAttendanceTimeStart(tAttendanceRuleDAO.minAttendanceTimeStart(mobAttendanceRuleVO.getAttendanceRuleId()));
            mobAttendanceRuleVO.setAttendanceTimeEnd(tAttendanceRuleDAO.maxAttendanceTimeEnd(mobAttendanceRuleVO.getAttendanceRuleId()));
        }
        String str = tAttendanceRuleDAO.cmsContents();
        String otherStr = tAttendanceRuleDAO.cmsOtherContents();
        for (MobAttendanceRuleVO info : mobs) {
            List<MobttendanceSiteVO> mobttendanceSiteVOList = tAttendanceRuleDAO.getAttendanceRuleSite(info.getAttendanceRuleId());
            info.setSites(mobttendanceSiteVOList);
            if (str != null && !ObjectUtils.isEmpty(str)) {
                info.setCmsContents(str);
            }
            if (otherStr != null && !ObjectUtils.isEmpty(otherStr)) {
                info.setCmsOtherContents(otherStr);
            }
        }
        return isAttendance(mobs);
    }

    @Override
    public List<TAttendanceRuleVO> getAttendanceRule() {
        TAttendanceRuleQuery query = new TAttendanceRuleQuery();
        List<TAttendanceRuleVO> tAttendanceRuleVOS = tAttendanceRuleDAO.queryListDynamic(query);
        return tAttendanceRuleVOS;
    }


    @Override
    public List<MobAttendanceRuleVO> isAttendance(List<MobAttendanceRuleVO> list) {
        for (MobAttendanceRuleVO info : list) {
            LocalDate today = LocalDate.now();
            //获取今天是否是规定上班日期(假期表)
            double i = vacationService.selectWorkHoursByDate(today, today);

            //获取今日是否是特殊打卡(特殊打卡)
            Long t = tAttendanceNormalDateSpecialService.isAttendAnceSpecial(today);

            //根据打卡规则来判断今日是否打卡
            String[][] strArray = {{"MONDAY", "ATTENDANCE_DATE_MON"}, {"TUESDAY", "ATTENDANCE_DATE_TUE"}, {"WEDNESDAY", "ATTENDANCE_DATE_WED"}, {"THURSDAY", "ATTENDANCE_DATE_THU"}, {"FRIDAY", "ATTENDANCE_DATE_FRI"}, {"SATURDAY", "ATTENDANCE_DATE_SAT"}, {"SUNDAY", "ATTENDANCE_DATE_SUN"}};
            LocalDate currentDate = LocalDate.now();
            String k = String.valueOf(currentDate.getDayOfWeek());
            //获取行数
            for (int o = 0; o < strArray.length; o++) {
                if (k.equals(strArray[o][0])) {
                    k = strArray[o][1];
                    break;
                }
            }
            Long ruleId = info.getAttendanceRuleId();
            int n = tAttendanceNormalDateRepo.isAttendAnceRule(ruleId, k);
            //先根据假期设置表来判断今天是否需要打卡
            if (i > 0) {
                info.setTodayAttendance(true);
                //需要打卡 那就根据今天是星期几来获取上下班时间
                info = selectTimeView(info, k);
            }
            //如果假期表没有值 就根据特殊打卡来判断
            if (i <= 0) {
                //特殊打卡和规则 都需要今天打卡
                if (t > 0) {
                    //如果是特殊打卡获取特殊打卡ID
                    Long specilId = tAttendanceNormalDateSpecialService.selectAttendAnceSpectalId(info.getAttendanceRuleId(), today);
                    if (specilId != null && specilId.intValue() > 0) {
                        //获取特殊打卡日期的上下班
                        TwAttendAnceSpecilDate specilDate = tAttendanceNormalTimeDAO.selectAttendAnceSpectalDate(info.getAttendanceRuleId(), specilId);
                        //然后将特殊上下班时间赋值给前端
                        info.setAttendanceTimeStart(specilDate.getAttendanceTimeStart());
                        info.setAttendanceTimeEnd(specilDate.getAttendanceTimeEnd());
                    }
                    info.setTodayAttendance(true);
                } else {
                    info.setTodayAttendance(false);
                }
            }
            //今天都不需要打卡
            if (i == 0 && t == 0) {
                info.setTodayAttendance(false);
            }
        }
        return list;
//        return null;
    }

    public MobAttendanceRuleVO selectTimeView(MobAttendanceRuleVO info, String k) {
        TAttendanceTimeVO timeView = tAttendanceNormalDateRepo.selectPunchLimitTime(info.getAttendanceRuleId(), k);
        if (timeView != null) {
            if (timeView.getAttendanceTimeStart() != null) {
                info.setAttendanceTimeStart(timeView.getAttendanceTimeStart());
            }
            if (timeView.getAttendanceTimeEnd() != null) {
                info.setAttendanceTimeEnd(timeView.getAttendanceTimeEnd());
            }
            if (timeView.getPunchLimitStartTime() != null) {
                info.setPunchLimitStartTime(timeView.getPunchLimitStartTime());
            }
            if (timeView.getPunchLimitEndTime() != null) {
                info.setPunchLimitEndTime(timeView.getPunchLimitEndTime());
            }
        }
        return info;
    }


    @Override
    @Transactional
    public int resAttendanceInfo(MobAttendanceVO payload) {
        LocalDate attendanceDate = LocalDate.now();
        SimpleDateFormat sdf = new java.text.SimpleDateFormat("HH:mm");
        String currentTime = sdf.format(new Date());
        //获取打卡规则的特殊时间 上下班的打卡范围 允许上下班的迟到和早退范围
        MobAttendanceVO attendanceInfo = new MobAttendanceVO();
        if (!ObjectUtils.isEmpty(payload.getAttendanceRuleId())) {
            attendanceInfo = tAttendanceRuleDAO.selectAttTime(payload.getAttendanceRuleId());
        }

        if (!ObjectUtils.isEmpty(attendanceInfo)) {
            if (attendanceInfo.getPunchLimitStartTime() != null) {
                payload.setPunchLimitStartTime(attendanceInfo.getPunchLimitStartTime());
            }
            if (attendanceInfo.getPunchLimitEndTime() != null) {
                payload.setPunchLimitEndTime(attendanceInfo.getPunchLimitEndTime());
            }
            if (attendanceInfo.getPunchLimitStartSecondTime() != null) {
                payload.setPunchLimitStartSecondTime(attendanceInfo.getPunchLimitStartSecondTime());
            }
            if (attendanceInfo.getPunchLimitEndSecondTime() != null) {
                payload.setPunchLimitEndSecondTime(attendanceInfo.getPunchLimitEndSecondTime());
            }

            DateTimeFormatter df = DateTimeFormatter.ofPattern("HH:mm");
            if (attendanceInfo.getAllowLateTimeNum() > 0) {
                LocalTime time = LocalTime.parse(payload.getAttendanceTimeStart(), df);
                time = time.plusMinutes(attendanceInfo.getAllowLateTimeNum());
                payload.setAttendanceTimeStart(time.toString());
            }
            if (attendanceInfo.getAllowLeaveTimeNum() > 0) {
                LocalTime time = LocalTime.parse(payload.getAttendanceTimeEnd(), df);
                time = time.plusMinutes(-attendanceInfo.getAllowLeaveTimeNum());
                payload.setAttendanceTimeEnd(time.toString());
            }
            payload.setAllowLateTimeNum(attendanceInfo.getAllowLateTimeNum());
            payload.setAllowLeaveTimeNum(attendanceInfo.getAllowLeaveTimeNum());
        }

        //根据上下班的弹性时间来判断
        //打卡数据
        if (payload.getAttendanceRuleId() == null) {
            //其他打卡
//            TAttendanceOtherDO attendanceOther = new TAttendanceOtherDO();
            TAttendanceOtherPayload attendanceOther = TAttendanceOtherConvert.INSTANCE.mobAttendanceToPayload(payload);
            attendanceOther.setAttendanceDate(LocalDate.now());
            attendanceOther.setAttendanceTimeStart(currentTime);
            attendanceOther.setAttendanceRemark(payload.getSpecialReason());
            attendanceOtherService.insert(attendanceOther);
        } else {
            //上下班打卡
//            TAttendanceNormalPayload attendanceNormal = new TAttendanceNormalPayload();
            TAttendanceNormalPayload attendanceNormal = TAttendanceNormalConvert.INSTANCE.mobAttendanceToPayload(payload);
            String attendanceLocation = payload.getAttendanceLocation();
            if (StringUtils.hasText(attendanceLocation)) {
                String cityFromAddress = getCityFromAddress(attendanceLocation);
                attendanceNormal.setAttendanceCity(cityFromAddress);
            }
//            String attendanceSiteLatitude = payload.getAttendanceSiteLatitude();
//            String attendanceSiteLongitude = payload.getAttendanceSiteLongitude();
//            // 中心点坐标 规则： 经度和纬度用","分割，经度在前，纬度在后，经纬度小数点后不得超过6位
//            if (payload.getAttendanceSiteLatitude() != null && payload.getAttendanceSiteLongitude() != null) {
//                String cityByLocation = geodesyUtil.getCityByLocation(attendanceSiteLongitude + "," + attendanceSiteLatitude);
//                attendanceNormal.setAttendanceCity(cityByLocation);
//            }
            attendanceNormal.setAttendanceDate(LocalDate.now());
            if (payload.getOffWork()) {//下班打卡
                attendanceNormal.setAttendanceTimeEnd(currentTime);
            } else {
                attendanceNormal.setAttendanceTimeStart(currentTime);
                attendanceNormal.setAttendanceTimeEnd(null);
            }
            List<Long> attendanceIds = attendanceNormalService.findResAttendanceLog(payload.getAttendanceResId(), attendanceDate);
            //正常打了上班卡
            if ((attendanceIds == null || attendanceIds.size() == 0) && !payload.getOffWork()) {
                TAttendanceNormalVO attendanceNormalVO = attendanceNormalService.insert(attendanceNormal);
                payload.setAttendanceNormalId(attendanceNormalVO.getId());
            }
            //正常下班  或者更新下班打卡信息
            if (attendanceIds.size() > 0 && payload.getOffWork()) {
                Long attendanceId = attendanceIds.get(0);
                attendanceNormal.setId(attendanceId);
                if (payload.getOffWork()) {  //下班打卡
                    String startTime = attendanceNormalService.findStartTime(attendanceNormal.getId());
                    attendanceNormal.setAttendanceTimeStart(startTime);
                }
                String status = attendanceNormalService.findResAttendanceStatus(attendanceNormal.getId());
                String result = attendanceNormalService.findResAttendanceResult(attendanceNormal.getId());

                //第一次下班早退 后面打卡正常
                if ("LEAVE_EARLY".equals(status) && "NORMAL".equals(attendanceNormal.getAttendanceResultDetail())) {
                    attendanceNormal.setAttendanceResultDetail("NORMAL");
                    attendanceNormal.setAttendanceResult("YES");
                }
                //迟到且早退的判断
                if ("BE_LATE".equals(status) && "LEAVE_EARLY".equals(attendanceNormal.getAttendanceResultDetail())) {
                    attendanceNormal.setAttendanceResultDetail("BELATE_LEAVEEARLY");
                    if ("NO".equals(result)) {
                        attendanceNormal.setAttendanceResult(result);
                    }
                } else if ("BE_LATE".equals(status)) {  //迟到的判断
                    attendanceNormal.setAttendanceResultDetail(status);
                    if ("NO".equals(result)) {
                        attendanceNormal.setAttendanceResult(result);
                    }
                }

                //早退且缺卡的判断
                if ("LEAVE_MISSINGCARD".equals(status) && "LEAVE_EARLY".equals(attendanceNormal.getAttendanceResultDetail())) {
                    attendanceNormal.setAttendanceResultDetail("LEAVE_MISSINGCARD");
                    if ("NO".equals(result)) {
                        attendanceNormal.setAttendanceResult(result);
                    }
                }

                if ("LEAVE_MISSINGCARD".equals(status) && "NORMAL".equals(attendanceNormal.getAttendanceResultDetail())) {
                    attendanceNormal.setAttendanceResultDetail("MISSING_CARD");
                    if ("NO".equals(result)) {
                        attendanceNormal.setAttendanceResult(result);
                    }
                }

                //缺卡
                if ("MISSING_CARD".equals(status)) {
                    attendanceNormal.setAttendanceResultDetail(status);
                    if ("NO".equals(result)) {
                        attendanceNormal.setAttendanceResult(result);
                    }
                }
                attendanceNormalService.update(attendanceNormal);
            }
            //没有打上班卡 然后就打下班卡
            if ((attendanceIds == null || attendanceIds.size() == 0) && payload.getOffWork()) {
                attendanceNormal.setAttendanceTimeStart(null);
                //下班早退 还没有上班卡 就定义为 早退且缺卡
                if ("LEAVE_EARLY".equals(attendanceNormal.getAttendanceResultDetail())) {
                    attendanceNormal.setAttendanceResultDetail("LEAVE_MISSINGCARD");
                }
                //上班没打卡 下班正常 就定义为缺卡
                if ("NORMAL".equals(attendanceNormal.getAttendanceResultDetail())) {
                    attendanceNormal.setAttendanceResultDetail("MISSING_CARD");
                }
                attendanceNormal.setAttendanceResult("NO");
                TAttendanceNormalVO attendanceNormalVO = attendanceNormalService.insert(attendanceNormal);
                payload.setAttendanceNormalId(attendanceNormalVO.getId());
            }
        }

        //记录打卡明细记录
        TAttendanceRecordPayload attendanceRecord = TAttendanceRecordConvert.INSTANCE.mobAttendanceToPayload(payload);
        attendanceRecord.setAttendanceDate(attendanceDate);
        if (payload.getOffWork() != null && payload.getOffWork()) {//下班打卡时
            //明细表里的上班时间设置为空
            attendanceRecord.setAttendanceTimeStart(null);
            attendanceRecord.setAttendanceTimeEnd(currentTime);
        } else {  //上班打卡时 明细表里的下班时间设置为空
            attendanceRecord.setAttendanceTimeStart(currentTime);
            attendanceRecord.setAttendanceTimeEnd(null);
        }
        attendanceRecordService.insert(attendanceRecord);
        return 1;

    }


    private String getCityFromAddress(String address) {
        String city = "";
        String[] addressParts = address.split("[省,自治区,市,区,县]");
        for (String part : addressParts) {
            if (part.endsWith("市")) {
                city = part + "市";
                break;
            }
        }
        return city;
    }

    @Override
    public List<MobAttendanceLogVO> resAttendanceLog(long resId, LocalDate attendanceDateStart, LocalDate attendanceDateEnd) {

        List<ResAttendanceOtherVO> attendanceOtherList = attendanceOtherService.getAttendanceResOther(resId, attendanceDateStart, attendanceDateEnd);
        List<MobAttendanceLogVO> mobAttendanceLogs = attendanceNormalService.getResAttendanceLog(resId, attendanceDateStart, attendanceDateEnd);
        if (ObjectUtils.isEmpty(mobAttendanceLogs) && ObjectUtils.isEmpty(attendanceOtherList)) {
            return null;
        }
        for (MobAttendanceLogVO mobAttendanceLogVO : mobAttendanceLogs) {
            TAttendanceNormalVO attendanceNormalVO = attendanceNormalDAO.getAttendanceNormal(mobAttendanceLogVO.getId());
            mobAttendanceLogVO.setNormalViews(attendanceNormalVO);
        }

        Map<LocalDate, List<MobAttendanceLogVO>> attendanceLogMap = mobAttendanceLogs.stream()
                .collect(Collectors.groupingBy(MobAttendanceLogVO::getAttendanceDate));

        Map<LocalDate, List<ResAttendanceOtherVO>> attendanceLogOtherMap = attendanceOtherList.stream()
                .collect(Collectors.groupingBy(ResAttendanceOtherVO::getAttendanceDate));

        List<MobAttendanceLogVO> resAttendanceLogList = new ArrayList<>();

        String timeStr = TimeUtil.dateToYmd(attendanceDateStart);
        String yearMonth = timeStr.substring(0, timeStr.lastIndexOf("-"));
        int month = attendanceDateStart.getMonth().getValue();
        int year = attendanceDateStart.getYear();
        Calendar time = Calendar.getInstance();
        time.set(Calendar.YEAR, year);
        time.set(Calendar.MONTH, month - 1);
        time.set(Calendar.DATE, 1);
        time.roll(Calendar.DATE, -1);
        int maxDate = time.get(Calendar.DATE);
        for (int i = 1; i <= maxDate; i++) {
            String data = yearMonth + "-" + (i < 10 ? ("0" + i) : i);
            LocalDate key = TimeUtil.dateFromYmd(data);
            List<MobAttendanceLogVO> normalLogs = attendanceLogMap.get(key);
            List<ResAttendanceOtherVO> otherLogs = attendanceLogOtherMap.get(key);
            boolean normal = normalLogs != null && normalLogs.size() > 0;
            boolean other = otherLogs != null && otherLogs.size() > 0;
            if (normal || other) {
                MobAttendanceLogVO log = new MobAttendanceLogVO();
                log.setAttendanceDate(key);
                log.setResId(resId);
                if (normal) {
                    TAttendanceNormalVO normalView = normalLogs.get(0).getNormalViews();
                    int frozen = normalLogs.get(0).getFrozen();
                    normalView = (TAttendanceNormalVO) udcUtil.translate(normalView);
                    log.setNormalViews(normalView);
                    log.setFrozen(frozen);
                } else {
                    log.setNormalViews(new TAttendanceNormalVO());
                }
                if (other) {
                    log.setOtherViews(otherLogs);
                } else {
                    log.setOtherViews(new ArrayList<ResAttendanceOtherVO>());
                }
                resAttendanceLogList.add(log);
            }
        }
        return resAttendanceLogList;
    }

    @Override
    public int resAttendanceReason(TAttendanceNormalVO attendanceNormalVO) {

        TAttendanceNormalPayload tAttendanceNormalPayload = new TAttendanceNormalPayload();
        tAttendanceNormalPayload.setId(attendanceNormalVO.getId());
        tAttendanceNormalPayload.setSpecialReason(attendanceNormalVO.getSpecialReason());
        attendanceNormalService.updateByKeyDynamic(tAttendanceNormalPayload);

        TAttendanceNormalVO view = attendanceNormalService.queryByKey(attendanceNormalVO.getId());
        TAttendanceRemarkPayload remarkPayload = new TAttendanceRemarkPayload();
        remarkPayload.setAttendanceResId(view.getAttendanceResId());
        remarkPayload.setTAttendanceNormalId(attendanceNormalVO.getId());
        remarkPayload.setAttendanceDate(view.getAttendanceDate().toString());
        remarkPayload.setAttendanceAbnormalDesc(view.getSpecialReason());
        remarkPayload.setApplyDatetime(LocalDateTime.now());
        PrdOrgEmployeeRefVO refVO = prdOrgEmployeeService.queryEmployeeRef(view.getAttendanceResId());
        remarkPayload.setReportToResId(refVO.getParentId());
        remarkPayload.setApprovalResult("APPROVAL_PENDING");
        Long remarkId = tAttendanceRemarkService.queryByAttendanceNormalId(attendanceNormalVO.getId());
        if (ObjectUtils.isEmpty(remarkId)) {
            tAttendanceRemarkService.insert(remarkPayload);
        } else {
            TAttendanceRemarkPayload updatePayload = new TAttendanceRemarkPayload();
            updatePayload.setId(remarkId);
            updatePayload.setApprovalResult("APPROVAL_PENDING");
            updatePayload.setAttendanceAbnormalDesc(remarkPayload.getAttendanceAbnormalDesc());
            tAttendanceRemarkService.updateByKeyDynamic(updatePayload);
        }

        return 1;

    }

    @Override
    public MobAttendanceResVO getResAttendanceInfo(Long resId, LocalDate attendanceDate) {
        TAttendanceNormalQuery query = new TAttendanceNormalQuery();
        MobAttendanceResVO mobAttendanceResVO = new MobAttendanceResVO();
        query.setAttendanceResId(resId);
        query.setAttendanceDate(attendanceDate);
        List<TAttendanceNormalVO> attendanceNormalVOList = attendanceNormalDAO.queryListDynamic(query);
        TAttendanceNormalVO attendanceNormalVO;
        ResAttendanceVO resAttendanceVO = new ResAttendanceVO();
        if (!ObjectUtils.isEmpty(attendanceNormalVOList)) {
            attendanceNormalVO = attendanceNormalVOList.get(0);

            mobAttendanceResVO.setResId(attendanceNormalVO.getAttendanceResId());
            mobAttendanceResVO.setAttendanceDate(attendanceNormalVO.getAttendanceDate());
            mobAttendanceResVO.setAttendanceTimeStart(tAttendanceRuleDAO.minAttendanceTimeStartLatest(attendanceNormalVO.getAttendanceRuleId()));
            mobAttendanceResVO.setAttendanceTimeEnd(tAttendanceRuleDAO.maxAttendanceTimeEndEarliest(attendanceNormalVO.getAttendanceRuleId()));

            resAttendanceVO.setAttendanceLocation(attendanceNormalVO.getAttendanceLocation());
            resAttendanceVO.setAttendanceRuleId(attendanceNormalVO.getAttendanceRuleId());
            resAttendanceVO.setAttendanceResult(attendanceNormalVO.getAttendanceResult());
            resAttendanceVO.setAttendanceResultDetail(attendanceNormalVO.getAttendanceResultDetail());
            resAttendanceVO.setAttendanceTimeStart(attendanceNormalVO.getAttendanceTimeStart());
            resAttendanceVO.setAttendanceTimeEnd(attendanceNormalVO.getAttendanceTimeEnd());
            resAttendanceVO.setAttendanceRuleId(attendanceNormalVO.getAttendanceRuleId());
            mobAttendanceResVO.setAttendanceInfo(resAttendanceVO);

            //其他打卡信息
            TAttendanceOtherQuery otherQuery = new TAttendanceOtherQuery();
            otherQuery.setAttendanceDate(attendanceDate);
            otherQuery.setAttendanceResId(resId);
            List<TAttendanceOtherVO> otherVOList = attendanceOtherService.queryListDynamic(otherQuery);
            mobAttendanceResVO.setAttendanceOther(otherVOList);

        }
        return mobAttendanceResVO;
    }

    @Transactional
    @Override
    public void updateAttendanceInformation(LocalDate date) {
        //查询生效的打卡规则
        List<Long> ruleIdList = getAttendanceRule().stream().map(TAttendanceRuleVO::getId).toList();
        //获取当天的日期
//        String date = LocalDateTime.now().toLocalDate().toString();
//        LocalDate today = LocalDate.now();
        //String date=LocalDateTime.now().plusDays(-1).toLocalDate().toString();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        DateTimeFormatter pattern = DateTimeFormatter.ofPattern("HH:mm");
        int todayAttendance = 1;
        //获取今天是否是规定上班日期(假期表)
        double i = vacationService.selectWorkHoursByDate(date, date);
        //获取今日是否是特殊打卡(特殊打卡)
        Long t = tAttendanceNormalDateSpecialService.isAttendAnceSpecial(date);
        //先根据假期设置表来判断今天是否需要打卡
        if (i > 0) {
            todayAttendance = 1;
        }
        //如果假期表没有值 就根据特殊打卡来判断
        if (i <= 0) {
            //特殊打卡和规则 都需要今天打卡
            if (t > 0) {
                todayAttendance = 1;
            } else {
                todayAttendance = 0;
            }
        }
        //今天都不需要打卡
        if (i == 0 && t == 0) {
            todayAttendance = 0;
        }
        if (todayAttendance == 1) {
            ruleIdList.stream().forEach(id -> {

                List<Long> resIds = tAttendanceRuleDAO.queryResByRuleId(id);

                TAttendanceNormalQuery attendanceNormalQuery = new TAttendanceNormalQuery();
                attendanceNormalQuery.setAttendanceRuleId(id);
                attendanceNormalQuery.setAttendanceDate(date);
                List<TAttendanceNormalVO> attendanceNormalVOList = attendanceNormalDAO.queryListDynamic(attendanceNormalQuery);
                List<Long> resIds1 = attendanceNormalVOList.stream().map(TAttendanceNormalVO::getAttendanceResId).toList();

                resIds.removeAll(resIds1);
                for (int x = 0; x < resIds.size(); x++) {
                    Long resId = resIds.get(x);
                    //旷工一天
                    insertAbsenteeism(date, resId, id);
                }
                //根据考勤规则id查当天的上班打卡时间
                String startRule = tAttendanceRuleDAO.minAttendanceTimeStartLatest(id);
                if (StringUtils.isEmpty(startRule)) {
                    return;
                }
                //查询当天的上班弹性时间
                int minA = Math.toIntExact(tAttendanceRuleDAO.allowLateMin(id));
                //实际计算时间
                String concat = date.toString().concat(" ").concat(startRule);
                String start = LocalDateTime.parse(concat, dateTimeFormatter).plusMinutes(minA).format(pattern);
                LocalTime allowStartTime = LocalTime.parse(start, pattern);
                //根据id查当天的下班打卡时间
                String endRule = tAttendanceRuleDAO.maxAttendanceTimeEndEarliest(id);
                //查询当天的下班弹性时间
                int minL = Math.toIntExact(tAttendanceRuleDAO.allowLeaveMin(id));
                //实际计算时间
                String concatEnd = date.toString().concat(" ").concat(endRule);
                String end = LocalDateTime.parse(concatEnd, dateTimeFormatter).minusMinutes(minL).format(pattern);
                LocalTime allowEndTime = LocalTime.parse(end, pattern);

                for (TAttendanceNormalVO attendanceNormalVO : attendanceNormalVOList) {
                    LocalTime startTime = null;
                    LocalTime endTime = null;
                    if (!ObjectUtils.isEmpty(attendanceNormalVO.getAttendanceTimeStart())) {
                        startTime = LocalTime.parse(attendanceNormalVO.getAttendanceTimeStart(), pattern);
                    }
                    if (!ObjectUtils.isEmpty(attendanceNormalVO.getAttendanceTimeEnd())) {
                        endTime = LocalTime.parse(attendanceNormalVO.getAttendanceTimeEnd(), pattern);
                    }
                    TAttendanceNormalDO normalDO = TAttendanceNormalConvert.INSTANCE.toEntity(attendanceNormalVO);
                    normalDO.setId(attendanceNormalVO.getId());

                    if (startTime != null && endTime != null) {
                        //正常打卡
                        if (startTime.compareTo(allowStartTime) <= 0 && endTime.compareTo(allowEndTime) >= 0) {
                            normalDO.setAttendanceResult("YES");
                            normalDO.setAttendanceResultDetail("NORMAL");
                        }
                        //迟到
                        if (startTime.isAfter(allowStartTime) && startTime.isBefore(allowEndTime) && endTime.isAfter(allowEndTime)) {
                            normalDO.setAttendanceResult("NO");
                            normalDO.setAttendanceResultDetail("BE_LATE");
                        }
                        //早退
                        if (startTime.compareTo(allowStartTime) <= 0 && endTime.isAfter(allowStartTime) && endTime.isBefore(allowEndTime)) {
                            normalDO.setAttendanceResult("NO");
                            normalDO.setAttendanceResultDetail("LEAVE_EARLY");
                        }
                        //迟到早退
                        if (startTime.isAfter(allowStartTime) && endTime.isBefore(endTime)) {
                            normalDO.setAttendanceResult("NO");
                            normalDO.setAttendanceResultDetail("BELATE_LEAVEEARLY");
                        }
                    }
                    if (startTime == null && endTime != null) {
                        //缺卡
                        if (endTime.compareTo(allowEndTime) >= 0) {
                            normalDO.setAttendanceResult("NO");
                            normalDO.setAttendanceResultDetail("MISSING_CARD");
                        }
                    }
                    if (startTime != null && endTime == null) {
                        //缺卡
                        if (startTime.compareTo(allowStartTime) <= 0) {
                            normalDO.setAttendanceResult("NO");
                            normalDO.setAttendanceResultDetail("MISSING_CARD");
                        }
                        //迟到缺卡
                        if (startTime.isAfter(allowStartTime)) {
                            normalDO.setAttendanceResult("NO");
                            normalDO.setAttendanceResultDetail("BELATE_MISSINGCARD");
                        }
                    }
                    attendanceNormalDAO.save(normalDO);
                }
            });
        }

    }

    @Transactional
    public void insertAbsenteeism(LocalDate date, Long resId, Long ruleId) {
        TAttendanceNormalDO attendanceNormalDO = new TAttendanceNormalDO();
        attendanceNormalDO.setAttendanceRuleId(ruleId);
        attendanceNormalDO.setAttendanceResId(resId);
        attendanceNormalDO.setAttendanceResult("NO");
        attendanceNormalDO.setAttendanceResultDetail("ABSENTEEISM");
        attendanceNormalDO.setAttendanceDate(date);
        attendanceNormalDAO.save(attendanceNormalDO);

    }


}
