package com.elitesland.tw.tw5.server.prd.org.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeeRefPayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeLeaderQuery;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeSuperiorQuery;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemUserRoleVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SystemDefaultEnum;
import com.elitesland.tw.tw5.server.prd.org.entity.*;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgEmployeeRefRepo;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgEmployeeRepo;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgPersonRepo;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBusinessPartnerDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.QBusinessCustomerInfoDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemUserRoleDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemRoleDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemShortcutDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemUserRoleDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemUserRoleRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Repository
@RequiredArgsConstructor
public class PrdOrgEmployeeDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdOrgEmployeeRepo repo;
    private final PrdOrgEmployeeRefRepo repoRef;
    private final PrdSystemUserRoleRepo repoUserRole;
    private final PrdOrgPersonRepo repoPerson;
    private final QPrdOrgEmployeeDO qdo = new QPrdOrgEmployeeDO("prdOrgEmployeeDO");
    private final QPrdOrgPersonDO qdoPerson = QPrdOrgPersonDO.prdOrgPersonDO;
    // private final QPrdOrgCompanyDO qdoCompany = QPrdOrgCompanyDO.prdOrgCompanyDO;
    private final QPrdOrgDimensionDO qdoDimension = QPrdOrgDimensionDO.prdOrgDimensionDO;
    private final QPrdOrgOrganizationDO qdoOrg = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final QPrdOrgEmployeeRefDO qdoRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;
    private final QPrdOrgEmployeeDO n_qdo = new QPrdOrgEmployeeDO("prdOrgEmployeeDO1");
    private final QPrdOrgEmployeeDO qdo2 = new QPrdOrgEmployeeDO("prdOrgEmployeeDO2");
    private final QPrdSystemShortcutDO qdoShortcut = QPrdSystemShortcutDO.prdSystemShortcutDO;
    private final QPrdSystemUserRoleDO qdoUserRole = QPrdSystemUserRoleDO.prdSystemUserRoleDO;
    private final QPrdSystemRoleDO qdoRole = QPrdSystemRoleDO.prdSystemRoleDO;
    private final QBusinessPartnerDO qBusinessPartnerDO = QBusinessPartnerDO.businessPartnerDO;
    private final QBusinessCustomerInfoDO qBusinessCustomerInfoDO = QBusinessCustomerInfoDO.businessCustomerInfoDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemRoleVO> getJpaQuerySelectRoles() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemRoleVO.class,
                qdoRole.id,
                qdoRole.roleCode,
                qdoRole.roleName,
                qdoRole.sortIndex,
                qdoRole.enabled,
                qdoRole.sortIndex,
                qdoRole.remark
        )).from(qdoRole).leftJoin(qdoUserRole).on(qdoRole.id.longValue().eq(qdoUserRole.roleId.longValue()));
    }

    /**
     * 查询所有
     *
     * @return 结果
     */
    public List<PrdSystemRoleVO> queryUserRoles(Long userId) {
        JPAQuery<PrdSystemRoleVO> jpaQuery = getJpaQuerySelectRoles();
        jpaQuery.where(qdoUserRole.userId.eq(userId));
        jpaQuery.where(qdoRole.deleteFlag.eq(0));
        jpaQuery.where(qdoRole.enabled.eq(true));
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgEmployeeVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PrdOrgEmployeeVO.class,
                        qdo.id,
                        qdo.userId,
                        qdo.personId,
                        qdoOrg.orgName,
                        qdoOrg.organizationType,
                        qdo.employeeName,
                        qdo.resourceStatus,
                        qdo.employeeNo,
                        qdo.remark,
                        qdo.jobs,
                        qdo.enrollDate,
                        qdo.createUserId,
                        qdo.createTime,
                        qdo.eqvaRatio,
                        qdo.bangwo8AdviserId,
                        qdoPerson.foreignName,
                        qdoPerson.mobile,
                        qdoPerson.email,
                        qdoPerson.sex,
                        qdoPerson.idNo,
                        qdo.createTime,
                        qdo.hrStatus,
                        qdoRef.orgId,
                        qdoRef.parentId,
                        qdo2.employeeNo.as("parentNo"),
                        qdo.extString1,
                        qdo.extString5,
                        qdo.extString6,
                        qdo.extString2,
                        qdo.bookId,
                        qdo.resNo,
                        qBusinessPartnerDO.partnerName.as("companyName")
                )).from(qdo).leftJoin(qdoPerson).on(qdo.personId.longValue().eq(qdoPerson.id.longValue()))
                .leftJoin(qdoRef).on(qdo.userId.longValue().eq(qdoRef.userId.longValue()).and(qdoRef.isDefault.eq(0)).and(qdoRef.isCopy.eq(0)).and(qdoRef.deleteFlag.eq(0)))
                .leftJoin(qdoOrg).on(qdoOrg.id.longValue().eq(qdoRef.orgId.longValue()).and(qdoOrg.isCopy.eq(0)))
                .leftJoin(qdoUserRole).on(qdoUserRole.userId.longValue().eq(qdo.userId.longValue()))
                .leftJoin(qdo2).on(qdoRef.parentId.longValue().eq(qdo2.userId.longValue()))
                .leftJoin(qdoRole).on(qdoRole.id.longValue().eq(qdoUserRole.roleId.longValue()))
                .leftJoin(qBusinessPartnerDO).on(qBusinessPartnerDO.bookId.eq(qdo.bookId).and(qBusinessPartnerDO.deleteFlag.eq(0)));

    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgEmployeeRefVO> getJpaQuerySelect0() {
        return jpaQueryFactory.select(Projections.bean(PrdOrgEmployeeRefVO.class,
                qdoRef.id,
                qdoRef.userId,
                qdoRef.orgId,
                qdoRef.parentId,
                qdo.employeeName,
                qdoRef.joinDate,
                qdoRef.leaveDate,
                qdoRef.isDefault,
                qdoRef.remark,
                qdoRef.createUserId,
                qdoRef.createTime
        )).from(qdoRef).leftJoin(qdo).on(qdo.userId.longValue().eq(qdoRef.userId.longValue()));
    }

    /**
     * 查询所有下级数据
     *
     * @return 结果
     */
    public List<PrdOrgEmployeeRefVO> queryLowerUserList(Long orgId, Long userId) {
        JPAQuery<PrdOrgEmployeeRefVO> jpaQuery = getJpaQuerySelect0();
        jpaQuery.where(qdoRef.parentId.eq(userId));
        jpaQuery.where(qdoRef.deleteFlag.eq(0));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        jpaQuery.where(qdoRef.isCopy.eq(0));
        jpaQuery.where(qdo.resourceStatus.ne(String.valueOf(6)));
        if (orgId != null) {
            jpaQuery.where(qdoRef.orgId.eq(orgId));
        }
        return jpaQuery.fetch();
    }

    /**
     * 调用jpa的保存
     *
     * @param ados do对象
     * @return 保存后的对象
     */
    public List<PrdSystemUserRoleDO> saveUserRoleAll(List<PrdSystemUserRoleDO> ados) {
        return repoUserRole.saveAll(ados);
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdSystemUserRoleDO saveUserRole(PrdSystemUserRoleDO ado) {
        return repoUserRole.save(ado);
    }

    /**
     * 物理删除
     *
     * @param userId
     * @return 删除的行数
     */
    public long deleteRolesByUserId(Long userId) {
        JPADeleteClause delete = jpaQueryFactory.delete(qdoUserRole).where(qdoUserRole.userId.eq(userId));
        return delete.execute();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgDataRefVO> getJpaQueryDataSelect() {
        return jpaQueryFactory.select(Projections.bean(PrdOrgDataRefVO.class,
                        qdoRef.id,
                        qdoRef.userId,
                        qdoRef.orgId,
                        qdoRef.parentId,
                        qdoRef.joinDate,
                        qdoRef.leaveDate,
                        qdoRef.isDefault,
                        qdo.employeeName.as("parentName"),
                        qdoOrg.orgName,
                        qdoDimension.id.as("dimensionId"),
                        qdoDimension.dimensionName,
                        qdoRef.remark,
                        qdoRef.createUserId,
                        qdoRef.createTime
                )).from(qdoRef)
                .leftJoin(qdo).on(qdo.userId.longValue().eq(qdoRef.parentId).and(qdo.deleteFlag.eq(0)))
                .leftJoin(qdoOrg).on(qdoOrg.id.longValue().eq(qdoRef.orgId.longValue()))
                .leftJoin(qdoDimension).on(qdoOrg.dimensionId.longValue().eq(qdoDimension.id.longValue()));
    }


    /**
     * 员工组织关系
     *
     * @return 结果
     */
    public List<PrdOrgDataRefVO> queryOrgListByKey(Long userId) {
        JPAQuery<PrdOrgDataRefVO> jpaQuery = getJpaQueryDataSelect();
        jpaQuery.where(qdoRef.userId.eq(userId));
        jpaQuery.where(qdoRef.deleteFlag.eq(0));
        jpaQuery.where(qdoOrg.deleteFlag.eq(0));
        jpaQuery.where(qdoDimension.deleteFlag.eq(0));
        // jpaQuery.where(qdoRef.isCopy.eq(0));
        jpaQuery.where(qdoDimension.versionId.eq(0L));
        return jpaQuery.fetch();
    }


    /**
     * 员工默认组织关系
     *
     * @return 结果
     */
    public List<PrdOrgDataRefVO> queryDefOrgListByKey(Long userId) {
        JPAQuery<PrdOrgDataRefVO> jpaQuery = getJpaQueryDataSelect();
        jpaQuery.where(qdoRef.userId.eq(userId));
        jpaQuery.where(qdoRef.deleteFlag.eq(0));
        jpaQuery.where(qdoDimension.deleteFlag.eq(0));
        // jpaQuery.where(qdoRef.isCopy.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 员工组织关系
     *
     * @return 结果
     */
    public List<PrdOrgDataRefVO> queryOrgList() {
        JPAQuery<PrdOrgDataRefVO> jpaQuery = getJpaQueryDataSelect();
        jpaQuery.where(qdoRef.deleteFlag.eq(0));
        jpaQuery.where(qdoRef.deleteFlag.eq(0));
        jpaQuery.where(qdoOrg.deleteFlag.eq(0));
        jpaQuery.where(qdoDimension.deleteFlag.eq(0));
        jpaQuery.where(qdoDimension.versionId.eq(0L));
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgEmployeeRefVO> getJpaQueryDefaultRefSelect() {
        return jpaQueryFactory.select(Projections.bean(PrdOrgEmployeeRefVO.class,
                qdoRef.id,
                qdoRef.userId,
                qdoRef.orgId,
                qdoRef.parentId,
                qdoOrg.orgName
        )).from(qdoRef).leftJoin(qdoOrg).on(qdoOrg.id.longValue().eq(qdoRef.orgId.longValue()));
    }

    /**
     * 通过维度id查询维度下的所有组织关系
     *
     * @param dimensionId
     * @return
     */
    public List<PrdOrgEmployeeRefVO> queryDefaultOrgEmployeeRef(Long dimensionId) {

        JPAQuery<PrdOrgEmployeeRefVO> jpaQuery = getJpaQueryDefaultRefSelect();
        jpaQuery.where(qdoRef.deleteFlag.eq(0)).where(qdoOrg.deleteFlag.eq(0)).where(qdoRef.isDefault.eq(0));
        jpaQuery.where(qdoOrg.dimensionId.eq(dimensionId));

        return jpaQuery.fetch();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdOrgEmployeeDO save(PrdOrgEmployeeDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdOrgEmployeeRefDO saveRef(PrdOrgEmployeeRefDO ado) {
        return repoRef.save(ado);
    }

    /**
     * 调用jpa的保存
     *
     * @param ados do对象
     * @return 保存后的对象
     */
    public List<PrdOrgEmployeeRefDO> saveAllRef(List<PrdOrgEmployeeRefDO> ados) {
        return repoRef.saveAll(ados);
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdOrgPersonDO savePerson(PrdOrgPersonDO ado) {
        return repoPerson.save(ado);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long update(PrdOrgEmployeePayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));

        if (payload.getEmployeeName() != null) {
            update.set(qdo.employeeName, payload.getEmployeeName());
        }
        if (payload.getEmployeeNo() != null) {
            update.set(qdo.employeeNo, payload.getEmployeeNo());
        }
        if (payload.getHrStatus() != null) {
            update.set(qdo.hrStatus, payload.getHrStatus());
        }
        if (payload.getResourceStatus() != null) {
            update.set(qdo.resourceStatus, payload.getResourceStatus());
        }
        if (payload.getEnrollDate() != null) {
            update.set(qdo.enrollDate, payload.getEnrollDate());
        }
        if (payload.getAccessLevel() != null) {
            update.set(qdo.accessLevel, payload.getAccessLevel());
        }
        if (payload.getJobs() != null) {
            update.set(qdo.jobs, payload.getJobs());
        }
        if (payload.getSortIndex() != null) {
            update.set(qdo.sortIndex, payload.getSortIndex());
        }

        if (payload.getExtString1() != null) {
            update.set(qdo.extString1, payload.getExtString1());
        }
        if (payload.getExtString2() != null) {
            update.set(qdo.extString2, payload.getExtString2());
        }
        if (payload.getExtString3() != null) {
            update.set(qdo.extString3, payload.getExtString3());
        }
        if (payload.getExtString4() != null) {
            update.set(qdo.extString4, payload.getExtString4());
        }
        if (payload.getExtString5() != null) {
            update.set(qdo.extString5, payload.getExtString5());
        }
        if (payload.getExtString6() != null) {
            update.set(qdo.extString6, payload.getExtString6());
        }
        if (payload.getExtString7() != null) {
            update.set(qdo.extString7, payload.getExtString7());
        }
        if (payload.getExtString8() != null) {
            update.set(qdo.extString8, payload.getExtString8());
        }
        if (payload.getExtString9() != null) {
            update.set(qdo.extString9, payload.getExtString9());
        }
        if (payload.getExtString10() != null) {
            update.set(qdo.extString10, payload.getExtString10());
        }
        if (payload.getExtString11() != null) {
            update.set(qdo.extString11, payload.getExtString11());
        }
        if (payload.getExtString12() != null) {
            update.set(qdo.extString12, payload.getExtString12());
        }

        if (payload.getExtDate1() != null) {
            update.set(qdo.extDate1, payload.getExtDate1());
        }
        if (payload.getExtDate2() != null) {
            update.set(qdo.extDate2, payload.getExtDate2());
        }
        if (payload.getExtDate3() != null) {
            update.set(qdo.extDate3, payload.getExtDate3());
        }
        if (payload.getExtDate4() != null) {
            update.set(qdo.extDate4, payload.getExtDate4());
        }
        if (payload.getExtDate5() != null) {
            update.set(qdo.extDate5, payload.getExtDate5());
        }
        if (payload.getExtDate6() != null) {
            update.set(qdo.extDate6, payload.getExtDate6());
        }
        if (payload.getExtDate7() != null) {
            update.set(qdo.extDate7, payload.getExtDate7());
        }
        if (payload.getExtDate8() != null) {
            update.set(qdo.extDate8, payload.getExtDate8());
        }

        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        if (payload.getCooperationMode() != null) {
            update.set(qdo.cooperationMode, payload.getCooperationMode());
        }
        if (payload.getResManagerId() != null) {
            update.set(qdo.resManagerId, payload.getResManagerId());
        }
        if (payload.getBusiTrainFlag() != null) {
            update.set(qdo.busiTrainFlag, payload.getBusiTrainFlag());
        }
        if (payload.getInLieuFlag() != null) {
            update.set(qdo.inLieuFlag, payload.getInLieuFlag());
        }
        if (payload.getJobClass1() != null) {
            update.set(qdo.jobClass1, payload.getJobClass1());
        }
        if (payload.getJobClass2() != null) {
            update.set(qdo.jobClass2, payload.getJobClass2());
        }
        if (payload.getPeriodFlag() != null) {
            update.set(qdo.periodFlag, payload.getPeriodFlag());
        }
        if (payload.getCapasetLevelId() != null) {
            update.set(qdo.capasetLevelId, payload.getCapasetLevelId());
        }
        if (payload.getSalaryMethod() != null) {
            update.set(qdo.salaryMethod, payload.getSalaryMethod());
        }
        if (payload.getSalaryPeriod() != null) {
            update.set(qdo.salaryPeriod, payload.getSalaryPeriod());
        }
//        if (payload.getCompanyId() != null) {
//            update.set(qdo.companyId, payload.getCompanyId());
//        }
        if (payload.getBookId() != null) {
            update.set(qdo.bookId, payload.getBookId());
        }
        if (payload.getSettleMethod() != null) {
            update.set(qdo.settleMethod, payload.getSettleMethod());
        }
        if (payload.getEqvaRatio() != null) {
            update.set(qdo.eqvaRatio, payload.getEqvaRatio());
        }
        if (payload.getPeriodFlag() != null) {
            update.set(qdo.periodFlag, payload.getPeriodFlag());
        }
        if (payload.getServiceClockFrom() != null) {
            update.set(qdo.serviceClockFrom, payload.getServiceClockFrom());
        }
        if (payload.getServiceClockTo() != null) {
            update.set(qdo.serviceClockTo, payload.getServiceClockTo());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("remark")) {
                update.setNull(qdo.remark);
            }
        }
        // 执行修改
        return update.execute();
    }

    /**
     * 修改自人人数据
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long updatePerson(PrdOrgEmployeePayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdoPerson)
                .where(qdoPerson.id.eq(payload.getPersonId()));

        if (payload.getPersonName() != null) {
            update.set(qdoPerson.personName, payload.getPersonName());
        }
        if (payload.getForeignName() != null) {
            update.set(qdoPerson.foreignName, payload.getForeignName());
        }
        if (payload.getIdType() != null) {
            update.set(qdoPerson.idType, payload.getIdType());
        }
        if (payload.getIdNo() != null) {
            update.set(qdoPerson.idNo, payload.getIdNo());
        }
        if (payload.getUserName() != null) {
            update.set(qdoPerson.userName, payload.getUserName());
        }
        if (payload.getMobile() != null) {
            update.set(qdoPerson.mobile, payload.getMobile());
        }
        if (payload.getEmail() != null) {
            update.set(qdoPerson.email, payload.getEmail());
        }
        if (payload.getEnabled() != null) {
            update.set(qdoPerson.enabled, payload.getEnabled());
        }
        if (payload.getIdValidFrom() != null) {
            update.set(qdoPerson.idValidFrom, payload.getIdValidFrom());
        }
        if (payload.getIdValidTo() != null) {
            update.set(qdoPerson.idValidTo, payload.getIdValidTo());
        }
        if (payload.getBirthday() != null) {
            update.set(qdoPerson.birthday, payload.getBirthday());
        }
        if (payload.getSex() != null) {
            update.set(qdoPerson.sex, payload.getSex());
        }
        if (payload.getIdValidCodes() != null) {
            update.set(qdoPerson.idValidCodes, payload.getIdValidCodes());
        }
        if (payload.getHeadCodes() != null) {
            update.set(qdoPerson.headCodes, payload.getHeadCodes());
        }
        if (payload.getSortIndex() != null) {
            update.set(qdoPerson.sortIndex, payload.getSortIndex());
        }

        if (payload.getNationality() != null) {
            update.set(qdoPerson.nationality, payload.getNationality());
        }
        if (payload.getBirthplace() != null) {
            update.set(qdoPerson.birthplace, payload.getBirthplace());
        }
        if (payload.getNation() != null) {
            update.set(qdoPerson.nation, payload.getNation());
        }
        if (payload.getMarital() != null) {
            update.set(qdoPerson.marital, payload.getMarital());
        }
        if (payload.getAddr() != null) {
            update.set(qdoPerson.addr, payload.getAddr());
        }
        if (payload.getUrgency_name() != null) {
            update.set(qdoPerson.urgency_name, payload.getUrgency_name());
        }
        if (payload.getUrgency_mobile() != null) {
            update.set(qdoPerson.urgency_mobile, payload.getUrgency_mobile());
        }
        if (payload.getUrgency_ref() != null) {
            update.set(qdoPerson.urgency_ref, payload.getUrgency_ref());
        }
        if (payload.getRemark() != null) {
            update.set(qdoPerson.remark, payload.getRemark());
        }
        if (payload.getProfessionalYears() != null) {
            update.set(qdoPerson.professionalYears, payload.getProfessionalYears());
        }
        if (payload.getSelfEvaluation() != null) {
            update.set(qdoPerson.selfEvaluation, payload.getSelfEvaluation());
        }
        if (payload.getSelfTagging() != null) {
            update.set(qdoPerson.selfTagging, payload.getSelfTagging());
        }
        if (payload.getProfessionalSkills() != null) {
            update.set(qdoPerson.professionalSkills, payload.getProfessionalSkills());
        }
        if (payload.getSelfIntroVideoCodes() != null) {
            update.set(qdoPerson.selfIntroVideoCodes, payload.getSelfIntroVideoCodes());
        }
        if (payload.getResumeCodes() != null) {
            update.set(qdoPerson.resumeCodes, payload.getResumeCodes());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("remark")) {
                update.setNull(qdoPerson.remark);
            }
        }
        // 执行修改
        return update.execute();
    }

    /**
     * 根据组织id和员工Id查询组织关系
     *
     * @return 结果
     */
    public PrdOrgEmployeeRefDO queryByOrgIdAndUserId(Long orgId, Long userId) {
        JPAQuery<PrdOrgEmployeeRefDO> jpaQuery = jpaQueryFactory.select(qdoRef).from(qdoRef);
        jpaQuery.where(qdoRef.orgId.eq(orgId));
        jpaQuery.where(qdoRef.userId.eq(userId));
        jpaQuery.where(qdoRef.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 逻辑删除
     *
     * @return 删除的行数
     */
    public long deleteEmployeeRefSoft(Long userId, List<Long> orgIds) {

        JPAUpdateClause update = jpaQueryFactory.update(qdoRef)
                .set(qdoRef.deleteFlag, 1)
                .set(qdoRef.leaveDate, LocalDate.now())
                .where(qdoRef.userId.eq(userId))
                .where(qdoRef.isDefault.eq(1));

        if (!CollectionUtils.isEmpty(orgIds)) {
            update.where(qdoRef.orgId.in(orgIds));
        }
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @return 删除的行数
     */
    public long deleteEmployeeRefSoftAll(Long userId, LocalDate date) {

        JPAUpdateClause update = jpaQueryFactory.update(qdoRef)
                .set(qdoRef.statusFlag, 0)
                .set(qdoRef.leaveDate, date)
                .where(qdoRef.userId.eq(userId))
                .where(qdoRef.deleteFlag.eq(0));
        return update.execute();
    }

//    /**
//     * 根据组织id和员工Id查询组织关系
//     *
//     * @return 结果
//     */
//    public PrdOrgEmployeeRefDO queryDefault(Long userId) {
//        JPAQuery<PrdOrgEmployeeRefDO> jpaQuery = jpaQueryFactory.select(qdoRef).from(qdoRef);
//        jpaQuery.where(qdoRef.userId.eq(userId));
//        jpaQuery.where(qdoRef.isDefault.eq(0));
//        return jpaQuery.fetchFirst();
//    }

    /**
     * 修改员工关系
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long updateEmployeeRef(PrdOrgEmployeeRefPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdoRef)
                .where(qdoRef.id.eq(payload.getId()));

        if (payload.getParentId() != null && payload.getParentId().longValue() != 0) {
            update.set(qdoRef.parentId, payload.getParentId());
        }
        if (payload.getIsDefault() != null) {
            update.set(qdoRef.isDefault, payload.getIsDefault());
        }
        if (payload.getOrgId() != null && payload.getOrgId().longValue() != 0) {
            update.set(qdoRef.orgId, payload.getOrgId());
        }
        if (payload.getRemark() != null) {
            update.set(qdoRef.remark, payload.getRemark());
        }
        // 执行修改
        return update.execute();
    }

//

    /**
     * 根据主键查询
     *
     * @param key
     * @return 结果
     */
    public PrdOrgEmployeeVO queryByKey(Long key) {
        JPAQuery<PrdOrgEmployeeVO> jpaQuery = getJpaQueryEmployeeByKey();
        jpaQuery.where(qdo.id.eq(key));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据主键查询
     *
     * @param userId
     * @return 结果
     */
    public PrdOrgEmployeeVO queryByUserId1(Long userId) {
        JPAQuery<PrdOrgEmployeeVO> jpaQuery = getJpaQueryEmployeeByKey();
        jpaQuery.where(qdo.userId.eq(userId));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据主键查询
     *
     * @param userIds
     * @return 结果
     */
    public List<PrdOrgEmployeeVO> queryByUserIdIn(List<Long> userIds) {
        JPAQuery<PrdOrgEmployeeVO> jpaQuery = getJpaQueryEmployeeByKey();
        jpaQuery.where(qdo.userId.in(userIds));
        return jpaQuery.fetch();
    }

    /**
     * 根据userid查询
     *
     * @param userId
     * @return 结果
     */
    public PrdOrgEmployeeDO queryByUserId(Long userId) {
        JPAQuery<PrdOrgEmployeeDO> jpaQuery = jpaQueryFactory.select(qdo).from(qdo);
        jpaQuery.where(qdo.userId.eq(userId));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据userid查询
     *
     * @param userId
     * @return 结果
     */
    public PrdOrgEmployeeDO queryByUserIdV4(Long userId) {
        JPAQuery<PrdOrgEmployeeDO> jpaQuery = jpaQueryFactory.select(qdo).from(qdo);
        jpaQuery.where(qdo.userIdV4.eq(userId));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据员工姓名查询
     *
     * @param employeeName 员工名字
     * @return {@link PrdOrgEmployeeDO}
     */
    public PrdOrgEmployeeDO queryByUserName(String employeeName) {
        JPAQuery<PrdOrgEmployeeDO> jpaQuery = jpaQueryFactory.select(qdo).from(qdo);
        jpaQuery.where(qdo.employeeName.eq(employeeName));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据员工姓名查询重名的员工
     *
     * @param employeeNameList 员工名字
     * @return {@link PrdOrgEmployeeDO}
     */
    public List<String> queryRepeatedNameByUserName(List<String> employeeNameList) {
        JPAQuery<String> jpaQuery = jpaQueryFactory.select(qdo.employeeName).from(qdo);
        jpaQuery.where(qdo.employeeName.in(employeeNameList));
        jpaQuery.groupBy(qdo.employeeName).having(qdo.employeeName.count().goe(2));
        return jpaQuery.fetch();
    }

    /**
     * 查询列表
     *
     * @return {@link List}<{@link PrdOrgEmployeeDO}>
     */
    public List<PrdOrgEmployeeDO> queryList() {
        JPAQuery<PrdOrgEmployeeDO> jpaQuery = jpaQueryFactory.select(qdo).from(qdo);
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 根据userId查询 用户信息
     *
     * @return {@link List}<{@link PrdOrgEmployeeDO}>
     */
    public List<PrdOrgEmployeeDO> queryListByUserIdList(List userIdList) {
        if (!CollectionUtils.isEmpty(userIdList)) {
            JPAQuery<PrdOrgEmployeeDO> jpaQuery = jpaQueryFactory.select(qdo).from(qdo);
            jpaQuery.where(qdo.deleteFlag.eq(0));
            jpaQuery.where(qdo.userId.in(userIdList));
            return jpaQuery.fetch();
        }
        return Collections.emptyList();
    }

    /**
     * 根据工号查
     *
     * @param employeeNo
     * @return 结果
     */
    public PrdOrgEmployeeDO queryByEmployeeNo(String employeeNo) {
        JPAQuery<PrdOrgEmployeeDO> jpaQuery = jpaQueryFactory.select(qdo).from(qdo);
        jpaQuery.where(qdo.employeeNo.eq(employeeNo));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据企业微信用户id查询
     *
     * @param wecomId
     * @return 结果
     */
    public PrdOrgEmployeeDO queryByWeComeId(String wecomId) {
        JPAQuery<PrdOrgEmployeeDO> jpaQuery = jpaQueryFactory.select(qdo).from(qdo);
        jpaQuery.where(qdo.wecomId.eq(wecomId));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据编号查询
     *
     * @param code 员工编号
     * @return 结果
     */
    public PrdOrgEmployeeDO queryByCode(String code) {
        JPAQuery<PrdOrgEmployeeDO> jpaQuery = jpaQueryFactory.select(qdo).from(qdo);
        jpaQuery.where(qdo.employeeNo.eq(code));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据编号查询
     *
     * @param codes 员工编号
     * @return 结果
     */
    public List<PrdOrgEmployeeDO> queryListByCode(List<String> codes) {
        JPAQuery<PrdOrgEmployeeDO> jpaQuery = jpaQueryFactory.select(qdo).from(qdo);
        jpaQuery.where(qdo.employeeNo.in(codes));
        return jpaQuery.fetch();
    }


    /**
     * 根据id查询人员信息
     *
     * @param personId
     * @return 结果
     */
    public PrdOrgPersonDO queryPersonById(Long personId) {
        JPAQuery<PrdOrgPersonDO> jpaQuery = jpaQueryFactory.select(qdoPerson).from(qdoPerson);
        jpaQuery.where(qdoPerson.id.eq(personId));
        //    jpaQuery.where(qdoPerson.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }


    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgEmployeeVO> getJpaQueryMobileSelect() {
        return jpaQueryFactory.select(Projections.bean(PrdOrgEmployeeVO.class,
                qdo.id,
                qdo.userId,
                qdo.employeeName,
                qdoPerson.mobile
        )).from(qdo).leftJoin(qdoPerson).on(qdo.personId.longValue().eq(qdoPerson.id.longValue()));
    }

    /**
     * 查询所有
     *
     * @param userIds userId
     * @return 结果
     */
    public List<PrdOrgEmployeeVO> queryMobileList(List<Long> userIds) {
        JPAQuery<PrdOrgEmployeeVO> jpaQuery = getJpaQueryMobileSelect();
        jpaQuery.where(qdo.deleteFlag.eq(0));
        jpaQuery.where(qdoPerson.deleteFlag.eq(0));
        jpaQuery.where(qdo.resourceStatus.eq(SystemDefaultEnum.DefaultResourceStatus.getCode()));
        jpaQuery.where(qdo.hrStatus.eq(SystemDefaultEnum.DefaultHrStatus.getCode()));
        if (userIds == null || userIds.size() == 0) {
            jpaQuery.where(qdo.wecomId.isNull().or(qdo.wecomId.isEmpty()));
        } else {
            jpaQuery.where(qdo.userId.in(userIds));
        }
        return jpaQuery.fetch();
    }
//
//    /**
//     * 查询所有
//     *
//     * @param userIds userId
//     * @return 结果
//     */
//    public List<PrdOrgPersonDO> queryBachtMobileList(List<Long> userIds) {
//        JPAQuery<PrdOrgPersonDO> jpaQuery = jpaQueryFactory.select(qdoPerson).from(qdo).leftJoin(qdoPerson).on(qdo.personId.longValue().eq(qdoPerson.id.longValue()));
//        jpaQuery.where(qdo.deleteFlag.eq(0));
//        jpaQuery.where(qdoPerson.deleteFlag.eq(0));
//        if (userIds == null || userIds.size() == 0) {
//            jpaQuery.where(qdo.wecomId.isNull().or(qdo.wecomId.isEmpty()));
//        } else {
//            jpaQuery.where(qdo.userId.in(userIds));
//        }
//        return jpaQuery.fetch();
//    }

    /**
     * 查询所有
     *
     * @return 结果
     */
    public List<PrdOrgEmployeeVO> queryList(PrdOrgEmployeeQuery query) {
        JPAQuery<PrdOrgEmployeeVO> jpaQuery = getJpaQuerySelect();
        if (!ObjectUtils.isEmpty(query.getEmployeeNo())) {
            jpaQuery.where(qdo.employeeNo.like(SqlUtil.toSqlLikeString(query.getEmployeeNo())));
        }
        if (!ObjectUtils.isEmpty(query.getEnabled())) {
            jpaQuery.where(qdoPerson.enabled.eq(query.getEnabled()));
        }

        if (!ObjectUtils.isEmpty(query.getModifyTimeStart())) {
            jpaQuery.where(qdo.modifyTime.after(query.getModifyTimeStart()));
        }
        if (!ObjectUtils.isEmpty(query.getUserIds())) {
            jpaQuery.where(qdo.userId.in(query.getUserIds()));
        }

        if (!ObjectUtils.isEmpty(query.getEnrollDate())) {
            jpaQuery.where(qdo.enrollDate.eq(query.getEnrollDate()));
        }
        if (!ObjectUtils.isEmpty(query.getResourceStatus())) {
            jpaQuery.where(qdo.resourceStatus.eq(query.getResourceStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getHrStatus())) {
            jpaQuery.where(qdo.hrStatus.eq(query.getHrStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getJobs())) {
            jpaQuery.where(qdo.jobs.eq(query.getJobs()));
        }
        if (!ObjectUtils.isEmpty(query.getBookId())) {
            jpaQuery.where(qdo.bookId.eq(query.getBookId()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString5())) {
            jpaQuery.where(qdo.extString5.like(SqlUtil.toSqlLikeString(query.getExtString5())));
        }
        if (!ObjectUtils.isEmpty(query.getExtString6())) {
            jpaQuery.where(qdo.extString6.eq(query.getExtString6()));
        }
        if (!ObjectUtils.isEmpty(query.getRemark())) {
            jpaQuery.where(qdo.remark.like(SqlUtil.toSqlLikeString(query.getRemark())));
        }
        if (!ObjectUtils.isEmpty(query.getOrgId())) {
            jpaQuery.where(qdoRef.orgId.eq(query.getOrgId()));
            jpaQuery.where(qdoRef.deleteFlag.eq(0));
            jpaQuery.where(qdoOrg.deleteFlag.eq(0));
        }
        if (!ObjectUtils.isEmpty(query.getRoleIds())) {
            jpaQuery.where(qdoRole.id.in(query.getRoleIds()));
            jpaQuery.where(qdoRole.deleteFlag.eq(0));
            jpaQuery.where(qdoUserRole.deleteFlag.eq(0));

        }
        if (!CollectionUtils.isEmpty(query.getUserIdList())) {
            jpaQuery.where(qdo.userId.in(query.getUserIdList()));
        }

        if (!ObjectUtils.isEmpty(query.getOrgIdFlag())) {
            jpaQuery.where(qdoRef.orgId.isNotNull());
        }
        // jpaQuery.where(qdo.resourceStatus.eq(SystemDefaultEnum.DefaultResourceStatus.getCode()));
        jpaQuery.where(qdo.hrStatus.eq(SystemDefaultEnum.DefaultHrStatus.getCode()));
        // 常用基础查询条件拼装
//        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        jpaQuery.groupBy(qdo.userId);
        return jpaQuery.fetch();
    }

    /**
     * 逻辑删除组织关系
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long deleteRefSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdoRef)
                .set(qdoRef.deleteFlag, 1)
                .where(qdoRef.isCopy.eq(0))
                .where(qdoRef.userId.in(keys));
        return update.execute();

    }

    /**
     * 修改企业微信号
     *
     * @param userId  userId
     * @param wecomId 企业微信id
     */
    public long updateWecomId(Long userId, String wecomId) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.wecomId, wecomId)
                .where(qdo.userId.eq(userId));
        return update.execute();
    }

    /**
     * 修改帮我吧用户id
     *
     * @param userId    userId
     * @param adviserId 企业微信id
     */
    @Transactional
    public long updateBangwo8AdviserId(Long userId, Long adviserId) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.bangwo8AdviserId, adviserId)
                .where(qdo.userId.eq(userId));
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }

    /**
     * 逻辑删除自然人
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long deletePersonSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdoPerson)
                .set(qdoPerson.deleteFlag, 1)
                .where(qdoPerson.id.in(keys));
        return update.execute();
    }

    /**
     * 更新默认状态
     *
     * @param userId 员工id
     * @return 删除的行数
     */
    public long updateEmployeeRefStatus(Long userId) {
        JPAUpdateClause update = jpaQueryFactory.update(qdoRef)
                .set(qdoRef.isDefault, 1)
                .where(qdoRef.userId.eq(userId))
                .where(qdoRef.isCopy.eq(0));
        return update.execute();
    }
//    /**
//     * 拼装查询字段
//     *
//     * @return jpaQuery对象
//     */
//    private JPAQuery<PrdSystemSelectionVO> getJpaQuerySelect() {
//        return jpaQueryFactory.select(Projections.bean(PrdSystemSelectionVO.class,
//                qdo.id,
//                qdo.selectionKey,
//                qdo.selectionName,
//                qdo.selectionNameLocale,
//                qdo.selectionValue,
//                qdo.parentId,
//                qdo.sortNo,
//                qdo.createUserId,
//                qdo.createTime
//        )).from(qdo);
//    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgEmployeeVO> getJpaQueryEmployeeSelect() {
        //todo wly 人员
        return jpaQueryFactory.select(Projections.bean(PrdOrgEmployeeVO.class,
                        qdo.id,
                        qdo.employeeName,
                        qdo.resourceStatus,
                        qdo.employeeNo,
                        qdo.createTime,
                        qdo.createUserId,
                        qdo.accessLevel,
                        qdo.bookId,
                        qdo.enrollDate,
                        qBusinessPartnerDO.partnerName.as("companyName"),
                        qdo.extDate1,
                        qdo.extDate2,
                        qdo.extDate3,
                        qdo.extDate4,
                        qdo.extDate5,
                        qdo.extDate6,
                        qdo.extDate7,
                        qdo.extDate8,
                        qdo.wecomId,
                        qdo.extString1,
                        qdo.extString2,
                        qdo.extString3,
                        qdo.extString4,
                        qdo.extString5,
                        qdo.extString6,
                        qdo.extString7,
                        qdo.extString8,
                        qdo.extString9,
                        qdo.extString10,
                        qdo.extString11,
                        qdo.extString12,
                        qdo.hrStatus,
                        qdo.resourceStatus,
                        qdo.jobs,
                        qdo.personId,
                        qdo.userId,
                        qdo.sortIndex,
                        qdo.remark,
                        qdo.tenantId,
                        qdoPerson.foreignName,
                        qdoPerson.idNo,
                        qdoPerson.idType,
                        qdoPerson.userName,
                        qdoPerson.personName,
                        qdoPerson.mobile,
                        qdoPerson.email,
                        qdoPerson.enabled,
                        qdoPerson.sex,
                        qdoRef.orgId,
                        qdoRef.isDefault,
                        qdoRef.parentId,
                        n_qdo.employeeName.as("parentName"),
                        n_qdo.employeeNo.as("parentNo"),
                        qdoOrg.orgName,
                        qdo.cooperationMode
                )).from(qdo).leftJoin(qdoPerson).on(qdo.personId.longValue().eq(qdoPerson.id.longValue()))
                .leftJoin(qdoRef).on(qdo.userId.longValue().eq(qdoRef.userId.longValue()).and(qdoRef.isDefault.eq(0)).and(qdoRef.isCopy.eq(0)).and(qdoRef.deleteFlag.eq(0)))
                .leftJoin(qdoOrg).on(qdoOrg.id.longValue().eq(qdoRef.orgId.longValue()).and(qdoOrg.isCopy.eq(0)))
                .leftJoin(n_qdo).on(n_qdo.userId.longValue().eq(qdoRef.parentId.longValue()).and(n_qdo.deleteFlag.eq(0)))
                .leftJoin(qBusinessPartnerDO).on(qBusinessPartnerDO.bookId.longValue().eq(qdo.bookId.longValue()));
    }

    /**
     * 拼装查询条件
     *
     * @return
     */
    private JPAQuery<PrdOrgEmployeeVO> getJpaQueryUserRole() {
        return jpaQueryFactory.select(Projections.bean(PrdOrgEmployeeVO.class,
                        qdo.id,
                        qdo.employeeName,
                        qdoRole.roleName,
                        qdoRole.id.as("roleId"),
                        qdo.userId,
                        qdoPerson.personName
                )).from(qdo).leftJoin(qdoPerson).on(qdo.personId.longValue().eq(qdoPerson.id.longValue()))
//                .leftJoin(qdoRef).on(qdo.userId.longValue().eq(qdoRef.userId.longValue()).and(qdoRef.isDefault.eq(0)).and(qdoRef.isCopy.eq(0)).and(qdoRef.deleteFlag.eq(0)))
//                .leftJoin(qdoOrg).on(qdoOrg.id.longValue().eq(qdoRef.orgId.longValue()).and(qdoOrg.isCopy.eq(0)))
                .leftJoin(qdoUserRole).on(qdo.userId.longValue().eq(qdoUserRole.userId))
                .leftJoin(qdoRole).on(qdoUserRole.roleId.longValue().eq(qdoRole.id).and(qdoRole.deleteFlag.eq(0)));
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgEmployeeVO> getJpaQueryEmployeeByKey() {
        return jpaQueryFactory.select(Projections.bean(PrdOrgEmployeeVO.class,
                        qdo.id,
                        qdo.employeeName,
                        qdo.employeeNo,
                        qdo.accessLevel,
                        qdo.bookId,
                        qdo.enrollDate,
                        qBusinessPartnerDO.partnerName.as("companyName"),
                        // todo wly jde编号需要修改为子表的 代码需要合并
                        qBusinessPartnerDO.jdeCompanyNo,
                        qdo.personId,
                        qdo.hrStatus,
                        qdo.resourceStatus,
                        qdo.jobs,
                        qdo.personId,
                        qdo.userId,
                        qdo.sortIndex,
                        qdo.wecomId,
                        qdo.tenantId,
                        qdo.accessLevel,
                        qdo.cooperationMode,
                        qdoPerson.foreignName,
                        qdoPerson.idNo,
                        qdoPerson.idType,
                        qdoPerson.userName,
                        qdoPerson.personName,
                        qdoPerson.mobile,
                        qdo.baiwangMobile,
                        qdoPerson.email,
                        qdoPerson.enabled,
                        qdoPerson.sex,
                        qdoPerson.idType,
                        qdoPerson.idNo,
                        qdoPerson.idValidFrom,
                        qdoPerson.idValidTo,
                        qdoPerson.idValidCodes,
                        qdoPerson.headCodes,
                        qdoPerson.birthday,
                        qdoPerson.nationality,
                        qdoPerson.birthplace,
                        qdoPerson.nation,
                        qdoPerson.marital,
                        qdoPerson.addr,
                        qdoPerson.urgency_name,
                        qdoPerson.urgency_mobile,
                        qdoPerson.urgency_ref,
                        qdoPerson.nationality,
                        qdoPerson.birthplace,
                        qdoPerson.nation,
                        qdoPerson.marital,
                        qdoPerson.professionalSkills,
                        qdoPerson.selfEvaluation,
                        qdoPerson.selfIntroVideoCodes,
                        qdoPerson.professionalYears,
                        qdoPerson.resumeCodes,
                        qdoPerson.platformEmail,
                        qdoRef.orgId,
                        qdoOrg.orgName,

                        qdo.remark,
                        qdo.createTime,
                        qdo.createUserId,
                        qdo.extDate1,
                        qdo.extDate2,
                        qdo.extDate3,
                        qdo.extDate4,
                        qdo.extDate5,
                        qdo.extDate6,
                        qdo.extDate7,
                        qdo.extDate8,
                        qdo.wecomId,
                        qdo.extString1,
                        qdo.extString2,
                        qdo.extString3,
                        qdo.extString4,
                        qdo.extString5,
                        qdo.extString6,
                        qdo.extString7,
                        qdo.extString8,
                        qdo.extString9,
                        qdo.extString10,
                        qdo.extString11,
                        qdo.extString12,
                        qdo.busiTripFlag,
                        qdo.jobInternalRecommId,
                        qdo.eqvaRatio,
                        qdoOrg.jdeOrgCode,
                        qdoOrg.organizationType,
                        qdoRef.parentId,
                        qdoRef.orgId,
                        qdoPerson.selfTagging,
                        qdo.procInstId,
                        qdo.internshipStartDate
                )).from(qdo).leftJoin(qdoPerson).on(qdo.personId.longValue().eq(qdoPerson.id.longValue()))
                .leftJoin(qBusinessPartnerDO).on(qBusinessPartnerDO.bookId.longValue().eq(qdo.bookId.longValue()))
                .leftJoin(qdoRef).on(qdo.userId.longValue().eq(qdoRef.userId.longValue()).and(qdoRef.isDefault.eq(0)).and(qdoRef.deleteFlag.eq(0)))
                .leftJoin(qdoOrg).on(qdoOrg.id.longValue().eq(qdoRef.orgId.longValue()))
                .leftJoin(qBusinessCustomerInfoDO).on(qBusinessPartnerDO.id.eq(qBusinessCustomerInfoDO.partnerId).and(qBusinessPartnerDO.deleteFlag.eq(0)))
                ;
    }


    /**
     * 拼装查询条件
     * .
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgEmployeeVO> getJpaQueryWhere(PrdOrgEmployeeQuery query) {
        JPAQuery<PrdOrgEmployeeVO> jpaQuery = getJpaQueryEmployeeSelect();
        if (!ObjectUtils.isEmpty(query.getEmployeeIds())) {
            jpaQuery.where(qdo.id.in(query.getEmployeeIds()));
        }
        if (!ObjectUtils.isEmpty(query.getEmployeeNo())) {
            jpaQuery.where(qdo.employeeNo.like(SqlUtil.toSqlLikeString(query.getEmployeeNo())));
        }
        if (!ObjectUtils.isEmpty(query.getPersonName())) {
            jpaQuery.where(qdoPerson.personName.like(SqlUtil.toSqlLikeString(query.getPersonName())));
        }
        if (!ObjectUtils.isEmpty(query.getEnrollDate())) {
            jpaQuery.where(qdo.enrollDate.eq(query.getEnrollDate()));
        }
        if (!ObjectUtils.isEmpty(query.getResourceStatus())) {
            jpaQuery.where(qdo.resourceStatus.eq(query.getResourceStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getHrStatus())) {
            jpaQuery.where(qdo.hrStatus.eq(query.getHrStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getJobs())) {
            jpaQuery.where(qdo.jobs.eq(query.getJobs()));
        }
        if (!ObjectUtils.isEmpty(query.getBookId())) {
            jpaQuery.where(qdo.bookId.eq(query.getBookId()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString5())) {
            jpaQuery.where(qdo.extString5.like(SqlUtil.toSqlLikeString(query.getExtString5())));
        }
        if (!ObjectUtils.isEmpty(query.getRemark())) {
            jpaQuery.where(qdo.remark.like(SqlUtil.toSqlLikeString(query.getRemark())));
        }
        if (!ObjectUtils.isEmpty(query.getOrgId())) {
            jpaQuery.where(qdoRef.orgId.eq(query.getOrgId()));
            jpaQuery.where(qdoRef.deleteFlag.eq(0));
            jpaQuery.where(qdoOrg.deleteFlag.eq(0));
        }
        if (!ObjectUtils.isEmpty(query.getUserIds())) {
            jpaQuery.where(qdo.userId.in(query.getUserIds()));
        }
        if (!ObjectUtils.isEmpty(query.getCooperationMode())) {
            jpaQuery.where(qdo.cooperationMode.eq(query.getCooperationMode()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString6())) {
            jpaQuery.where(qdo.extString6.eq(query.getExtString6()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString1())) {
            jpaQuery.where(qdo.extString1.eq(query.getExtString1()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString2())) {
            jpaQuery.where(qdo.extString2.eq(query.getExtString2()));
        }
//        if (!ObjectUtils.isEmpty(query.getOrgId())) {
//            jpaQuery.where(qdoRef.orgId.eq(query.getOrgId()));
//            //  jpaQuery.where(qdoRef.isDefault.eq(0).or(qdoRef.isDefault.eq(1)));
//        }

        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        jpaQuery.groupBy(qdo.userId);
        return jpaQuery;
    }

    /**
     * 拼装查询条件
     * .
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgEmployeeVO> getJpaQueryWhereNew(PrdOrgEmployeeQuery query) {
        JPAQuery<PrdOrgEmployeeVO> jpaQuery = getJpaQueryEmployeeSelect();
        jpaQuery.where(qdo.resourceStatus.in("3", "4", "5"));
        jpaQuery.where(qdoPerson.inBlackList.eq(false).or(qdoPerson.inBlackList.isNull()));
        if (!ObjectUtils.isEmpty(query.getEmployeeIds())) {
            jpaQuery.where(qdo.id.in(query.getEmployeeIds()));
        }
        if (!ObjectUtils.isEmpty(query.getEmployeeNo())) {
            jpaQuery.where(qdo.employeeNo.like(SqlUtil.toSqlLikeString(query.getEmployeeNo())));
        }
        if (!ObjectUtils.isEmpty(query.getPersonName())) {
            jpaQuery.where(qdoPerson.personName.like(SqlUtil.toSqlLikeString(query.getPersonName())));
        }
        if (!ObjectUtils.isEmpty(query.getEnrollDate())) {
            jpaQuery.where(qdo.enrollDate.eq(query.getEnrollDate()));
        }
        if (!ObjectUtils.isEmpty(query.getResourceStatus())) {
            jpaQuery.where(qdo.resourceStatus.eq(query.getResourceStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getHrStatus())) {
            jpaQuery.where(qdo.hrStatus.eq(query.getHrStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getJobs())) {
            jpaQuery.where(qdo.jobs.eq(query.getJobs()));
        }
        if (!ObjectUtils.isEmpty(query.getBookId())) {
            jpaQuery.where(qdo.bookId.eq(query.getBookId()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString5())) {
            jpaQuery.where(qdo.extString5.like(SqlUtil.toSqlLikeString(query.getExtString5())));
        }
        if (!ObjectUtils.isEmpty(query.getRemark())) {
            jpaQuery.where(qdo.remark.like(SqlUtil.toSqlLikeString(query.getRemark())));
        }
        if (!ObjectUtils.isEmpty(query.getOrgId())) {
            jpaQuery.where(qdoRef.orgId.eq(query.getOrgId()));
            jpaQuery.where(qdoRef.deleteFlag.eq(0));
            jpaQuery.where(qdoOrg.deleteFlag.eq(0));
        }
//        if (!ObjectUtils.isEmpty(query.getOrgId())) {
//            jpaQuery.where(qdoRef.orgId.eq(query.getOrgId()));
//            //  jpaQuery.where(qdoRef.isDefault.eq(0).or(qdoRef.isDefault.eq(1)));
//        }
        if (!ObjectUtils.isEmpty(query.getUserIds())) {
            jpaQuery.where(qdo.userId.in(query.getUserIds()));
        }
        if (!ObjectUtils.isEmpty(query.getCooperationMode())) {
            jpaQuery.where(qdo.cooperationMode.eq(query.getCooperationMode()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString6())) {
            jpaQuery.where(qdo.extString6.eq(query.getExtString6()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        jpaQuery.groupBy(qdo.userId);
        return jpaQuery;
    }

    public PagingVO<PrdOrgEmployeeVO> queryPagingNew(PrdOrgEmployeeQuery query) {
        JPAQuery<PrdOrgEmployeeVO> jpaQuery = getJpaQueryWhereNew(query);
        QueryResults<PrdOrgEmployeeVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<PrdOrgEmployeeVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PrdOrgEmployeeVO> queryPaging(PrdOrgEmployeeQuery query) {
        JPAQuery<PrdOrgEmployeeVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<PrdOrgEmployeeVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<PrdOrgEmployeeVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public String getPhoneByUserId(Long userId) {
        JPAQuery<String> jpaQuery = jpaQueryFactory.select(qdoPerson.mobile).from(qdo).leftJoin(qdoPerson).on(qdo.personId.longValue().eq(qdoPerson.id.longValue())).where(qdo.userId.eq(userId));
        return jpaQuery.fetchFirst();
    }

    public List<Long> getShortcuts(Integer size) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdoShortcut.id).from(qdoShortcut);
        jpaQuery.where(qdoShortcut.deleteFlag.eq(0));
        jpaQuery.where(qdoShortcut.shortcutStatus.eq(1));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdoShortcut, SqlUtil.getOrderse()));
        return jpaQuery.limit(size).fetch();
    }

    /**
     * 主键查询
     *
     * @return 结果
     */
    public List<PrdOrgEmployeeVO> queryEmployeeList(List<Long> keys) {
        JPAQuery<PrdOrgEmployeeVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.in(keys));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    public List<Long> queryUserIdByEmployeeNo(List<Long> collect) {
        return repo.queryUserIdByEmployeeNo(collect);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgEmployeeRefVO> getJpaQueryUserOrgData() {
        return jpaQueryFactory.select(Projections.bean(PrdOrgEmployeeRefVO.class,
                        qdo.id,
                        qdo.userId,
                        qdo.eqvaRatio,
                        //合作方式
                        qdo.cooperationMode,
                        qdo.extString1,
                        qdo.extString2,
                        qdo.extString3,
                        qdo.extString4,
                        qdo.extString5,
                        qdo.extString6,
                        qdoRef.orgId,
                        qdoRef.parentId,
                        qdoOrg.orgName,
                        qdoOrg.manageId,
                        qdoOrg.extString1.as("buLevel"),
                        qdoOrg.organizationType,
                        qdo.employeeName,
                        qdo.remark,
                        qdo.createUserId,
                        qdo.createTime
                )).from(qdo).leftJoin(qdoRef).on(qdo.userId.longValue().eq(qdoRef.userId.longValue()))
                .leftJoin(qdoOrg).on(qdoOrg.id.longValue().eq(qdoRef.orgId.longValue()));

    }

    public PrdOrgEmployeeRefVO queryUserOrgData(Long userId) {
        JPAQuery<PrdOrgEmployeeRefVO> jpaQuery = getJpaQueryUserOrgData();
        jpaQuery.where(qdo.userId.eq(userId));
        jpaQuery.where(qdoOrg.isCopy.eq(0));
        jpaQuery.where((qdoRef.isDefault.eq(0)).and(qdoRef.isCopy.eq(0)).and(qdoRef.deleteFlag.eq(0)));
        return jpaQuery.fetchFirst();

    }

    public List<PrdOrgEmployeeRefVO> queryUserOrgDataList() {
        JPAQuery<PrdOrgEmployeeRefVO> jpaQuery = getJpaQueryUserOrgData();
        jpaQuery.where(qdoOrg.isCopy.eq(0));
        jpaQuery.where((qdoRef.isDefault.eq(0)).and(qdoRef.isCopy.eq(0)).and(qdoRef.deleteFlag.eq(0)));
        return jpaQuery.fetch();
    }


    public Long getUserIdByV4(Long userIdV4) {
        return repo.queryUserIdV4(userIdV4);
    }

    /**
     * 根据userId 获取v4里的userId
     *
     * @param userId 用户id
     * @return {@link Long}
     */
    public Long getUserIdV4ByUserId(Long userId) {
        return repo.getUserIdV4ByUserId(userId);
    }

    public Long getV4UserId(Long userId) {
        return repo.queryV4UserId(userId);
    }


    public List<Long> queryUserIdsByNameLike(Long saleUserName) {
        return repo.queryUserIdsByNameLike(saleUserName);
    }

    public List<Map<String, Object>> getV4AndV5UserIds() {
        return repo.getV4AndV5UserIds();
    }

    /**
     * 获取BU和研发BU在职人员
     *
     * @return
     */
    public List<PrdOrgEmployeeDO> getOnJobUser() {
        return jpaQueryFactory.select(qdo)
                .from(qdo)
                .where(qdo.deleteFlag.eq(0))
                .where(qdo.resourceStatus.in("3", "5"))
                .leftJoin(qdoRef).on(qdo.userId.eq(qdoRef.userId))
                .where(qdoRef.isDefault.eq(0))
                .where(qdoRef.deleteFlag.eq(0))
                .leftJoin(qdoOrg).on(qdoRef.orgId.eq(qdoOrg.id))
                .where(qdoOrg.organizationType.in("BD", "BY"))
                .where(qdoOrg.orgName.notIn("人力资源外包部"))
                .groupBy(qdo.userId)
                .fetch();
    }

    public List<PrdOrgEmployeeRefVO> findAllByUserIds(Set<Long> userIds) {
        JPAQuery<PrdOrgEmployeeRefVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PrdOrgEmployeeRefVO.class,
                qdo.id,
                qdo.userId,
                qdo.employeeName

        )).from(qdo).where(qdo.userId.in(userIds));
        jpaQuery.where(qdo.resourceStatus.ne(String.valueOf(6)));

        return jpaQuery.fetch();
    }

    /**
     * 获取上级信息
     *
     * @return
     */
    public List<PrdOrgEmployeeSuperiorQuery> getUserSuperior() {
        return jpaQueryFactory.select(Projections.bean(PrdOrgEmployeeSuperiorQuery.class,
                        qdoRef.userId.as("employeeId"),
                        qdoRef.parentId.as("superiorId"),
                        qdo.employeeName.as("superiorName"),
                        qdo.wecomId.as("superiorWxId")
                ))
                .from(qdoRef)
                .where(qdoRef.deleteFlag.eq(0))
                .where(qdoRef.isDefault.eq(0))
                .leftJoin(qdo).on(qdoRef.parentId.eq(qdo.userId))
                .where(qdo.employeeNo.notIn("80100001", "80100098"))
                .groupBy(qdoRef.userId)
                .fetch();
    }

    /**
     * 获取部门领导信息
     *
     * @return
     */
    public List<PrdOrgEmployeeLeaderQuery> getUserBuLeader() {
        return jpaQueryFactory.select(Projections.bean(
                        PrdOrgEmployeeLeaderQuery.class,
                        qdoRef.userId.as("employeeId"),
                        qdoOrg.manageId.as("orgLeaderId"),
                        qdo.employeeName.as("orgLeaderName"),
                        qdo.wecomId.as("orgLeaderWxId")
                ))
                .from(qdoRef)
                .where(qdoRef.deleteFlag.eq(0))
                .where(qdoRef.isDefault.eq(0))
                .leftJoin(qdoOrg).on(qdoRef.orgId.eq(qdoOrg.id))
                .leftJoin(qdo).on(qdoOrg.manageId.eq(qdo.userId))
                .where(qdo.employeeNo.notIn("80100001", "80100098"))
                .groupBy(qdoRef.userId)
                .fetch();
    }


    /**
     * 获取部门负责人
     *
     * @return
     */
    public List<PrdOrgEmployeeLeaderQuery> queryOrgLeaderByUserId(Long userId) {
        return jpaQueryFactory.select(Projections.bean(
                        PrdOrgEmployeeLeaderQuery.class,
                        qdoOrg.manageId.as("orgLeaderId"),
                        qdo.employeeName.as("orgLeaderName"),
                        qdo.wecomId.as("orgLeaderWxId")
                ))
                .from(qdoOrg)
                .leftJoin(qdoRef).on(qdoRef.orgId.eq(qdoOrg.id))
                .leftJoin(qdo).on(qdoOrg.manageId.eq(qdo.userId))
                .where(qdoRef.userId.eq(userId))
                .where(qdoRef.deleteFlag.eq(0))
                .where(qdoRef.isDefault.eq(0))
                .where(qdo.deleteFlag.eq(0))
                .fetch();
    }

    public PrdOrgEmployeeRefVO queryEmployeeRef(Long userId) {

        JPAQuery<PrdOrgEmployeeRefVO> jpaQuery = getJpaQueryDefaultRefSelect();
        jpaQuery.where(qdoRef.deleteFlag.eq(0)).where(qdoRef.isDefault.eq(0)).where(qdoRef.userId.eq(userId));

        return jpaQuery.fetchFirst();
    }

    public List<PrdOrgEmployeeRefVO> queryParentIdByIds(List<Long> userIds) {
        JPAQuery<PrdOrgEmployeeRefVO> jpaQuery = getJpaQueryDefaultRefSelect();
        jpaQuery.where(qdoRef.deleteFlag.eq(0)).where(qdoRef.isDefault.eq(0)).where(qdoRef.userId.in(userIds));
        return jpaQuery.fetch();
    }

    //查询某些人的角色/根据某些人某些角色查询有哪些人
    public List<PrdSystemUserRoleVO> queryUserListRole(List<Long> userIdList, List<String> roleCodeList) {
        JPAQuery<PrdSystemUserRoleVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PrdSystemUserRoleVO.class,
                        qdoUserRole.userId,
                        qdoUserRole.roleId,
                        qdoRole.roleCode,
                        qdoRole.roleName
                )).
                from(qdoUserRole).
                leftJoin(qdoRole).on(qdoUserRole.roleId.eq(qdoRole.id)).
                where(qdoUserRole.userId.in(userIdList)).
                where(qdoUserRole.deleteFlag.eq(0)).
                where(qdoRole.deleteFlag.eq(0));
        if (!CollectionUtils.isEmpty(roleCodeList)) {
            jpaQuery.where(qdoRole.roleCode.in(roleCodeList));
        }
        return jpaQuery.fetch();
    }

    public void updateByUserId(PrdOrgEmployeePayload payload) {

        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.userId.eq(payload.getUserId()));

        if (payload.getExtString5() != null) {
            update.set(qdo.extString5, payload.getExtString5());
        }
        if (payload.getExtString1() != null) {
            update.set(qdo.extString1, payload.getExtString1());
        }
        if (payload.getExtString2() != null) {
            update.set(qdo.extString2, payload.getExtString2());
        }
        if (payload.getExtString3() != null) {
            update.set(qdo.extString3, payload.getExtString3());
        }
        if (payload.getExtString3() != null) {
            update.set(qdo.extString4, payload.getExtString4());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(payload.getResourceStatus())) {
            update.set(qdo.resourceStatus, payload.getResourceStatus());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(payload.getSalaryMethod())) {
            update.set(qdo.salaryMethod, payload.getSalaryMethod());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(payload.getSalaryPeriod())) {
            update.set(qdo.salaryPeriod, payload.getSalaryPeriod());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(payload.getCooperationMode())) {
            update.set(qdo.cooperationMode, payload.getCooperationMode());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(payload.getExtString1())) {
            update.set(qdo.extString1, payload.getExtString1());
        }
        if (payload.getEqvaRatio() != null) {
            update.set(qdo.eqvaRatio, payload.getEqvaRatio());
        }
        // 执行修改
        update.execute();

    }


    public long updateEmployeeRefByUserId(PrdOrgEmployeeRefPayload payload) {

        JPAUpdateClause update = jpaQueryFactory.update(qdoRef)
                .where(qdoRef.userId.eq(payload.getUserId()));

        if (null != payload.getOrgId()) {
            update.where(qdoRef.orgId.eq(payload.getOrgId()));
        }

        if (payload.getParentId() != null && payload.getParentId().longValue() != 0) {
            update.set(qdoRef.parentId, payload.getParentId());
        }
        if (payload.getIsDefault() != null) {
            update.set(qdoRef.isDefault, payload.getIsDefault());
        }
        if (payload.getOrgId() != null && payload.getNewOrgId().longValue() != 0) {
            update.set(qdoRef.orgId, payload.getNewOrgId());
        }
        if (payload.getJoinDate() != null) {
            update.set(qdoRef.joinDate, payload.getJoinDate());
        }
        if (payload.getRemark() != null) {
            update.set(qdoRef.remark, payload.getRemark());
        }
        // 执行修改
        return update.execute();
    }


    public void updateBlackList(Long id) {
        repo.updateBlackList(id);
    }

    public void updateUserId(Long userId, Long id) {
        repo.updateUserId(userId, id);
    }

    public void updateProcessDate(PrdOrgEmployeePayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));

        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        if (payload.getProcInstStatus() != null) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        if (payload.getSubmitTime() != null) {
            update.set(qdo.submitTime, payload.getSubmitTime());
        }
        if (payload.getApprovedTime() != null) {
            update.set(qdo.approvedTime, payload.getApprovedTime());
        }

        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qdo.procInstStatus);
            }
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
        }

        // 执行修改
        update.execute();
    }

    public Long getIdByProcId(String procId) {
        return jpaQueryFactory.select(qdo.id)
                .from(qdo)
                .where(qdo.procInstId.eq(procId))
                .fetchOne();
    }

    /**
     * 分页查询 用户与角色一一对应
     *
     * @param query
     * @return
     */
    public PagingVO<PrdOrgEmployeeVO> queryPagingRole(PrdOrgEmployeeQuery query) {
        JPAQuery<PrdOrgEmployeeVO> jpaQuery = getJpaQueryPagingRole(query);
        QueryResults<PrdOrgEmployeeVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<PrdOrgEmployeeVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    private JPAQuery<PrdOrgEmployeeVO> getJpaQueryPagingRole(PrdOrgEmployeeQuery query) {
        JPAQuery<PrdOrgEmployeeVO> jpaQuery = getJpaQueryUserRole();
        if (StringUtils.hasText(query.getKeyword())) {
            jpaQuery.where(qdoPerson.personName.like(SqlUtil.toSqlLikeString(query.getKeyword()))
                    .or(qdoRole.roleName.like(SqlUtil.toSqlLikeString(query.getKeyword()))));
        }
        jpaQuery.where(qdoRole.id.isNotNull());
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }


    /**
     * 查询上级数据
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgEmployeeRefVO> getJpaQueryParentUser() {
        return jpaQueryFactory.select(Projections.bean(PrdOrgEmployeeRefVO.class,
                qdoRef.id,
                qdoRef.userId,
                qdoRef.orgId,
                qdoRef.isDefault,
                qdoRef.parentId,
                qdo.employeeName.as("parentName"),
                qdoOrg.orgName
        )).from(qdoRef).leftJoin(qdoOrg).on(qdoOrg.id.longValue().eq(qdoRef.orgId.longValue())).leftJoin(qdo).on(qdo.userId.eq(qdoRef.parentId));
    }

    /**
     * 通过维度id查询维度下用户所有上级数据
     *
     * @param dimensionId
     * @return
     */
    public List<PrdOrgEmployeeRefVO> queryParentUsers(Long dimensionId, Long userId) {

        JPAQuery<PrdOrgEmployeeRefVO> jpaQuery = getJpaQueryParentUser();
        jpaQuery.where(qdo.deleteFlag.eq(0)).where(qdoOrg.deleteFlag.eq(0)).where(qdoRef.isCopy.eq(0));
        jpaQuery.where(qdoRef.userId.eq(userId));
        if (dimensionId != null) {
            jpaQuery.where(qdoOrg.dimensionId.eq(dimensionId));
        }
        jpaQuery.groupBy(qdoRef.parentId);
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgEmployeeRefVO> getJpaQuerySelectAllDimensionRef() {
        return jpaQueryFactory.select(Projections.bean(PrdOrgEmployeeRefVO.class,
                qdoRef.id,
                qdoRef.userId,
                qdoRef.orgId,
                qdoRef.parentId,
                qdoOrg.orgName
        )).from(qdoRef).leftJoin(qdoOrg).on(qdoOrg.id.longValue().eq(qdoRef.orgId.longValue()));
    }

    /**
     * 查询上级级关系数据
     *
     * @return 结果
     */
    public List<PrdOrgEmployeeRefVO> queryAllDimensionRef(Long dimensionId) {
        JPAQuery<PrdOrgEmployeeRefVO> jpaQuery = getJpaQuerySelectAllDimensionRef();
        jpaQuery.where(qdoOrg.deleteFlag.eq(0));
        jpaQuery.where(qdoOrg.isCopy.eq(0));
        jpaQuery.where(qdoRef.isCopy.eq(0));
        jpaQuery.where(qdoRef.deleteFlag.eq(0));
        if (dimensionId != null) {
            jpaQuery.where(qdoOrg.dimensionId.eq(dimensionId));
        }
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgEmployeeRefVO> getJpaQuerySelectLow() {
        return jpaQueryFactory.select(Projections.bean(PrdOrgEmployeeRefVO.class,
                qdoRef.id,
                qdoRef.userId,
                qdoRef.orgId,
                qdoRef.parentId,
                qdo.employeeName,
                qdoRef.joinDate,
                qdoRef.leaveDate,
                qdoRef.isDefault,
                qdoRef.remark,
                qdoRef.createUserId,
                qdoRef.createTime
        )).from(qdoRef).leftJoin(qdo).on(qdo.userId.longValue().eq(qdoRef.userId.longValue()));
    }

    /**
     * 查询个人所有下级数据
     *
     * @return 结果
     */
    public List<PrdOrgEmployeeRefVO> queryLowListByKey(Long orgId, Long userId) {
        JPAQuery<PrdOrgEmployeeRefVO> jpaQuery = getJpaQuerySelectLow();
        jpaQuery.where(qdoRef.parentId.eq(userId));
        jpaQuery.where(qdoRef.deleteFlag.eq(0));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        jpaQuery.where(qdoRef.isCopy.eq(0));
        jpaQuery.where(qdo.resourceStatus.ne(String.valueOf(6)));
        if (orgId != null) {
            jpaQuery.where(qdoRef.orgId.eq(orgId));
        }
        jpaQuery.groupBy(qdoRef.userId);
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgEmployeeRefVO> getJpaQuerySelectAllOrgRef() {
        return jpaQueryFactory.select(Projections.bean(PrdOrgEmployeeRefVO.class,
                qdoRef.id,
                qdoRef.userId,
                qdoRef.orgId,
                qdoRef.parentId

        )).from(qdoRef);
    }

    /**
     * 查询用户所有组织关系
     *
     * @return 结果
     */
    public List<PrdOrgEmployeeRefVO> queryAllOrgRefByUserId(Long userId) {
        JPAQuery<PrdOrgEmployeeRefVO> jpaQuery = getJpaQuerySelectAllOrgRef();
        jpaQuery.where(qdoRef.deleteFlag.eq(0));
        jpaQuery.where(qdoRef.isCopy.eq(0));
        if (userId != null) {
            jpaQuery.where(qdoRef.userId.eq(userId));
        }
        return jpaQuery.fetch();
    }

    /**
     * 查询下级级关系数据
     *
     * @return 结果
     */
    public List<PrdOrgEmployeeRefVO> queryAllOrgRef(Long orgId) {
        JPAQuery<PrdOrgEmployeeRefVO> jpaQuery = getJpaQuerySelectAllOrgRef();
        jpaQuery.where(qdoRef.deleteFlag.eq(0));
        jpaQuery.where(qdoRef.isCopy.eq(0));
        if (orgId != null) {
            jpaQuery.where(qdoRef.orgId.eq(orgId));
        }
        return jpaQuery.fetch();
    }


    public void updateResStatus(Long employeeId, String resStatus) {
        jpaQueryFactory.update(qdo)
                .set(qdo.resourceStatus, resStatus)
                .where(qdo.id.eq(employeeId))
                .execute();
    }

    public List<PrdOrgEmployeeVO> queryByEnrollDate(LocalDate localDate3) {
        JPAQuery<PrdOrgEmployeeVO> jpaQuery = getJpaQueryEmployeeByKey();
        jpaQuery.where(qdo.enrollDate.eq(localDate3));
        return jpaQuery.fetch();
    }

    public Long getJobInternalRecommUserId(Long userId) {
        return jpaQueryFactory.select(qdo.jobInternalRecommId)
                .from(qdo)
                .where(qdo.userId.eq(userId))
                .fetchOne();

    }

    public List<Long> getJobingUserList(PrdOrgEmployeeQuery prdOrgEmployeeQuery) {
        List<Long> res = jpaQueryFactory.select(qdo.userId).distinct()
                .from(qdo)
                .where(qdo.deleteFlag.eq(0))
                .where(qdo.resourceStatus.in(prdOrgEmployeeQuery.getResourceStatusIn()))
                .fetch();

        return res;

    }

    public void updateExitDate(Long employeeId, LocalDate date) {
        jpaQueryFactory.update(qdo)
                .set(qdo.extDate1, date)
                .where(qdo.id.eq(employeeId))
                .execute();
    }
}
