package com.elitesland.tw.tw5.server.prd.org.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "prd_org_organization_ref", indexes = {@Index(name = "dimension_index", columnList = "dimension_id"), @Index(name = "org_index", columnList = "org_id")})
@org.hibernate.annotations.Table(appliesTo = "prd_org_organization_ref", comment = "组织维度关系表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdOrgOrganizationRefDO extends BaseModel implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;


    @Comment("维度id")
    @Column(name = "dimension_id", nullable = false)
    private Long dimensionId;

    @Comment("组织id")
    @Column(name = "org_id", nullable = false)
    private Long orgId;

    @Comment("父组织Id")
    @Column()
    private Long parentId;

    @Comment("组织类型")
    @Column(columnDefinition = "tinyint  DEFAULT 1")
    private Integer orgType = 1;//1：归属组织，2：引用组织

    @Comment("排序号")
    @Column(columnDefinition = "tinyint  DEFAULT 1")
    private Integer sortIndex = 1;


    @Comment("是否是拷贝数据")
    @Column(columnDefinition = "tinyint  DEFAULT 0")
    private Integer isCopy = 0;
    
    @Comment("是否有效")
    @Column(columnDefinition = "tinyint  DEFAULT 1")
    private Integer statusFlag = 1;

    @Override
    public Object clone() {
        PrdOrgOrganizationRefDO stu = null;
        try {
            stu = (PrdOrgOrganizationRefDO) super.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return stu;
    }
}
