package com.elitesland.tw.tw5.server.prd.org.service;

import cn.hutool.core.collection.CollUtil;
import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.change.service.PrdSystemBusinessChangeService;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.OfferEntryApplyProcPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEmployeCompositeAbilityPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.EmployeeBlackListQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.OfferEntryApplyQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.*;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.*;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeeEqvaRatioPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgPersonPayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgPersonQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgPersonService;
import com.elitesland.tw.tw5.api.prd.org.vo.*;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdMessageConfigPayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.change.dao.PrdSystemBusinessChangeDAO;
import com.elitesland.tw.tw5.server.common.permission.PermissionBeanSearcherFactory;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.TwJobGradeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.convert.OfferEntryApplyConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.dao.OfferEntryApplyDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.OfferEntryApplyDO;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgEmployeeConvert;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgPersonConvert;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgPersonDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgPersonDO;
import com.elitesland.tw.tw5.server.prd.system.constant.MessageNoticeTypeEnum;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.TaskInfo;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
@Slf4j
public class PrdOrgPersonServiceImpl implements PrdOrgPersonService {

    private final PrdOrgPersonDAO prdOrgPersonDAO;

    private final PersonEduExperienceService personEduExperienceService;

    private final PersonWorkExperienceService personWorkExperienceService;

    private final PersonProjectExperienceService personProjectExperienceService;

    private final PersonCertService personCertService;

    private final PersonAccountService personAccountService;

    private final FileUtil fileUtil;

    private final WorkflowUtil workflowUtil;

    private final TransactionUtilService transactionUtilService;


    private final PrdSystemBusinessChangeService changeService;

    private final PrdSystemBusinessChangeDAO changeDAO;

    private final PrdOrgOrganizationService orgService;

    private final WorkflowService workflowService;

    @Autowired
    private final PrdOrgEmployeeService employeeService;

    private final PrdSystemRoleDAO prdSystemRoleDAO;

    private final OfferEntryApplyDAO offerEntryApplyDAO;

    private BeanSearcher beanSearcher;

    @Autowired
    public void setBeanSearcher(PermissionBeanSearcherFactory permissionBeanSearcherFactory) {
        this.beanSearcher = permissionBeanSearcherFactory.getBeanSearcherService(PermissionDomainEnum.PRD_ORG_PERSON);
    }

    private final PrdOrgEmployeeEqvaRatioService employeeEqvaRatioService;

    private final PrdEmployeCompositeAbilityService employeeAbilityService;

    private final PrdCompositeAbilityService abilityService;

    private final CacheUtil cacheUtil;

    private final PersonRewardPunishService personRewardPunishService;

    private final PrdOrgEmployeeDAO employeeDAO;


    private final PrdMessageConfigService messageConfigService;

    private final PrdSystemRoleService roleService;

    @Autowired
    @Lazy
    private PrdInternalRecommService prdInternalRecommService;


    @Override
    public PagingVO<PrdOrgPersonVO> paging(PrdOrgPersonQuery query) {
        return prdOrgPersonDAO.queryPaging(query);
    }

    @Override
    @Transactional
    public Long insert(PrdOrgPersonPayload entity) {
        if (!ObjectUtils.isEmpty(entity.getMobile()) && prdOrgPersonDAO.queryByMobile(entity.getMobile()) != null) {
            throw TwException.error("", "电话号码重复");
        }
        if (!ObjectUtils.isEmpty(entity.getIdNo()) && prdOrgPersonDAO.queryByIdNo(entity.getIdNo()) != null) {
            throw TwException.error("", "证件号重复");
        }
        if (!ObjectUtils.isEmpty(entity.getEmail()) && prdOrgPersonDAO.queryByEmail(entity.getEmail()) != null) {
            throw TwException.error("", "邮箱重复");
        }
        PrdOrgPersonDO prdOrgPersonDO = PrdOrgPersonConvert.INSTANCE.toDo(entity);
        prdOrgPersonDO.setEnabled(true);
        Long personId = prdOrgPersonDAO.save(prdOrgPersonDO).getId();

        PrdOrgEmployeeDO prdOrgEmployeeDO = new PrdOrgEmployeeDO();
        prdOrgEmployeeDO.setPersonId(personId);
        //添加人才状态为人才库
        prdOrgEmployeeDO.setResourceStatus("1");
        return employeeDAO.save(prdOrgEmployeeDO).getId();
    }

    @Override
    @Transactional
    public void update(PrdOrgPersonDetailVO entity) {
        PrdOrgPersonVO personVO = entity.getPersonVO();
        prdOrgPersonDAO.save(PrdOrgPersonConvert.INSTANCE.toDo(personVO));
        Long personId = personVO.getId();

        List<PersonEduExperienceVO> eduExperienceVOList = entity.getEduExperienceVOList();
        personEduExperienceService.saveAll(eduExperienceVOList, personId);

        List<PersonWorkExperienceVO> workExperienceVOList = entity.getWorkExperienceVOList();
        personWorkExperienceService.saveAll(workExperienceVOList, personId);

        List<PersonProjectExperienceVO> projectExperienceVOList = entity.getProjectExperienceVOList();
        personProjectExperienceService.saveAll(projectExperienceVOList, personId);

        List<PersonCertVO> certVOList = entity.getCertVOList();
        personCertService.saveAll(certVOList, personId);

        List<PersonAccountVO> accountVOList = entity.getAccountVOList();
        personAccountService.saveAll(accountVOList, personId);

        List<PersonRewardPunishVO> personRewardPunishVOList = entity.getRewardPunishVOList();
        personRewardPunishService.saveAll(personRewardPunishVOList, personId);

    }


    @Override
    public PrdOrgPersonDetailVO findById(Long id) {


        //基本信息
        Optional<PrdOrgPersonDO> prdOrgPersonDO = prdOrgPersonDAO.findById(id);
        if (prdOrgPersonDO.isEmpty()) {
            return null;
        }
        PrdOrgPersonDO prdOrgPerson = prdOrgPersonDO.get();
        PrdOrgPersonVO prdOrgPersonVO = PrdOrgPersonConvert.INSTANCE.toVo(prdOrgPerson);
        prdOrgPersonVO.setIdValidDatas(fileUtil.getFileDatas(prdOrgPersonVO.getIdValidCodes()));
        prdOrgPersonVO.setHeadDatas(fileUtil.getFileDatas(prdOrgPersonVO.getHeadCodes()));
        prdOrgPersonVO.setSelfIntroVideoDatas(fileUtil.getFileDatas(prdOrgPersonVO.getSelfIntroVideoCodes()));
        prdOrgPersonVO.setResumeDatas(fileUtil.getFileDatas(prdOrgPersonVO.getResumeCodes()));
        PrdOrgEmployeeDO prdOrgEmployeeDO = prdOrgPersonDAO.findEmployeeByPersonId(id);
        prdOrgPersonVO.setResourceStatus(prdOrgEmployeeDO.getResourceStatus());

        PrdOrgPersonDetailVO prdOrgPersonDetailVO = new PrdOrgPersonDetailVO();
        prdOrgPersonDetailVO.setPersonVO(prdOrgPersonVO);
        //教育信息
        List<PersonEduExperienceVO> eduExperienceVOList = personEduExperienceService.findAllByPersonId(id);
        prdOrgPersonDetailVO.setEduExperienceVOList(eduExperienceVOList);
        //工作经历
        List<PersonWorkExperienceVO> workExperienceVOList = personWorkExperienceService.findAllByPersonId(id);
        prdOrgPersonDetailVO.setWorkExperienceVOList(workExperienceVOList);
        //项目履历
        List<PersonProjectExperienceVO> projectExperienceVOList = personProjectExperienceService.findAllByPersonId(id);
        prdOrgPersonDetailVO.setProjectExperienceVOList(projectExperienceVOList);
        //资质证书
        List<PersonCertVO> certVOList = personCertService.findAllByPersonId(id);
        prdOrgPersonDetailVO.setCertVOList(certVOList);
        //财务信息
        List<PersonAccountVO> accountVOList = personAccountService.findAllByPersonId(id);
        prdOrgPersonDetailVO.setAccountVOList(accountVOList);

        // 内推信息
        PrdInternalRecommVO prdInternalRecommVO = prdInternalRecommService.getByPersonId(prdOrgPerson.getPersonName(), id);
        if (null != prdInternalRecommVO) {
            prdOrgPersonDetailVO.setIsJobInternalRecomm(true);
            prdOrgPersonDetailVO.setJobInternalRecommId(prdInternalRecommVO.getManagerUserId());
        }
        return prdOrgPersonDetailVO;
    }

    @Override
    @Transactional
    public void deleteById(Long id) {
        prdOrgPersonDAO.deleteById(id);

        personCertService.deleteAllByPersonId(id);

        personProjectExperienceService.deleteAllByPersonId(id);

        personWorkExperienceService.deleteAllByPersonId(id);

        personEduExperienceService.deleteAllByPersonId(id);

        personAccountService.deleteAllByPersonId(id);

        personRewardPunishService.deleteAllByPersonId(id);
    }

    @Override
    @Transactional
    public void personEntry(PrdOrgEmployeePayload entity) {

        List<OfferEntryApplyDO> offerEntryApplyDOList = offerEntryApplyDAO.queryByPersonId(entity.getPersonId());
        if (!ObjectUtils.isEmpty(offerEntryApplyDOList)) {
            for (OfferEntryApplyDO offerEntryApplyDO : offerEntryApplyDOList) {
                if (offerEntryApplyDO.getProcInstStatus().equals(ProcInstStatus.APPROVING)) {
                    throw TwException.error("", "该资源有审批中的入职流程，请勿重复提交");
                }
            }
        }
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();

        HashMap<String, Object> variables;

        Long personId = entity.getPersonId();
        entity.setId(personId);

//        changeService.saveChangeLog(ChangeTypeEnum.PERSON_ENTRY.getCode(), entity, 1);
        //参数设置
        variables = setWorkFlowVar(entity);
        String procInstName = "A30.offer入职发放流程-" + entity.getPersonName();

        //保存入职申请信息
        OfferEntryApplyDO offerEntryApplyDO = OfferEntryApplyConvert.INSTANCE.payloadToDO(entity);
        offerEntryApplyDO.setProcInstName(procInstName);
        offerEntryApplyDO.setCreateUserId(GlobalUtil.getLoginUserId());
        OfferEntryApplyDO offerEntryApplySaveDO = offerEntryApplyDAO.save(offerEntryApplyDO);

        //发起流程审批
        processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                ProcDefKey.OFFER_ENTRY.name(),
                procInstName,
                offerEntryApplySaveDO.getId() + "",
                variables)
        );

        //修改申请单审批状态
        OfferEntryApplyProcPayload offerEntryApplyProcPayload = new OfferEntryApplyProcPayload();
        offerEntryApplyProcPayload.setProcInstId(processInfo.getProcInstId());
        offerEntryApplyProcPayload.setProcInstStatus(processInfo.getProcInstStatus());
        offerEntryApplyProcPayload.setId(offerEntryApplySaveDO.getId());
        offerEntryApplyDAO.updateProcStatus(offerEntryApplyProcPayload);
        //修改资源状态
        prdOrgPersonDAO.updateApprStatus(personId, "APPROVING");
        PrdOrgEmployeeDO prdOrgEmployeeDO = prdOrgPersonDAO.findEmployeeByPersonId(personId);
        Long employeeId = prdOrgEmployeeDO.getId();
        employeeDAO.updateResStatus(employeeId, "2");
        PrdOrgEmployeePayload prdOrgEmployeePayload = new PrdOrgEmployeePayload();
        prdOrgEmployeePayload.setId(employeeId);
        prdOrgEmployeePayload.setProcInstStatus(ProcInstStatus.APPROVING);
        employeeDAO.updateProcessDate(prdOrgEmployeePayload);
        //流程启动成功后，回写业务表数据
        //修改人才库资源审批流程数据
        PrdOrgPersonPayload prdOrgPersonPayload = new PrdOrgPersonPayload();
        prdOrgPersonPayload.setProcInstId(processInfo.getProcInstId());
        prdOrgPersonPayload.setId(entity.getPersonId());
        prdOrgPersonPayload.setProcInstStatus(processInfo.getProcInstStatus());
        prdOrgPersonPayload.setSubmitTime(LocalDateTime.now());
        prdOrgPersonDAO.updateProcessDate(prdOrgPersonPayload);

        // 发通知给人事  平台员工关系主管 平台员工关系专员 平台薪酬绩效主管 平台薪酬绩效专员
        String userName = entity.getPersonName();
        String title = "offer发放及入职申请-"+userName;
        String content = "offer发放及入职申请-"+userName+"，请相关负责人及时查看";
        sendMessage(offerEntryApplySaveDO.getId(),title,content);
    }

    @Override
    @Transactional
    public void personEntryUpdate(PrdOrgEmployeePayload payload) {
        OfferEntryApplyDO offerEntryApplyDO = offerEntryApplyDAO.queryByProcId(payload.getProcInstId());

        OfferEntryApplyDO saveEntryApplyDO = OfferEntryApplyConvert.INSTANCE.payloadToDO(payload);
        saveEntryApplyDO.setProcInstName(offerEntryApplyDO.getProcInstName());
        saveEntryApplyDO.setCreateUserId(offerEntryApplyDO.getCreateUserId());
        offerEntryApplyDAO.save(saveEntryApplyDO);
        WorkflowResult<TaskInfo> taskInfo = workflowService.currentTaskInfo(payload.getProcInstId());
        if (taskInfo.getData().getTaskDefKey().equals("Activity_1fnq5fx")) {
//            BigDecimal eqvaRatio = BigDecimal.valueOf(Objects.requireNonNull(TwJobGradeEnum.getTwJobGradeEnum(payload.getExtString1())).getEqva());
            BigDecimal eqvaRatio = BigDecimal.ONE;
            PrdOrgEmployeeVO oldPrdOrgEmployeeVO = findEmployeeByPersonId(payload.getPersonId());
            payload.setId(oldPrdOrgEmployeeVO.getId());
            payload.setHrStatus("ACTIVE");
            payload.setResourceStatus("3");
            payload.setEqvaRatio(eqvaRatio);
            payload.setEnabled(true);
            payload.setUserId(oldPrdOrgEmployeeVO.getUserId());
            PrdOrgEmployeeVO prdOrgEmployeeVO = employeeService.insertNew(payload);
            Long userId = prdOrgEmployeeVO.getUserId();
            //保存复合能力
            if (!ObjectUtils.isEmpty(payload.getCapasetLevelId())) {
                PrdCompositeAbilityVO compositeAbilityVO = abilityService.findByAbilityLevelId(Long.valueOf(payload.getCapasetLevelId()));
                PrdEmployeCompositeAbilityPayload abilityPayload = new PrdEmployeCompositeAbilityPayload();
                String abilityName = compositeAbilityVO.getJobType1Desc() + "-" + compositeAbilityVO.getJobType2Desc() + "-" + compositeAbilityVO.getLevelDtlName();
                abilityPayload.setAbilityId(compositeAbilityVO.getId());
                abilityPayload.setDlRatio(compositeAbilityVO.getDlRatio());
                abilityPayload.setMainFlag(true);
                abilityPayload.setUserId(userId);
                abilityPayload.setAbilityName(abilityName);
                abilityPayload.setDocNo(compositeAbilityVO.getDocNo());
                abilityPayload.setAbilityLevelId(compositeAbilityVO.getAbilityLevelId());
                employeeAbilityService.save(abilityPayload);
            }
            payload.setUserId(userId);
            PrdOrgEmployeeEqvaRatioPayload employeeEqvaRatioPayload = new PrdOrgEmployeeEqvaRatioPayload();
            employeeEqvaRatioPayload.setEqvaRatio(eqvaRatio);
            employeeEqvaRatioPayload.setStartDate(LocalDate.now());
            employeeEqvaRatioPayload.setUserId(userId);
            employeeEqvaRatioService.upsertEqvaRatio(employeeEqvaRatioPayload);
        }
        updateWorkFlowVar(payload);
    }

    @Override
    public PrdOrgEmployeePayload personEntryQuery(String procId) {
        OfferEntryApplyDO offerEntryApplyDO = offerEntryApplyDAO.queryByProcId(procId);
        PrdOrgEmployeePayload payload = OfferEntryApplyConvert.INSTANCE.doToPayload(offerEntryApplyDO);
        payload.setHeadDatas(fileUtil.getFileDatas(payload.getHeadCodes()));
        return payload;
//        Long personId = prdOrgPersonDAO.getIdByProcId(procId);
//        Map<String, Object> stringObjectMap = changeService.getCurrentVersionLog(ChangeTypeEnum.PERSON_ENTRY.getCode(), personId.toString());
//        return JSON.parseObject(stringObjectMap.toString(), PrdOrgEmployeePayload.class);
    }


    public HashMap<String, Object> setWorkFlowVar(PrdOrgEmployeePayload entity) {

        HashMap<String, Object> variables = new HashMap<>();

        //是否总裁审批
        if (entity.getCeoApprFlag() != null) {
            variables.put("ceoApprFlag", entity.getCeoApprFlag());
        }
        //是否发放offer
        if (entity.getDeliverOffer() != null) {
            variables.put("deliverOffer", entity.getDeliverOffer());
        }
        //BU负责人审批
        Long orgId = entity.getOrgId();
        PrdOrgOrganizationVO prdOrgOrganizationVO = orgService.queryDetailSimpleByOrgId(orgId);
        if (prdOrgOrganizationVO == null) {
            throw TwException.error("", "所选部门负责人不存在");
        }
        variables.put("Activity_17afndn", CollUtil.newArrayList(prdOrgOrganizationVO.getManageId()));
        //人事经理审批
        List<Long> hrdUserIds = prdSystemRoleDAO.queryUserIdByRoleCode(RoleEnum.PLAT_HRD.getCode());
        variables.put("Activity_1ljpo8r", hrdUserIds);
        //人事专员信息录入
        List<Long> empRelIds = prdSystemRoleDAO.queryUserIdByRoleCodes(CollUtil.newArrayList(RoleEnum.PLAT_ERM.getCode(), RoleEnum.PLAT_ERS.getCode()));
        variables.put("Activity_1nxxl7l", empRelIds);
        //系统账号开通
        List<Long> itUserIds = prdSystemRoleDAO.queryUserIdByRoleCode(RoleEnum.PLATFORM_IT_ADMINISTRATOR.getCode());
        variables.put("Activity_1fnq5fx", itUserIds);
        //人事专员审批
        variables.put("Activity_1nwpb6u", empRelIds);
        //完善信息
        if (entity.getUserId() != null) {
            variables.put("Activity_1mr3mor", CollUtil.newArrayList(entity.getUserId()));
        }
        return variables;
    }


    public void updateWorkFlowVar(PrdOrgEmployeePayload entity) {
        HashMap<String, Object> variables = setWorkFlowVar(entity);
        SetVariablesPayload setVariablesPayload = new SetVariablesPayload();
        setVariablesPayload.setProcInstId(entity.getProcInstId());
        setVariablesPayload.setVariables(variables);
        workflowUtil.setVaribales(setVariablesPayload);
    }

    @Override
    @Transactional
    public void inBlackList(Long id) {
        prdOrgPersonDAO.inBlackList(id);
    }

    @Override
    @Transactional
    public void outBlackList(Long id) {
        prdOrgPersonDAO.outBlackList(id);
    }

    @Override
    public PagingVO<EmployeeBlackListVO> queryBlackList(EmployeeBlackListQuery query) {
        PagingVO<EmployeeBlackListVO> pagingVO = prdOrgPersonDAO.queryBlackListPaging(query);
        if (pagingVO != null) {
            List<EmployeeBlackListVO> blackList = pagingVO.getRecords();
            if (!ObjectUtils.isEmpty(blackList)) {
                for (EmployeeBlackListVO vo : blackList) {
                    vo.setExtString6Name(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeType.getCode(), vo.getExtString6()));
                    vo.setResourceStatusName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeResource.getCode(), vo.getResourceStatus()));
                    if (vo.getResourceStatus() == null) {
                        vo.setResourceStatus(vo.getPersonStatus());
                        vo.setResourceStatusName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeResource.getCode(), vo.getPersonStatus()));
                    }
                    if (Objects.equals(vo.getExtString6(), "INTERNAL_RES")) {
                        vo.setExtString9Name(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeInternalType.getCode(), vo.getExtString9()));
                    } else if (Objects.equals(vo.getExtString6(), "EXTERNAL_RES")) {
                        vo.setExtString9Name(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeExternalType.getCode(), vo.getExtString9()));
                    }
                }
            }
        }

        return pagingVO;
    }

    @Override
    public PagingVO<OfferEntryApplyVO> offerApplyPage(OfferEntryApplyQuery offerEntryApplyQuery) {
        PagingVO<OfferEntryApplyVO> page = offerEntryApplyDAO.queryPaging(offerEntryApplyQuery);
        if (page != null) {
            List<OfferEntryApplyVO> offerEntryApplyVOList = page.getRecords();
            if (offerEntryApplyVOList != null) {
                for (OfferEntryApplyVO offerEntryApplyVO : offerEntryApplyVOList) {
                    offerEntryApplyVO.setApplyUser(cacheUtil.getUserName(offerEntryApplyVO.getCreateUserId()));
                }
            }
        }
        return page;
    }

    @Override
    public PagingVO<PrdOrgPersonBSVO> permissionPaging(PrdOrgPersonQuery query) {

        // 构建查询参数
        MapBuilder mapBuilder = this.pageWhereBuilder(query);
        Number totalNum = beanSearcher.searchCount(PrdOrgPersonBSVO.class, mapBuilder.build());
        if (totalNum.equals(0)) {
            return null;
        }
        List<PrdOrgPersonBSVO> employeeDepartApplyVOList = beanSearcher.searchList(PrdOrgPersonBSVO.class, mapBuilder.build());

        return PagingVO.<PrdOrgPersonBSVO>builder().records(employeeDepartApplyVOList).total((Long) totalNum).build();

    }

    @Override
    public PrdOrgPersonVO getByMobile(String recommPhone) {

        List<PrdOrgPersonVO> res = prdOrgPersonDAO.getByMobile(recommPhone);
        if (CollUtil.isNotEmpty(res)) {
            return res.get(0);
        }
        return null;
    }


    /**
     * 拼装where条件
     *
     * @param query 查询条件
     * @return 检索参数构建器
     */
    private MapBuilder pageWhereBuilder(PrdOrgPersonQuery query) {
        MapBuilder builder = MapUtils.builder();

        if (StringUtils.isNotBlank(query.getPersonName())) {
            builder.field(PrdOrgPersonBSVO::getPersonName, query.getPersonName()).op(FieldOps.Contain);
        }
        if (StringUtils.isNotBlank(query.getSex())) {
            builder.field(PrdOrgPersonBSVO::getSex, query.getSex()).op(FieldOps.Equal);
        }
        if (StringUtils.isNotBlank(query.getApprStatus())) {
            builder.field(PrdOrgPersonBSVO::getApprStatus, query.getApprStatus()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getCreateTimeStart()) && !ObjectUtils.isEmpty(query.getCreateTimeEnd())) {
            builder.field(PrdOrgPersonBSVO::getCreateTime).sql(" $1 > ? and $1 < ?", query.getCreateTimeStart(), query.getCreateTimeEnd());
        }
        if (!ObjectUtils.isEmpty(query.getResourceStatus())) {
            builder.field(PrdOrgPersonBSVO::getResourceStatus, query.getResourceStatus()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getExtDate1Start()) && !ObjectUtils.isEmpty(query.getExtDate1End())) {
            builder.field(PrdOrgPersonBSVO::getExtDate1).sql(" $1 > ? and $1 < ?", query.getExtDate1Start(), query.getExtDate1End());
        }

//        builder.field(PrdOrgPersonBSVO::getDeleteFlag, 0).op(FieldOps.Equal);
        // 常用基础查询条件拼装,动态排序,分页,功能代码
        SqlUtil.handleBS(builder, query);
        return builder;
    }

    @Override
    public PrdOrgEmployeeVO findEmployeeByPersonId(Long personId) {
        PrdOrgEmployeeDO prdOrgEmployeeDO = prdOrgPersonDAO.findEmployeeByPersonId(personId);
        if (prdOrgEmployeeDO != null) {
            return PrdOrgEmployeeConvert.INSTANCE.toVo(prdOrgEmployeeDO);
        } else {
            return null;
        }
    }

    @Override
    public OfferEntryApplyVO queryOfferByKey(Long applyId) {
        return offerEntryApplyDAO.queryByKey(applyId);
    }


    // 发通知给人事  平台员工关系主管 平台员工关系专员 平台薪酬绩效主管 平台薪酬绩效专员
    public void sendMessage(Long objectId,String messageTitle,String content){
        PrdMessageConfigPayload ado = new PrdMessageConfigPayload();
        ado.setObjectId(objectId);
        ado.setMessageTitle(messageTitle);
        ado.setMessageType(2);
        ado.setContentBigType("businessMessage");
        ado.setContentType(MessageNoticeTypeEnum.personnelMessage.getCode());
        ado.setMessageTag("important");
        ado.setIsEnable(0);
        ado.setNoticeScope("appoint_people");
        ado.setNoticeWay("instation");
        ado.setReleaseSource("profileMessage");
        ado.setReleaseStatus(3);
        ado.setMessageContent(content);
        List<Long> list = new ArrayList();
        list.addAll(roleService.queryUserIdByRoleCode(RoleEnum.PLAT_ERM.getCode()));
        list.addAll(roleService.queryUserIdByRoleCode(RoleEnum.PLAT_ERS.getCode()));
        list.addAll(roleService.queryUserIdByRoleCode(RoleEnum.PLAT_SALARY_MANAGER.getCode()));
        list.addAll(roleService.queryUserIdByRoleCode(RoleEnum.PLAT_SALARY_SPECIALIST.getCode()));

        if(!CollectionUtils.isEmpty(list)){
            String noticeSource = list.stream().map(p -> p.toString()).collect(Collectors.joining(","));
            ado.setNoticeSource(noticeSource);
            //保存信息
            messageConfigService.insert(ado);
        }

    }
}
