package com.elitesland.tw.tw5.server.prd.partner.business.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.partner.business.payload.BusinessOperationSitesPayload;
import com.elitesland.tw.tw5.api.prd.partner.business.query.BusinessOperationSitesQuery;
import com.elitesland.tw.tw5.api.prd.partner.business.service.BusinessOperationSitesService;
import com.elitesland.tw.tw5.api.prd.partner.business.vo.BusinessOperationSitesVO;
import com.elitesland.tw.tw5.server.prd.partner.business.convert.BusinessOperationSitesConvert;
import com.elitesland.tw.tw5.server.prd.partner.business.dao.BusinessOperationSitesDAO;
import com.elitesland.tw.tw5.server.prd.partner.business.entity.BusinessOperationSitesDO;
import com.elitesland.tw.tw5.server.prd.partner.business.repo.BusinessOperationSitesRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Optional;

/**
 * 业务伙伴-年报网址
 *
 * @author wangly
 * @date 2023-05-16
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessOperationSitesServiceImpl extends BaseServiceImpl implements BusinessOperationSitesService {

    private final BusinessOperationSitesRepo businessOperationSitesRepo;
    private final BusinessOperationSitesDAO businessOperationSitesDAO;

    @Override
    public PagingVO<BusinessOperationSitesVO> queryPaging(BusinessOperationSitesQuery query){
        return businessOperationSitesDAO.queryPaging(query);
    }

    @Override
    public List<BusinessOperationSitesVO> queryListDynamic(BusinessOperationSitesQuery query){
        return businessOperationSitesDAO.queryListDynamic(query);
    }

    @Override
    public BusinessOperationSitesVO queryByKey(Long key) {
        BusinessOperationSitesDO entity = businessOperationSitesRepo.findById(key).orElseGet(BusinessOperationSitesDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessOperationSitesVO vo = BusinessOperationSitesConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessOperationSitesVO insert(BusinessOperationSitesPayload payload) {
        BusinessOperationSitesDO entityDo = BusinessOperationSitesConvert.INSTANCE.toDo(payload);
        return BusinessOperationSitesConvert.INSTANCE.toVo(businessOperationSitesRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessOperationSitesVO update(BusinessOperationSitesPayload payload) {
        BusinessOperationSitesDO entity = businessOperationSitesRepo.findById(payload.getId()).orElseGet(BusinessOperationSitesDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessOperationSitesDO entityDo = BusinessOperationSitesConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessOperationSitesConvert.INSTANCE.toVo(businessOperationSitesRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            businessOperationSitesDAO.deleteSoft(keys);
        }
    }

    @Override
    @Transactional
    public void deleteByPartnerId(Long partnerId) {
        businessOperationSitesDAO.deleteByPartnerId(partnerId);
    }

}
