package com.elitesland.tw.tw5.server.prd.partner.common.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.tw.tw5.api.common.annotation.FieldCreateLog;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 业务伙伴管理
 *
 * @author wangluyu
 * @date 2023-05-16
 */
@Entity
@Table(name = "com_business_partner", indexes = {
        @Index(name = "index_book_id", columnList = "book_id"),
        @Index(name = "index_partner_name", columnList = "partner_name")
})
@org.hibernate.annotations.Table(appliesTo = "com_business_partner", comment = "业务伙伴管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BusinessPartnerDO extends BaseModel implements Serializable {
    /**
     * 地址簿id 用来和银行账户 基本信息 地址信息等关联
     */
    @Comment("地址簿id 用来和银行账户 基本信息 地址信息等关联")
    @Column(name = "book_id")
    private Long bookId;

    /**
     * 地址簿id 用来和银行账户 基本信息 地址信息等关联
     */
    @Comment("tw4.0地址薄ID")
    @Column(name = "book_id_v4")
    private Long bookIdV4;

    /**
     * 唯一识别号
     */
    @Comment("唯一识别号/税号")
    @Column(name = "iden_no")
    private String idenNo;

    /**
     * 业务伙伴编号
     */
    @Comment("业务伙伴编号")
    @Column()
    private String businessPartnerNo;
    /**
     * 类型 udc[CRM:BUSINESS_PARTNER:TYPE]
     */
    @Comment("类型 udc[CRM:BUSINESS_PARTNER:TYPE]")
    @Column()
    private String partnerType;
    /**
     * 业务伙伴名称
     */
    @Comment("业务伙伴名称")
    @Column(name = "partner_name")
    @FieldCreateLog(fieldName = "业务伙伴名称")
    @FieldUpdateLog(fieldName = "业务伙伴名称")
    private String partnerName;

    /**
     * 业务伙伴名称
     */
    @Comment("业务伙伴名称拼音")
    @Column()
    private String partnerNamePinyin;

    /**
     * 业务伙伴身份 udc[CRM:BUSINESS_PARTNER:IDENTITY]
     */
    @Comment("业务伙伴身份 udc[CRM:BUSINESS_PARTNER:IDENTITY]")
    @Column()
//    @FieldUpdateLog(fieldName = "业务伙伴身份", selectionKey = "CRM:BUSINESS_PARTNER:IDENTITY")
//    @FieldCreateLog(fieldName = "业务伙伴身份", selectionKey = "CRM:BUSINESS_PARTNER:IDENTITY")
    private String partnerIdentity;
    /**
     * 行业 udc[crm:leads_customer_industry]
     */
    @Comment("行业 udc[crm:leads_customer_industry]")
    @Column()
    @FieldUpdateLog(fieldName = "行业", selectionKey = "crm:leads_customer_industry")
    @FieldCreateLog(fieldName = "行业", selectionKey = "crm:leads_customer_industry")
    private String partnerIndustry;
    /**
     * 性质 udc[cCRM:BUSINESS_PARTNER:NATURE]
     */
    @Comment("性质 udc[crm:company_nature]")
    @Column()
    @FieldUpdateLog(fieldName = "性质", selectionKey = "crm:company_nature")
    @FieldCreateLog(fieldName = "性质", selectionKey = "crm:company_nature")
    private String partnerNature;
    /**
     * 组织规模 udc[crm:customer_scale]
     */
    @Comment("组织规模 udc[crm:customer_scale]")
    @Column()
    @FieldUpdateLog(fieldName = "组织规模", selectionKey = "crm:customer_scale")
    @FieldCreateLog(fieldName = "组织规模", selectionKey = "crm:customer_scale")
    private String organizationScale;

    /**
     * 业务伙伴区域
     */
    @Comment("业务伙伴区域")
    @Column()
    private String partnerRegion;

    /**
     * 网址
     */
    @Comment("网址")
    @Column()
    @FieldCreateLog(fieldName = "网址")
    @FieldUpdateLog(fieldName = "网址")
    private String partnerWebsite;

    /**
     * 邮箱
     */
    @Comment("邮箱")
    @Column()
    @FieldCreateLog(fieldName = "邮箱")
    @FieldUpdateLog(fieldName = "邮箱")
    private String partnerEmail;
    /**
     * 传真
     */
    @Comment("传真")
    @Column()
    @FieldCreateLog(fieldName = "传真")
    @FieldUpdateLog(fieldName = "传真")
    private String partnerFax;
    /**
     * 电话
     */
    @Comment("电话")
    @Column()
    @FieldCreateLog(fieldName = "电话")
    @FieldUpdateLog(fieldName = "电话")
    private String partnerPhone;
    /**
     * 主交易货币  udc[SYSTEM_BASIC:CURRENCY]
     */
    @Comment("主交易货币  udc[SYSTEM_BASIC:CURRENCY]")
    @Column()
    @FieldUpdateLog(fieldName = "主交易货币", selectionKey = "SYSTEM_BASIC:CURRENCY")
    @FieldCreateLog(fieldName = "主交易货币", selectionKey = "SYSTEM_BASIC:CURRENCY")
    private String currency;
    /**
     * 主要语言
     */
    @Comment("主要语言")
    @Column()
//    @FieldUpdateLog(fieldName = "主要语言", selectionKey = "SYSTEM_BASIC:CURRENCY")
//    @FieldCreateLog(fieldName = "主要语言", selectionKey = "SYSTEM_BASIC:CURRENCY")
    private String language;

    /**
     * 英文名称
     */
    @Comment("英文名称")
    @Column()
    private String englishName;

    /**
     * 证件类型
     */
    @Comment("个人证件类型 udc[CRM:BUSINESS_PARTNER:CERTIFICATE_TYPE]")
    @Column()
    private String certificateType;

    /**
     * 证件号
     */
    @Comment("证件号")
    @Column()
    private String certificateNo;


    /**
     * 性别 udc[org:employee:sex]
     */
    @Comment("性别 udc[org:employee:sex]")
    @Column()
    @FieldUpdateLog(fieldName = "性别", selectionKey = "org:employee:sex")
    @FieldCreateLog(fieldName = "性别", selectionKey = "org:employee:sex")
    private String partnerSex;
    /**
     * 生日
     */
    @Comment("生日")
    @Column()
    private String partnerBirthday;

    /**
     * 国籍
     */
    @Comment("国籍 udc[SYSTEM_BASIC:COUNTRY]")
    @Column()
    private String nationality;

    /**
     * 籍贯
     */
    @Comment("籍贯")
    @Column()
    private String nativePlace;

    /**
     * 民族
     */
    @Comment("民族")
    @Column()
    private String nation;

    /**
     * 婚姻状况
     */
    @Comment("婚姻状况 udc[CRM:BUSINESS_PARTNER:MARITAL_STATUS]")
    @Column()
    private String maritalStatus;

    /**
     * 证件有效期
     */
    @Comment("证件有效期起")
    @Column()
    private LocalDate certificateDateStart;

    /**
     * 证件有效期
     */
    @Comment("证件有效期止")
    @Column()
    private LocalDate certificateDateEnd;

    /**
     * 微信
     */
    @Comment("微信")
    @Column()
    private String partnerWeChat;
//    /** 附件 */
//    @Comment("附件")
//    @Column()
//    private String fileCodes;
    /**
     * 排序号
     */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /**
     * 拓展字段1
     */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /**
     * 拓展字段2
     */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /**
     * 拓展字段3
     */
    @Comment("拓展字段3")
    @Column()
    private String ext3;
    /**
     * 拓展字段4
     */
    @Comment("拓展字段4")
    @Column()
    private String ext4;
    /**
     * 拓展字段5
     */
    @Comment("拓展字段5")
    @Column()
    private String ext5;
    /**
     * 母公司ID
     */
    @Comment("母公司ID")
    @Column()
    private Long parentId;
    /**
     * 是否有客户身份
     */
    @Comment("是否有客户身份 ")
    @Column()
    private Boolean customerFlag;
    /**
     * 是否有供应商身份
     */
    @Comment("是否有供应商身份 ")
    @Column()
    private Boolean supplierFlag;
    /**
     * 是否有合作伙伴身份
     */
    @Comment(value = "是否有合作伙伴身份")
    @Column()
    private Boolean collaborateFlag;
    /**
     * 是否有经销商身份
     */
    @Comment("是否有经销商身份 ")
    @Column()
    private Boolean distributorFlag;

    @Comment("启信宝相关数据初始化标记")
    @Column()
    private Boolean qxbDataInitFlag = Boolean.FALSE;
    /**
     * 禁用标记
     */
    @Comment(value = "禁用标记")
    @Column(columnDefinition = "tinyint  DEFAULT 0")
    private Integer disabledFlag;

    /**
     * 数据同步4.0标志
     */
    @Comment("数据同步4.0标志")
    @Column()
    private Boolean dataSyncToFourFlag;

    /**
     * 数据迁移标志
     */
    @Comment("数据迁移标志")
    @Column()
    private Boolean dataTransferFlag;

    /**
     * 第三方系统编号
     */
    @Comment("第三方系统编号")
    @Column()
    private String thirdSystemNo;

    /**
     * 审批状态
     */
    @Comment("审批状态")
    @Column()
    private String apprStatus;
    /**
     * 流程实例ID
     */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    /**
     * 申请状态
     */
    @Comment("申请状态")
    @Column()
    private String applyStatus;

    /**
     * 内部/外部
     */
    @Comment("内部/外部")
    @Column()
    private String insideOrOutSide;

    @Comment("同步时间")
    @Column()
    private LocalDateTime syncTime;

    @Comment("jde公司编码")
    @Column()
    private String jdeCompanyNo;

    @Comment("jde公司编码")
    @Column()
    private String sortIndex;

    public void copy(BusinessPartnerDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
