package com.elitesland.tw.tw5.server.prd.partner.constants;

import lombok.Getter;

public enum BusinessSelectionEnum {
    YEAR("CRM:BUSINESS_STRATEGY_MODEL:DATE:YEAR", "近一年"),
    YEAR_MONTH("CRM:BUSINESS_STRATEGY_MODEL:DATE:YEAR:MONTH", "近一年-月份"),
    YEAR_FREQUENCY("CRM:BUSINESS_STRATEGY_MODEL:DATE:YEAR:FREQUENCY", "近一年-频率"),
    YEAR_AMOUNT("CRM:BUSINESS_STRATEGY_MODEL:DATE:YEAR:AMOUNT", "近一年-金额"),
    HALFYEAR("CRM:BUSINESS_STRATEGY_MODEL:DATE:HALFYEAR", "近半年"),
    HALFYEAR_MONTH("CRM:BUSINESS_STRATEGY_MODEL:DATE:HALFYEAR:MONTH", "近半年-月份"),
    HALFYEAR_FREQUENCY("CRM:BUSINESS_STRATEGY_MODEL:DATE:HALFYEAR:FREQUENCY", "近半年-频率"),
    HALFYEAR_AMOUNT("CRM:BUSINESS_STRATEGY_MODEL:DATE:HALFYEAR:AMOUNT", "近半年-金额"),
    CUSTOMER("CRM:BUSINESS_PARTNER:IDENTITY:CUSTOMER", "客户"),
    SUPPLIER("CRM:BUSINESS_PARTNER:IDENTITY:SUPPLIER", "供应商"),
    COLLABORATE("CRM:BUSINESS_PARTNER:IDENTITY:COLLABORATE", "合作伙伴"),
    DISTRIBUTOR("CRM:BUSINESS_PARTNER:IDENTITY:DISTRIBUTORT", "经销商");
    @Getter
    private final String code;

    /**
     * 描述
     */
    @Getter
    private final String desc;

    BusinessSelectionEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}
