package com.elitesland.tw.tw5.server.prd.partner.identity.controller;

import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessCollaboratePartnerInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.query.BusinessCollaboratePartnerInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCollaboratePartnerInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCollaboratePartnerInfoVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 业务伙伴-合作伙伴
 *
 * @author wangly
 * @date 2023-05-16
 */
@Api(tags = "业务伙伴-合作伙伴")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/businessCollaboratePartnerInfo")
@Slf4j
public class BusinessCollaboratePartnerInfoController {

    private final BusinessCollaboratePartnerInfoService businessCollaboratePartnerInfoService;

    /**
     * 业务伙伴-合作伙伴-新增
     *

     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("业务伙伴-合作伙伴-新增")
    public TwOutputUtil insert(@RequestBody BusinessCollaboratePartnerInfoPayload payload){
        return TwOutputUtil.ok(businessCollaboratePartnerInfoService.insert(payload));
    }

    /**
     * 业务伙伴-合作伙伴-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("业务伙伴-合作伙伴-更新")
    public TwOutputUtil update(@RequestBody BusinessCollaboratePartnerInfoPayload payload){
        return TwOutputUtil.ok(businessCollaboratePartnerInfoService.update(payload));
    }

//    /**
//     * 业务伙伴-合作伙伴-主键查询 暂且没用 需要可放开
//     *
//     * @param key 关键
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/{key}")
//    @UdcNameClass
//    @ApiOperation("业务伙伴-合作伙伴-主键查询")
//    public TwOutputUtil<BusinessCollaboratePartnerInfoVO> queryOneByKey(@PathVariable Long key) {
//        return TwOutputUtil.ok(businessCollaboratePartnerInfoService.queryByKey(key));
//    }

//    /**
//     * 业务伙伴-合作伙伴-分页 暂且没用 需要可放开
//     *
//     * @param query 查询
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/paging")
//    @UdcNameClass
//    @ApiOperation("业务伙伴-合作伙伴-分页")
//    public TwOutputUtil<PagingVO<BusinessCollaboratePartnerInfoVO>> paging(BusinessCollaboratePartnerInfoQuery query) {
//        return TwOutputUtil.ok(businessCollaboratePartnerInfoService.queryPaging(query));
//    }

    /**
     * 业务伙伴-合作伙伴-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("业务伙伴-合作伙伴-查询列表")
    public TwOutputUtil<List<BusinessCollaboratePartnerInfoVO>> queryList(BusinessCollaboratePartnerInfoQuery query) {
        return TwOutputUtil.ok(businessCollaboratePartnerInfoService.queryListDynamic(query));
    }

    /**
     * 业务伙伴-合作伙伴-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("业务伙伴-合作伙伴-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        businessCollaboratePartnerInfoService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 业务伙伴-合作伙伴激活带流程
     *
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/activeCollaboratePartnerWithWorkFlow")
    @ApiOperation("业务伙伴-合作伙伴-激活")
    public TwOutputUtil activeCollaboratePartnerWithWorkFlow(Long partnerId,String partnerName){
        businessCollaboratePartnerInfoService.activeCollaboratePartnerWithWorkFlow(partnerId,partnerName);
        return TwOutputUtil.ok();
    }

    /**
     * 业务伙伴-合作伙伴激活
     *
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/activeCollaboratePartner")
    @ApiOperation("业务伙伴-合作伙伴-激活")
    public TwOutputUtil activeCollaboratePartner(Long partnerId,String partnerName){
        businessCollaboratePartnerInfoService.activeCollaboratePartner(partnerId,partnerName);
        return TwOutputUtil.ok();
    }


}
