package com.elitesland.tw.tw5.server.prd.partner.strategy.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessModelIndexPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessModelIndexQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.service.BusinessModelIndexService;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessModelIndexVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 分级策略模型指标
 *
 * @folder 分级策略-模型指标
 * @author wangly
 * @date 2023-06-19
 */
@Api(tags = "分级策略模型指标")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/businessModelIndex")
@Slf4j
public class BusinessModelIndexController {

private final BusinessModelIndexService businessModelIndexService;

    /**
     * 分级策略模型指标-新增
     *
     * @folder 分级策略-模型指标
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("分级策略模型指标-新增")
    public TwOutputUtil<BusinessModelIndexVO> insert(@RequestBody BusinessModelIndexPayload payload){
         return TwOutputUtil.ok(businessModelIndexService.insert(payload));
    }

    /**
     * 分级策略模型指标-更新
     *
         * @folder 分级策略-模型指标
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("分级策略模型指标-更新")
    public TwOutputUtil<BusinessModelIndexVO> update(@RequestBody BusinessModelIndexPayload payload){
        return TwOutputUtil.ok(businessModelIndexService.update(payload));
    }

    /**
     * 分级策略模型指标-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @folder 分级策略-模型指标
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("分级策略模型指标-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody BusinessModelIndexPayload payload){
        return TwOutputUtil.ok(businessModelIndexService.updateByKeyDynamic(payload));
    }

    /**
     * 分级策略模型指标-主键查询
     *
     * @folder 分级策略-模型指标
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("分级策略模型指标-主键查询")
    public TwOutputUtil<BusinessModelIndexVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(businessModelIndexService.queryByKey(key));
    }

    /**
     * 分级策略模型指标-分页
     *
         * @folder 分级策略-模型指标
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("分级策略模型指标-分页")
    public TwOutputUtil<PagingVO<BusinessModelIndexVO>> paging(BusinessModelIndexQuery query) {
        return TwOutputUtil.ok(businessModelIndexService.queryPaging(query));
    }

    /**
     * 分级策略模型指标-查询列表
     *
     * @folder 分级策略-模型指标
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("分级策略模型指标-查询列表")
    public TwOutputUtil<List<BusinessModelIndexVO>> queryList(BusinessModelIndexQuery query) {
        return TwOutputUtil.ok(businessModelIndexService.queryListDynamic(query));
    }

    /**
     * 分级策略模型指标-删除
     *
         * @folder 分级策略-模型指标
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("分级策略模型指标-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         businessModelIndexService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

