package com.elitesland.tw.tw5.server.prd.partner.strategy.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessModelIndexSettingPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessModelIndexSettingQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.service.BusinessModelIndexSettingService;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessModelIndexSettingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 分级策略模型指标配置
 *
 * @folder 分级策略-模型指标配置
 * @author wangly
 * @date 2023-06-19
 */
@Api(tags = "分级策略模型指标配置")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/businessModelIndexSetting")
@Slf4j
public class BusinessModelIndexSettingController {

private final BusinessModelIndexSettingService businessModelIndexSettingService;

    /**
     * 分级策略模型指标配置-新增
     *
     * @folder 分级策略-模型指标配置
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("分级策略模型指标配置-新增")
    public TwOutputUtil<BusinessModelIndexSettingVO> insert(@RequestBody BusinessModelIndexSettingPayload payload){
         return TwOutputUtil.ok(businessModelIndexSettingService.insert(payload));
    }

    /**
     * 分级策略模型指标配置-更新
     *
         * @folder 分级策略-模型指标配置
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("分级策略模型指标配置-更新")
    public TwOutputUtil<BusinessModelIndexSettingVO> update(@RequestBody BusinessModelIndexSettingPayload payload){
        return TwOutputUtil.ok(businessModelIndexSettingService.update(payload));
    }

    /**
     * 分级策略模型指标配置-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @folder 分级策略-模型指标配置
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("分级策略模型指标配置-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody BusinessModelIndexSettingPayload payload){
        return TwOutputUtil.ok(businessModelIndexSettingService.updateByKeyDynamic(payload));
    }

    /**
     * 分级策略模型指标配置-主键查询
     *
     * @folder 分级策略-模型指标配置
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("分级策略模型指标配置-主键查询")
    public TwOutputUtil<BusinessModelIndexSettingVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(businessModelIndexSettingService.queryByKey(key));
    }

    /**
     * 分级策略模型指标配置-分页
     *
         * @folder 分级策略-模型指标配置
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("分级策略模型指标配置-分页")
    public TwOutputUtil<PagingVO<BusinessModelIndexSettingVO>> paging(BusinessModelIndexSettingQuery query) {
        return TwOutputUtil.ok(businessModelIndexSettingService.queryPaging(query));
    }

    /**
     * 分级策略模型指标配置-查询列表
     *
     * @folder 分级策略-模型指标配置
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("分级策略模型指标配置-查询列表")
    public TwOutputUtil<List<BusinessModelIndexSettingVO>> queryList(BusinessModelIndexSettingQuery query) {
        return TwOutputUtil.ok(businessModelIndexSettingService.queryListDynamic(query));
    }

    /**
     * 分级策略模型指标配置-删除
     *
         * @folder 分级策略-模型指标配置
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("分级策略模型指标配置-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         businessModelIndexSettingService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

