package com.elitesland.tw.tw5.server.prd.partner.strategy.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessStrategyPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessStrategyQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.service.BusinessStrategyService;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 分级策略
 *
 * @folder 分级策略
 * @author wangly
 * @date 2023-06-16
 */
@Api(tags = "分级策略")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/businessStrategy")
@Slf4j
public class BusinessStrategyController {

private final BusinessStrategyService businessStrategyService;

    /**
     * 分级策略-保存
     *
     * @folder 分级策略
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("分级策略-保存")
    public TwOutputUtil save(@RequestBody BusinessStrategyPayload payload){
        businessStrategyService.save(payload);
         return TwOutputUtil.ok();
    }

    /**
     * 分级策略-更新
     *
         * @folder 分级策略
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("分级策略-更新")
    public TwOutputUtil<BusinessStrategyVO> update(@RequestBody BusinessStrategyPayload payload){
        return TwOutputUtil.ok(businessStrategyService.update(payload));
    }

    /**
     * 分级策略-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @folder 分级策略
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("分级策略-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody BusinessStrategyPayload payload){
        return TwOutputUtil.ok(businessStrategyService.updateByKeyDynamic(payload));
    }

    /**
     * 分级策略-主键查询
     *
     * @folder 分级策略
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("分级策略-主键查询")
    public TwOutputUtil<BusinessStrategyVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(businessStrategyService.queryByKey(key));
    }

    /**
     * 分级策略-分页
     *
         * @folder 分级策略
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("分级策略-分页")
    public TwOutputUtil<PagingVO<BusinessStrategyVO>> paging(BusinessStrategyQuery query) {
        return TwOutputUtil.ok(businessStrategyService.queryPaging(query));
    }

    /**
     * 分级策略-查询列表
     *
     * @folder 分级策略
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("分级策略-查询列表")
    public TwOutputUtil<List<BusinessStrategyVO>> queryList(BusinessStrategyQuery query) {
        return TwOutputUtil.ok(businessStrategyService.queryListDynamic(query));
    }

    /**
     * 分级策略-删除
     *
         * @folder 分级策略
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("分级策略-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         businessStrategyService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 分级策略-更新状态
     *
     * @folder 分级策略
     * @param keys 主键id
     * @param strategyStatus 状态
     * @return result
     */
    @GetMapping("/updateStrategyStatus")
    @ApiOperation("分级策略-更新状态")
    public TwOutputUtil updateStrategyStatus(Long[] keys,String strategyStatus) {
        businessStrategyService.updateStrategyStatus(Arrays.asList(keys),strategyStatus);
        return TwOutputUtil.ok();
    }

    @GetMapping("/businessStrategyJobHandler")
    @ApiOperation("分级策略-测试定时任务")
    public void businessStrategyJobHandler(){
        businessStrategyService.businessStrategyJobHandler();
    }
}

