package com.elitesland.tw.tw5.server.prd.partner.strategy.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessStrategyIndexSettingPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessStrategyIndexSettingQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.service.BusinessStrategyIndexSettingService;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyIndexSettingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 分级策略指标配置
 *
 * @folder 分级策略-指标配置
 * @author wangly
 * @date 2023-06-19
 */
@Api(tags = "分级策略指标配置")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/businessStrategyIndexSetting")
@Slf4j
public class BusinessStrategyIndexSettingController {

private final BusinessStrategyIndexSettingService businessStrategyIndexSettingService;

    /**
     * 分级策略指标配置-新增
     *
     * @folder 分级策略-指标配置
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("分级策略指标配置-新增")
    public TwOutputUtil<BusinessStrategyIndexSettingVO> insert(@RequestBody BusinessStrategyIndexSettingPayload payload){
         return TwOutputUtil.ok(businessStrategyIndexSettingService.insert(payload));
    }

    /**
     * 分级策略指标配置-更新
     *
         * @folder 分级策略-指标配置
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("分级策略指标配置-更新")
    public TwOutputUtil<BusinessStrategyIndexSettingVO> update(@RequestBody BusinessStrategyIndexSettingPayload payload){
        return TwOutputUtil.ok(businessStrategyIndexSettingService.update(payload));
    }

    /**
     * 分级策略指标配置-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @folder 分级策略-指标配置
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("分级策略指标配置-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody BusinessStrategyIndexSettingPayload payload){
        return TwOutputUtil.ok(businessStrategyIndexSettingService.updateByKeyDynamic(payload));
    }

    /**
     * 分级策略指标配置-主键查询
     *
     * @folder 分级策略-指标配置
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("分级策略指标配置-主键查询")
    public TwOutputUtil<BusinessStrategyIndexSettingVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(businessStrategyIndexSettingService.queryByKey(key));
    }

    /**
     * 分级策略指标配置-分页
     *
         * @folder 分级策略-指标配置
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("分级策略指标配置-分页")
    public TwOutputUtil<PagingVO<BusinessStrategyIndexSettingVO>> paging(BusinessStrategyIndexSettingQuery query) {
        return TwOutputUtil.ok(businessStrategyIndexSettingService.queryPaging(query));
    }

    /**
     * 分级策略指标配置-查询列表
     *
     * @folder 分级策略-指标配置
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("分级策略指标配置-查询列表")
    public TwOutputUtil<List<BusinessStrategyIndexSettingVO>> queryList(BusinessStrategyIndexSettingQuery query) {
        return TwOutputUtil.ok(businessStrategyIndexSettingService.queryListDynamic(query));
    }

    /**
     * 分级策略指标配置-删除
     *
         * @folder 分级策略-指标配置
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("分级策略指标配置-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         businessStrategyIndexSettingService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

