package com.elitesland.tw.tw5.server.prd.partner.strategy.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessStrategyModelPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessStrategyModelQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.service.BusinessStrategyModelService;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessModelIndexVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyModelVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

/**
 * 分级策略模型配置
 *
 * @folder 分级策略-模型配置
 * @author wangly
 * @date 2023-06-19
 */
@Api(tags = "分级策略模型配置")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/businessStrategyModel")
@Slf4j
public class BusinessStrategyModelController {

private final BusinessStrategyModelService businessStrategyModelService;

    /**
     * 分级策略模型配置-新增
     *
     * @folder 分级策略-模型配置
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("分级策略模型配置-保存")
    public TwOutputUtil<BusinessStrategyModelVO> save(@RequestBody BusinessStrategyModelPayload payload){
         return TwOutputUtil.ok(businessStrategyModelService.save(payload));
    }

//    /**
//     * 分级策略模型配置-更新
//     *
//         * @folder 分级策略-模型配置
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping
//    @ApiOperation("分级策略模型配置-更新")
//    public TwOutputUtil<BusinessStrategyModelVO> update(@RequestBody BusinessStrategyModelPayload payload){
//        return TwOutputUtil.ok(businessStrategyModelService.update(payload));
//    }

//    /**
//     * 分级策略模型配置-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
//     *
//     * @folder 分级策略-模型配置
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping("update")
//    @ApiOperation("分级策略模型配置-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
//    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody BusinessStrategyModelPayload payload){
//        return TwOutputUtil.ok(businessStrategyModelService.updateByKeyDynamic(payload));
//    }

    /**
     * 分级策略模型配置-主键查询
     *
     * @folder 分级策略-模型配置
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("分级策略模型配置-主键查询")
    public TwOutputUtil<BusinessStrategyModelVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(businessStrategyModelService.queryByKey(key));
    }

    /**
     * 分级策略模型配置-分页
     *
     * @folder 分级策略-模型配置
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("分级策略模型配置-分页")
    public TwOutputUtil<PagingVO<BusinessStrategyModelVO>> paging(BusinessStrategyModelQuery query) {
        return TwOutputUtil.ok(businessStrategyModelService.queryPaging(query));
    }

    /**
     * 分级策略模型配置-查询列表
     *
     * @folder 分级策略-模型配置
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("分级策略模型配置-查询列表")
    public TwOutputUtil<List<BusinessStrategyModelVO>> queryList(BusinessStrategyModelQuery query) {
        return TwOutputUtil.ok(businessStrategyModelService.queryListDynamic(query));
    }

    /**
     * 分级策略模型配置-删除
     *
         * @folder 分级策略-模型配置
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("分级策略模型配置-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         businessStrategyModelService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 分级策略模型配置-通过时间查询RFM配置
     *
     * @folder 分级策略-模型配置
     * @param dateKey 近半年/近一年
     * @return result
     */
    @GetMapping("/findRfmByDate")
    @UdcNameClass
    @ApiOperation("分级策略模型配置-通过时间查询RFM配置")
    public TwOutputUtil<BusinessStrategyModelVO> findRfmSettingByDate(String dateKey,Long modelId) {
        List<BusinessModelIndexVO> businessModelIndexVO = businessStrategyModelService.findRfmSettingByDate(dateKey);
        BusinessStrategyModelVO businessStrategyModelVO = new BusinessStrategyModelVO();
        businessStrategyModelVO.setBusinessModelIndexVOList(businessModelIndexVO);
        businessStrategyModelVO.setRWeight(BigDecimal.ZERO);
        businessStrategyModelVO.setFWeight(BigDecimal.ZERO);
        businessStrategyModelVO.setMWeight(BigDecimal.ZERO);
        if(modelId!=null){
            BusinessStrategyModelVO vo = businessStrategyModelService.queryByKey(modelId);
            if(vo!=null){
                businessStrategyModelVO.setRWeight(vo.getRWeight());
                businessStrategyModelVO.setFWeight(vo.getFWeight());
                businessStrategyModelVO.setMWeight(vo.getMWeight());
            }
        }
        return TwOutputUtil.ok(businessStrategyModelVO);
    }

    /**
     * 分级策略模型配置-校验是否有关联的分级策略
     *
     * @param modelId business_strategy_model 模型id
     * @return result
     */
    @GetMapping("/checkAssociationStrategy")
    @ApiOperation("分级策略模型配置-通过时间查询RFM配置")
    public TwOutputUtil<Boolean> checkAssociationStrategy(Long modelId){

        return TwOutputUtil.ok(businessStrategyModelService.checkAssociationStrategy(modelId));
    }
}

