package com.elitesland.tw.tw5.server.prd.personplan.service;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PersonPlanVersionPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PersonPlanVersionQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanVersionService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanVersionVO;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.personplan.convert.PersonPlanVersionConvert;
import com.elitesland.tw.tw5.server.prd.personplan.dao.PersonPlanVersionDAO;
import com.elitesland.tw.tw5.server.prd.personplan.entity.PersonPlanVersionDO;
import com.elitesland.tw.tw5.server.prd.personplan.repo.PersonPlanVersionRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * 人员规划版本
 *
 * @author wangly
 * @date 2024-04-07
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PersonPlanVersionServiceImpl extends BaseServiceImpl implements PersonPlanVersionService {

    private final PersonPlanVersionRepo personPlanVersionRepo;
    private final PersonPlanVersionDAO personPlanVersionDAO;
    private final FileUtil fileUtil;
    @Override
    public PagingVO<PersonPlanVersionVO> queryPaging(PersonPlanVersionQuery query){
        return personPlanVersionDAO.queryPaging(query);
    }

    @Override
    public List<PersonPlanVersionVO> queryListDynamic(PersonPlanVersionQuery query){
        return personPlanVersionDAO.queryListDynamic(query);
    }

    @Override
    public PersonPlanVersionVO queryByKey(Long key) {
        PersonPlanVersionDO entity = personPlanVersionRepo.findById(key).orElseGet(PersonPlanVersionDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PersonPlanVersionVO vo = PersonPlanVersionConvert.INSTANCE.toVo(entity);
        PersonPlanVO personPlanVO = JSONObject.parseObject(vo.getChangeContent(), PersonPlanVO.class);
        if(personPlanVO!=null && StringUtils.hasText(personPlanVO.getFileCodes())){
            personPlanVO.setFileDatas(fileUtil.getFileDatas(personPlanVO.getFileCodes()));
        }
        vo.setPersonPlanVO(personPlanVO);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long save(PersonPlanVersionPayload payload) {
        String planType = payload.getPlanType();
        Long objId = payload.getObjId();
        //查询原表数据并保存
        PersonPlanVersionQuery query = new PersonPlanVersionQuery();
        query.setObjId(objId);
        query.setPlanId(payload.getPlanId());
        query.setPlanType(planType);
        List<PersonPlanVersionVO> personPlanVersionVOS = queryListDynamic(query);
        PersonPlanVersionDO personPlanVersionDO = PersonPlanVersionConvert.INSTANCE.toDo(payload);
        if (CollectionUtils.isEmpty(personPlanVersionVOS)) {
            personPlanVersionDO.setVersionNo(0);
        }else {
            personPlanVersionDO.setVersionNo(personPlanVersionVOS.size());
        }
        PersonPlanVersionDO save = personPlanVersionRepo.save(personPlanVersionDO);
        if (save == null) {
            return -1L;
        }

        return save.getId();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PersonPlanVersionVO update(PersonPlanVersionPayload payload) {
        PersonPlanVersionDO entity = personPlanVersionRepo.findById(payload.getId()).orElseGet(PersonPlanVersionDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PersonPlanVersionDO entityDo = PersonPlanVersionConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PersonPlanVersionConvert.INSTANCE.toVo(personPlanVersionRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PersonPlanVersionPayload payload) {
        PersonPlanVersionDO entity = personPlanVersionRepo.findById(payload.getId()).orElseGet(PersonPlanVersionDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = personPlanVersionDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            personPlanVersionDAO.deleteSoft(keys);
        }
    }

}
