package com.elitesland.tw.tw5.server.prd.pms.controller;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsDistributePayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsDistributeQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsDistributeService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsDistributeVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.seata.spring.annotation.GlobalTransactional;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 派发
 *
 * @author xxb
 * @date 2023-08-07
 */
@Api(tags = "派发")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/pmsDistribute")
@Slf4j
public class PmsDistributeController {

    private final PmsDistributeService pmsDistributeService;

    /**
     * 任务授权管理-新增或修改
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("insertOrUpdate")
    @ApiOperation("派发-新增或修改")
    @GlobalTransactional
    public TwOutputUtil<PmsDistributeVO> insertOrUpdate(@RequestBody PmsDistributePayload payload) {
        pmsDistributeService.insertOrUpdate(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 派发-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("派发-主键查询")
    public TwOutputUtil<PmsDistributeVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(pmsDistributeService.queryByKey(key));
    }

    /**
     * 根据派发事由和事由主键查询
     *
     * @param reasonId   事由id
     * @param reasonType 事由类型
     * @return
     */
    @GetMapping("/queryByReason")
    @UdcNameClass
    @ApiOperation("根据派发事由和事由主键查询")
    public TwOutputUtil<PmsDistributeVO> queryByReason(Long reasonId, String reasonType) {
        return TwOutputUtil.ok(pmsDistributeService.queryByReason(reasonId, reasonType));
    }

    /**
     * 我的派发、派发列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("我的派发/派发列表-分页")
    public TwOutputUtil<PagingVO<PmsDistributeVO>> paging(PmsDistributeQuery query) {
        return TwOutputUtil.ok(pmsDistributeService.queryPaging(query));
    }

    /**
     * 我收到的响应
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/iReceivedRespond")
    @UdcNameClass
    @ApiOperation("我收到的响应-分页")
    public TwOutputUtil<PagingVO<PmsDistributeVO>> iReceivedRespond(PmsDistributeQuery query) {
        return TwOutputUtil.ok(pmsDistributeService.iReceivedRespond(query));
    }

    /**
     * 我收到的邀请
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/iReceivedInvitation")
    @UdcNameClass
    @ApiOperation("我收到的邀请-分页")
    public TwOutputUtil<PagingVO<PmsDistributeVO>> iReceivedInvitation(PmsDistributeQuery query) {
        return TwOutputUtil.ok(pmsDistributeService.iReceivedInvitation(query));
    }

    /**
     * 广播看板
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/broadcastTaskKanban")
    @UdcNameClass
    @ApiOperation("广播看板-分页")
    public TwOutputUtil<PagingVO<PmsDistributeVO>> broadcastTaskKanban(PmsDistributeQuery query) {
        return TwOutputUtil.ok(pmsDistributeService.broadcastTaskKanban(query));
    }

    /**
     * 我响应的广播
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/irespondedBroadcast")
    @UdcNameClass
    @ApiOperation("我响应的广播-分页")
    public TwOutputUtil<PagingVO<PmsDistributeVO>> irespondedBroadcast(PmsDistributeQuery query) {
        return TwOutputUtil.ok(pmsDistributeService.irespondedBroadcast(query));
    }

    /**
     * 派发-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("派发-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        pmsDistributeService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

//    /**
//     * 设置接收资源
//     *
//     * @param distId
//     * @param resId
//     */
//    @GetMapping("/setReceiverResId")
//    @ApiOperation("设置接收资源")
//    public TwOutputUtil setReceiverResId(long distId, long resId) {
//        pmsDistributeService.setReceiverResId(distId, resId);
//        return TwOutputUtil.ok();
//    }

    //
//    /**
//     * 派发-查询列表
//     *
//     * @param query 查询
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/list")
//    // @UdcNameClass
//    @ApiOperation("派发-查询列表")
//    public TwOutputUtil<List<PmsDistributeVO>> queryList(PmsDistributeQuery query) {
//        return TwOutputUtil.ok(pmsDistributeService.queryListDynamic(query));
//    }
//

    //    /**
//     * 派发-新增
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PostMapping
//    @ApiOperation("派发-新增")
//    public TwOutputUtil<PmsDistributeVO> insert(@RequestBody PmsDistributePayload payload){
//        return TwOutputUtil.ok(pmsDistributeService.insert(payload));
//    }

//    /**
//     * 派发-更新
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping
//    @ApiOperation("派发-更新")
//    public TwOutputUtil<PmsDistributeVO> update(@RequestBody PmsDistributePayload payload){
//        return TwOutputUtil.ok(pmsDistributeService.update(payload));
//    }

}
